/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.jdbc.common.dao;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.lang.reflect.Type;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.skywalking.oap.server.core.query.type.PprofEventType;
import org.apache.skywalking.oap.server.core.query.type.PprofTask;
import org.apache.skywalking.oap.server.core.storage.profiling.pprof.IPprofTaskQueryDAO;
import org.apache.skywalking.oap.server.library.client.jdbc.hikaricp.JDBCClient;
import org.apache.skywalking.oap.server.library.util.StringUtil;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.common.TableHelper;

public class JDBCPprofTaskQueryDAO
implements IPprofTaskQueryDAO {
    private static final Gson GSON = new Gson();
    private final JDBCClient jdbcClient;
    private final TableHelper tableHelper;

    public List<PprofTask> getTaskList(String serviceId, Long startTimeBucket, Long endTimeBucket, Integer limit) throws IOException {
        ArrayList<PprofTask> results = new ArrayList<PprofTask>();
        List<String> tables = startTimeBucket == null || endTimeBucket == null ? this.tableHelper.getTablesWithinTTL("pprof_task") : this.tableHelper.getTablesForRead("pprof_task", startTimeBucket, endTimeBucket);
        for (String table : tables) {
            ArrayList<Object> condition = new ArrayList<Object>(4);
            StringBuilder sql = new StringBuilder().append("select * from ").append(table).append(" where ").append("table_name").append(" = ?");
            condition.add("pprof_task");
            if (StringUtil.isNotEmpty((String)serviceId)) {
                sql.append(" and ").append("service_id").append("=? ");
                condition.add(serviceId);
            }
            if (startTimeBucket != null) {
                sql.append(" and ").append("time_bucket").append(" >= ? ");
                condition.add(startTimeBucket);
            }
            if (endTimeBucket != null) {
                sql.append(" and ").append("time_bucket").append(" <= ? ");
                condition.add(endTimeBucket);
            }
            sql.append(" ORDER BY ").append("create_time").append(" DESC ");
            if (limit != null) {
                sql.append(" LIMIT ").append(limit);
            }
            results.addAll((Collection)this.jdbcClient.executeQuery(sql.toString(), resultSet -> {
                ArrayList<PprofTask> tasks = new ArrayList<PprofTask>();
                while (resultSet.next()) {
                    tasks.add(this.buildPprofTask(resultSet));
                }
                return tasks;
            }, condition.toArray(new Object[0])));
        }
        return limit == null ? results : results.stream().limit(limit.intValue()).collect(Collectors.toList());
    }

    public PprofTask getById(String id) throws IOException {
        List<String> tables = this.tableHelper.getTablesWithinTTL("pprof_task");
        for (String table : tables) {
            StringBuilder sql = new StringBuilder();
            ArrayList<String> condition = new ArrayList<String>(1);
            sql.append("select * from ").append(table).append(" where ").append("table_name").append(" = ? ").append(" and ").append("task_id=? LIMIT 1");
            condition.add("pprof_task");
            condition.add(id);
            PprofTask r = (PprofTask)this.jdbcClient.executeQuery(sql.toString(), resultSet -> {
                if (resultSet.next()) {
                    return this.buildPprofTask(resultSet);
                }
                return null;
            }, condition.toArray(new Object[0]));
            if (r == null) continue;
            return r;
        }
        return null;
    }

    private PprofTask buildPprofTask(ResultSet data) throws SQLException {
        Type listType = new TypeToken<List<String>>(){}.getType();
        String events = data.getString("events");
        String serviceInstanceIds = data.getString("service_instance_ids");
        List serviceInstanceIdList = (List)GSON.fromJson(serviceInstanceIds, listType);
        return PprofTask.builder().id(data.getString("task_id")).serviceId(data.getString("service_id")).serviceInstanceIds(serviceInstanceIdList).createTime(data.getLong("create_time")).duration(data.getInt("duration")).events(PprofEventType.valueOfString((String)events)).dumpPeriod(data.getInt("dump_period")).build();
    }

    @Generated
    public JDBCPprofTaskQueryDAO(JDBCClient jdbcClient, TableHelper tableHelper) {
        this.jdbcClient = jdbcClient;
        this.tableHelper = tableHelper;
    }
}

