/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.clam.http.internal;

import java.io.IOException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import javax.jcr.PropertyType;
import javax.json.Json;
import javax.json.JsonException;
import javax.json.JsonObjectBuilder;
import javax.json.JsonValue;
import javax.servlet.ServletException;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.commons.clam.ScanResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ResponseUtil {
    private ResponseUtil() {
    }

    static void handleError(@NotNull SlingHttpServletResponse response, int status, @Nullable String message) throws ServletException, IOException {
        try {
            response.setCharacterEncoding(StandardCharsets.UTF_8.name());
            response.setContentType("application/json");
            response.setStatus(status);
            if (message != null) {
                JsonObjectBuilder error = Json.createObjectBuilder();
                error.add("message", message);
                Json.createGenerator((Writer)response.getWriter()).write((JsonValue)error.build()).flush();
            }
        }
        catch (JsonException e) {
            throw new ServletException("Building response failed.");
        }
    }

    static String json(@NotNull ScanResult scanResult, @NotNull String path, @Nullable Integer index, int propertyType, @Nullable String userId) {
        JsonObjectBuilder event = Json.createObjectBuilder();
        event.add("timestamp", scanResult.getTimestamp());
        event.add("status", scanResult.getStatus().name());
        event.add("message", scanResult.getMessage());
        event.add("started", scanResult.getStarted());
        event.add("size", scanResult.getSize());
        event.add("path", path);
        if (index != null) {
            event.add("index", index.intValue());
        }
        event.add("propertyType", PropertyType.nameFromValue((int)propertyType));
        if (userId != null) {
            event.add("userId", userId);
        }
        return event.build().toString();
    }
}

