/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.discovery.base.its.setup.mock;

import java.util.HashMap;
import java.util.Map;
import org.apache.sling.discovery.TopologyEvent;
import org.apache.sling.discovery.base.its.setup.mock.TopologyEventAsserter;

public class AcceptsMultiple
implements TopologyEventAsserter {
    private final TopologyEvent.Type[] acceptedTypes;
    private final Map<TopologyEvent.Type, Integer> counts = new HashMap<TopologyEvent.Type, Integer>();

    public AcceptsMultiple(TopologyEvent.Type ... acceptedTypes) {
        this.acceptedTypes = acceptedTypes;
    }

    @Override
    public synchronized void assertOk(TopologyEvent event) {
        for (int i = 0; i < this.acceptedTypes.length; ++i) {
            TopologyEvent.Type aType = this.acceptedTypes[i];
            if (aType != event.getType()) continue;
            Integer c = this.counts.remove(aType);
            if (c == null) {
                this.counts.put(aType, new Integer(1));
            } else {
                this.counts.put(aType, new Integer(c + 1));
            }
            return;
        }
        throw new IllegalStateException("Got an Event which I did not expect: " + event.getType());
    }

    public synchronized int getEventCnt(TopologyEvent.Type type) {
        Integer i = this.counts.get(type);
        if (i != null) {
            return i;
        }
        return 0;
    }
}

