/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.discovery.commons.providers.spi.base;

import java.util.concurrent.Callable;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.sling.discovery.commons.providers.BaseTopologyView;
import org.apache.sling.discovery.commons.providers.spi.ClusterSyncService;
import org.apache.sling.discovery.commons.providers.spi.base.AbstractServiceWithBackgroundCheck;

public class DummyClusterSyncService
extends AbstractServiceWithBackgroundCheck
implements ClusterSyncService {
    private final long timeoutMillis;
    private final long intervalMillis;
    private final String debugName;
    private final AtomicBoolean checkResult = new AtomicBoolean(false);
    private final AtomicLong checkCounter = new AtomicLong(0L);
    private final Semaphore checkSemaphore = new Semaphore(Integer.MAX_VALUE);
    private final AtomicInteger checkBlocking = new AtomicInteger(0);

    public DummyClusterSyncService(long timeoutMillis, long intervalMillis, String debugName) {
        this.timeoutMillis = timeoutMillis;
        this.intervalMillis = intervalMillis;
        this.debugName = debugName;
    }

    public void setCheckResult(boolean checkResult) {
        this.checkResult.set(checkResult);
    }

    public boolean getCheckResult() {
        return this.checkResult.get();
    }

    public void setCheckSemaphoreSetPermits(int permits) {
        this.checkSemaphore.drainPermits();
        this.checkSemaphore.release(permits);
    }

    public void setCheckSemaphoreRelease(int permits) {
        this.checkSemaphore.release(permits);
    }

    public void sync(BaseTopologyView view, Runnable callback) {
        this.startBackgroundCheck(this.debugName, new AbstractServiceWithBackgroundCheck.BackgroundCheck(){

            public boolean check() {
                boolean incremented = false;
                try {
                    if (!DummyClusterSyncService.this.checkSemaphore.tryAcquire()) {
                        DummyClusterSyncService.this.checkBlocking.incrementAndGet();
                        incremented = true;
                        while (true) {
                            try {
                                DummyClusterSyncService.this.checkSemaphore.acquire();
                            }
                            catch (InterruptedException e) {
                                e.printStackTrace();
                                continue;
                            }
                            break;
                        }
                    }
                    boolean bl = DummyClusterSyncService.this.checkResult.get();
                    return bl;
                }
                finally {
                    if (incremented) {
                        DummyClusterSyncService.this.checkBlocking.decrementAndGet();
                    }
                    DummyClusterSyncService.this.checkCounter.incrementAndGet();
                }
            }
        }, callback, this.timeoutMillis, this.intervalMillis);
    }

    public boolean waitForCheckCounterAtMin(final long minValue, long timeoutMillis) {
        return this.waitForCondition(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return DummyClusterSyncService.this.checkCounter.get() >= minValue;
            }
        }, timeoutMillis);
    }

    public boolean waitForCheckBlockingAtMin(final int minBlockedCnt, long timeoutMillis) {
        return this.waitForCondition(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return DummyClusterSyncService.this.checkBlocking.get() >= minBlockedCnt;
            }
        }, timeoutMillis);
    }

    public boolean waitForCheckBlockingAtMax(final int maxBlockedCnt, long timeoutMillis) {
        return this.waitForCondition(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return DummyClusterSyncService.this.checkBlocking.get() <= maxBlockedCnt;
            }
        }, timeoutMillis);
    }

    public void resetCounter() {
        this.checkCounter.set(0L);
    }

    public long getCheckCounter() {
        return this.checkCounter.get();
    }

    public int getCheckBlocking() {
        return this.checkBlocking.get();
    }

    public void cancelSync() {
        this.cancelPreviousBackgroundCheck();
    }

    public boolean waitForBackgroundCheckFinished(long timeoutMillis) {
        return this.waitForCondition(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return !DummyClusterSyncService.this.hasBackgroundCheckRunnable();
            }
        }, timeoutMillis);
    }

    public boolean hasBackgroundCheckRunnable() {
        AbstractServiceWithBackgroundCheck.BackgroundCheckRunnable r = this.backgroundCheckRunnable;
        if (r == null) {
            return false;
        }
        return !r.isDone();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean waitForCondition(Callable<Boolean> condition, long timeoutMillis) {
        if (timeoutMillis < 0L) {
            throw new IllegalArgumentException("timeoutMillis must be 0 or positive, is: " + timeoutMillis);
        }
        long timeout = System.currentTimeMillis() + timeoutMillis;
        try {
            while (condition.call() == false) {
                long delta = Math.min(10L, timeout - System.currentTimeMillis());
                if (delta <= 0L) {
                    return condition.call();
                }
                try {
                    Thread.sleep(delta);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            return condition.call();
        }
        catch (Exception e) {
            throw new AssertionError("Got Exception: " + String.valueOf(e), e);
        }
    }
}

