/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.vault.fs.io;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.jackrabbit.vault.fs.api.VaultInputSource;
import org.apache.jackrabbit.vault.fs.config.DefaultMetaInf;
import org.apache.jackrabbit.vault.fs.config.MetaInf;
import org.apache.jackrabbit.vault.fs.io.AbstractArchive;
import org.apache.jackrabbit.vault.fs.io.Archive;
import org.h2.util.CloseWatcher;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZipStreamArchive
extends AbstractArchive {
    private static final Logger log = LoggerFactory.getLogger(ZipStreamArchive.class);
    private static final int DEFAULT_BUFFER_SIZE = 0x100000;
    private InputStream in;
    private File tmpFile;
    private RandomAccessFile raf;
    private byte[] decompressed;
    private final int maxBufferSize;
    private int pos;
    private EntryImpl root;
    private DefaultMetaInf inf;
    private final byte[] buffer = new byte[65536];
    private CloseWatcher watcher;

    public ZipStreamArchive(@NotNull InputStream in) {
        this(in, 0x100000);
    }

    public ZipStreamArchive(@NotNull InputStream in, int maxBufferSize) {
        this.in = in;
        this.maxBufferSize = maxBufferSize;
    }

    /*
     * Exception decompiling
     */
    @Override
    public void open(boolean strict) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [12[UNCONDITIONALDOLOOP]], but top level block is 0[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private long getPosition() throws IOException {
        if (this.raf != null) {
            return this.raf.getFilePointer();
        }
        return this.pos;
    }

    private long copy(@NotNull InputStream in) throws IOException {
        if (this.raf != null) {
            return this.copyToRaf(in);
        }
        return this.copyToBuffer(in);
    }

    private long copyToBuffer(@NotNull InputStream in) throws IOException {
        int read;
        int total = 0;
        while ((read = in.read(this.decompressed, this.pos, this.decompressed.length - this.pos)) > 0) {
            total += read;
            this.pos += read;
            if (this.pos != this.decompressed.length) continue;
            this.tmpFile = File.createTempFile("__vlttmpbuffer", ".dat");
            this.raf = new RandomAccessFile(this.tmpFile, "rw");
            this.raf.write(this.decompressed);
            this.decompressed = null;
            return (long)total + this.copyToRaf(in);
        }
        return total;
    }

    private long copyToRaf(@NotNull InputStream in) throws IOException {
        int read;
        int total = 0;
        while ((read = in.read(this.buffer)) > 0) {
            this.raf.write(this.buffer, 0, read);
            total += read;
        }
        return total;
    }

    @Override
    public InputStream openInputStream(Archive.Entry entry) throws IOException {
        return this.createInputStream((EntryImpl)entry);
    }

    @Override
    public VaultInputSource getInputSource(Archive.Entry entry) throws IOException {
        return new RafInputSource((EntryImpl)entry);
    }

    @Override
    public MetaInf getMetaInf() {
        return this.inf;
    }

    @Override
    public void close() {
        if (this.in != null) {
            IOUtils.closeQuietly((InputStream)this.in);
        }
        if (this.watcher != null) {
            CloseWatcher.unregister(this.watcher);
        }
        if (this.raf != null) {
            try {
                this.raf.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.raf = null;
        }
        if (this.tmpFile != null) {
            FileUtils.deleteQuietly((File)this.tmpFile);
            this.tmpFile = null;
        }
        if (this.decompressed != null) {
            this.decompressed = new byte[0];
        }
    }

    @Override
    public Archive.Entry getRoot() throws IOException {
        return this.root;
    }

    public boolean isBuffered() {
        return this.decompressed != null;
    }

    private InputStream createInputStream(@NotNull EntryImpl entry) {
        if (this.raf == null) {
            return new ByteArrayInputStream(this.decompressed, (int)entry.pos, (int)entry.len);
        }
        return new RafInputStream(entry);
    }

    private static long safeGetTime(ZipEntry e) {
        try {
            return e.getTime();
        }
        catch (Exception e1) {
            return 0L;
        }
    }

    private static class EntryImpl
    implements Archive.Entry {
        public final String name;
        public final long time;
        public final long pos;
        public final long len;
        public Map<String, EntryImpl> children;

        private EntryImpl(String name) {
            this.name = name;
            this.time = 0L;
            this.pos = -1L;
            this.len = 0L;
        }

        private EntryImpl(String name, long time, long pos, long len) {
            this.name = name;
            this.time = time;
            this.pos = pos;
            this.len = len;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public boolean isDirectory() {
            return this.pos < 0L;
        }

        public EntryImpl add(EntryImpl e) {
            if (this.children == null) {
                this.children = new LinkedHashMap<String, EntryImpl>();
            }
            this.children.put(e.getName(), e);
            return e;
        }

        public EntryImpl add(String name) {
            EntryImpl e;
            if (this.children == null) {
                this.children = new LinkedHashMap<String, EntryImpl>();
            } else {
                e = this.children.get(name);
                if (e != null) {
                    return e;
                }
            }
            e = new EntryImpl(name);
            this.children.put(name, e);
            return e;
        }

        @Override
        public Collection<? extends Archive.Entry> getChildren() {
            return this.children == null ? Collections.emptyList() : this.children.values();
        }

        @Override
        public Archive.Entry getChild(String name) {
            return this.children == null ? null : (Archive.Entry)this.children.get(name);
        }
    }

    private class RafInputStream
    extends InputStream {
        private long pos;
        private long end;
        private long mark;

        private RafInputStream(EntryImpl entry) {
            this.pos = entry.pos;
            this.end = this.pos + entry.len;
        }

        @Override
        public int read() throws IOException {
            if (this.pos < this.end) {
                ZipStreamArchive.this.raf.seek(this.pos++);
                return ZipStreamArchive.this.raf.read();
            }
            return -1;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            if (this.pos >= this.end) {
                return -1;
            }
            len = Math.min(len, (int)(this.end - this.pos));
            ZipStreamArchive.this.raf.seek(this.pos);
            int read = ZipStreamArchive.this.raf.read(b, off, len);
            if (read < 0) {
                return -1;
            }
            this.pos += (long)read;
            return read;
        }

        @Override
        public int read(byte[] b) throws IOException {
            return this.read(b, 0, b.length);
        }

        @Override
        public long skip(long n) throws IOException {
            if (this.pos >= this.end) {
                return -1L;
            }
            n = Math.min(n, this.end - this.pos);
            this.pos += n;
            return n;
        }

        @Override
        public int available() throws IOException {
            return (int)(this.end - this.pos);
        }

        @Override
        public void close() throws IOException {
        }

        @Override
        public synchronized void mark(int readlimit) {
            this.mark = this.pos;
        }

        @Override
        public synchronized void reset() throws IOException {
            this.pos = this.mark;
        }

        @Override
        public boolean markSupported() {
            return true;
        }
    }

    private class RafInputSource
    extends VaultInputSource {
        private final EntryImpl entry;

        private RafInputSource(EntryImpl entry) {
            this.entry = entry;
        }

        @Override
        public InputStream getByteStream() {
            return ZipStreamArchive.this.createInputStream(this.entry);
        }

        @Override
        public long getContentLength() {
            return this.entry.len;
        }

        @Override
        public long getLastModified() {
            return this.entry.time;
        }
    }
}

