/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.cpconverter.features;

import jakarta.json.JsonStructure;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Stack;
import org.apache.jackrabbit.vault.packaging.PackageId;
import org.apache.jackrabbit.vault.packaging.VaultPackage;
import org.apache.sling.feature.Artifact;
import org.apache.sling.feature.ArtifactId;
import org.apache.sling.feature.Artifacts;
import org.apache.sling.feature.Configuration;
import org.apache.sling.feature.Extension;
import org.apache.sling.feature.ExtensionState;
import org.apache.sling.feature.ExtensionType;
import org.apache.sling.feature.Extensions;
import org.apache.sling.feature.Feature;
import org.apache.sling.feature.cpconverter.ConverterException;
import org.apache.sling.feature.cpconverter.accesscontrol.AclManager;
import org.apache.sling.feature.cpconverter.accesscontrol.Mapping;
import org.apache.sling.feature.cpconverter.features.FeaturesManager;
import org.apache.sling.feature.cpconverter.features.RunmodeMapper;
import org.apache.sling.feature.cpconverter.interpolator.SimpleVariablesInterpolator;
import org.apache.sling.feature.cpconverter.interpolator.VariablesInterpolator;
import org.apache.sling.feature.cpconverter.repoinit.NoOpVisitor;
import org.apache.sling.feature.cpconverter.vltpkg.PackagesEventsEmitter;
import org.apache.sling.feature.extension.apiregions.api.ApiExport;
import org.apache.sling.feature.extension.apiregions.api.ApiRegion;
import org.apache.sling.feature.extension.apiregions.api.ApiRegions;
import org.apache.sling.feature.io.json.FeatureJSONWriter;
import org.apache.sling.repoinit.parser.RepoInitParsingException;
import org.apache.sling.repoinit.parser.impl.RepoInitParserService;
import org.apache.sling.repoinit.parser.operations.Operation;
import org.apache.sling.repoinit.parser.operations.OperationVisitor;
import org.apache.sling.repoinit.parser.operations.RegisterNamespace;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.util.converter.Converters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultFeaturesManager
implements FeaturesManager,
PackagesEventsEmitter {
    private static final String CONTENT_PACKAGES = "content-packages";
    private static final String SLING_OSGI_FEATURE_TILE_TYPE = "slingosgifeature";
    private static final String JSON_FILE_EXTENSION = ".json";
    private static final String BUNDLE_ORIGINS = "content-package-origins";
    private static final String CONFIGURATION_ORIGINS = ":configurator:".concat("content-package-origins");
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Map<String, Feature> runModes = new HashMap<String, Feature>();
    private final VariablesInterpolator interpolator = new SimpleVariablesInterpolator();
    private final ConfigurationHandling configurationHandling;
    private final int bundlesStartOrder;
    private final File featureModelsOutputDirectory;
    private final Map<String, List<String>> apiRegionExports = new HashMap<String, List<String>>();
    private final String artifactIdOverride;
    private final String prefix;
    private final Map<String, String> properties;
    private final List<String> targetAPIRegions = new ArrayList<String>();
    private final Map<String, String> namespaceUriByPrefix;
    private String exportsToAPIRegion;
    private Feature targetFeature;
    private AclManager aclManager;
    private final Map<String, String> pidToPathMapping = new HashMap<String, String>();
    private final Stack<String> packageIds = new Stack();
    private static final String REPOINIT_FACTORY_PID = "org.apache.sling.jcr.repoinit.RepositoryInitializer";
    private static final String REPOINIT_PID = "org.apache.sling.jcr.repoinit.impl.RepositoryInitializer";
    private static final String SERVICE_USER_MAPPING_PID = "org.apache.sling.serviceusermapping.impl.ServiceUserMapperImpl";
    private boolean enforceServiceMappingByPrincipal;

    DefaultFeaturesManager() {
        this(new File(""));
    }

    public DefaultFeaturesManager(@NotNull File tempDir) {
        this(true, 20, tempDir, null, null, new HashMap<String, String>(), null);
    }

    public DefaultFeaturesManager(boolean mergeConfigurations, int bundlesStartOrder, @NotNull File featureModelsOutputDirectory, @Nullable String artifactIdOverride, @Nullable String prefix, @NotNull Map<String, String> properties, @Nullable AclManager aclManager) {
        this(mergeConfigurations ? ConfigurationHandling.MERGE : ConfigurationHandling.ORDERED, bundlesStartOrder, featureModelsOutputDirectory, artifactIdOverride, prefix, properties, aclManager);
    }

    public DefaultFeaturesManager(@NotNull ConfigurationHandling configurationHandling, int bundlesStartOrder, @NotNull File featureModelsOutputDirectory, @Nullable String artifactIdOverride, @Nullable String prefix, @NotNull Map<String, String> properties, @Nullable AclManager aclManager) {
        this.configurationHandling = configurationHandling;
        this.bundlesStartOrder = bundlesStartOrder;
        this.featureModelsOutputDirectory = featureModelsOutputDirectory;
        this.artifactIdOverride = artifactIdOverride;
        this.prefix = prefix;
        this.properties = properties;
        this.aclManager = aclManager;
        this.namespaceUriByPrefix = new HashMap<String, String>();
    }

    @Override
    public void init(@NotNull ArtifactId packageId) {
        this.targetFeature = new Feature(packageId.changeClassifier(null).changeType(SLING_OSGI_FEATURE_TILE_TYPE));
        this.runModes.clear();
        this.apiRegionExports.clear();
    }

    @Override
    @Nullable
    public Feature getTargetFeature() {
        return this.targetFeature;
    }

    @Override
    @NotNull
    public Feature getRunMode(@Nullable String runMode) {
        if (this.getTargetFeature() == null) {
            throw new IllegalStateException("Target feature not initialized yet, please make sure convert() method was invoked first.");
        }
        if (runMode == null) {
            return this.getTargetFeature();
        }
        ArtifactId newId = DefaultFeaturesManager.appendRunmode(this.getTargetFeature().getId(), runMode);
        return this.runModes.computeIfAbsent(runMode, k -> new Feature(newId));
    }

    @Override
    public void addArtifact(@Nullable String runMode, @NotNull ArtifactId id) {
        Objects.requireNonNull(id, "Artifact can not be attached to a feature without specifying a valid ArtifactId.");
        this.addArtifact(runMode, new Artifact(id), null);
    }

    @Override
    public void addArtifact(@Nullable String runMode, @NotNull Artifact artifact, @Nullable Integer startOrder) {
        Artifacts artifacts;
        Objects.requireNonNull(artifact, "Null artifact can not be attached to a feature.");
        Feature feature = this.getRunMode(runMode);
        if ("zip".equals(artifact.getId().getType())) {
            Extensions extensions = feature.getExtensions();
            Extension extension = extensions.getByName(CONTENT_PACKAGES);
            if (extension == null) {
                extension = new Extension(ExtensionType.ARTIFACTS, CONTENT_PACKAGES, ExtensionState.REQUIRED);
                extensions.add((Object)extension);
            }
            artifacts = extension.getArtifacts();
        } else {
            int startOrderForBundle = startOrder != null ? startOrder : this.bundlesStartOrder;
            artifact.setStartOrder(startOrderForBundle);
            if (!this.packageIds.isEmpty()) {
                artifact.getMetadata().put(BUNDLE_ORIGINS, String.join((CharSequence)"|", this.packageIds));
            }
            artifacts = feature.getBundles();
        }
        artifacts.add(artifact);
    }

    @NotNull
    private static ArtifactId appendRunmode(@NotNull ArtifactId id, @Nullable String runMode) {
        ArtifactId newId;
        if (runMode == null) {
            newId = id;
        } else {
            String classifier = id.getClassifier() != null && !id.getClassifier().isEmpty() ? id.getClassifier() + '-' + runMode : runMode;
            newId = new ArtifactId(id.getGroupId(), id.getArtifactId(), id.getVersion(), classifier, id.getType());
        }
        return newId;
    }

    @Override
    public void addAPIRegionExport(@Nullable String runMode, @NotNull String exportedPackage) {
        if (this.exportsToAPIRegion == null) {
            return;
        }
        this.getRunMode(runMode);
        List l = this.apiRegionExports.computeIfAbsent(runMode, r -> new ArrayList());
        l.add(exportedPackage);
    }

    public void setEnforceServiceMappingByPrincipal(boolean enforceServiceMappingByPrincipal) {
        this.enforceServiceMappingByPrincipal = enforceServiceMappingByPrincipal;
    }

    public void addSeed(@NotNull Feature seed) throws IOException, ConverterException {
        for (Configuration conf : seed.getConfigurations()) {
            this.handleRepoinitAndMappings("seed", conf, conf.getConfigurationProperties(), false);
        }
        if (seed.getExtensions().getByName("repoinit") != null) {
            String repoInitText = seed.getExtensions().getByName("repoinit").getText();
            this.getAclManager().addRepoinitExtention("seed", repoInitText, "seed", this);
            DefaultFeaturesManager.extractNamespaces(repoInitText, this.namespaceUriByPrefix);
        }
    }

    private static void extractNamespaces(String repoInitText, final Map<String, String> namespaceUriByPrefix) {
        try {
            List ops = new RepoInitParserService().parse((Reader)new StringReader(repoInitText));
            for (Operation op : ops) {
                op.accept((OperationVisitor)new NoOpVisitor(){

                    @Override
                    public void visitRegisterNamespace(RegisterNamespace registerNamespace) {
                        namespaceUriByPrefix.put(registerNamespace.getPrefix(), registerNamespace.getURI());
                    }
                });
            }
        }
        catch (RepoInitParsingException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    @NotNull
    public Map<String, String> getNamespaceUriByPrefix() {
        return this.namespaceUriByPrefix;
    }

    @NotNull
    AclManager getAclManager() {
        return Objects.requireNonNull(this.aclManager);
    }

    public void setAclManager(AclManager aclManager) {
        this.aclManager = aclManager;
    }

    private boolean handleRepoinitAndMappings(String runMode, Configuration cfg, Dictionary<String, Object> configurationProperties, boolean enforceServiceMappingByPrincipal) throws IOException, ConverterException {
        String[] mappings;
        List<String> newMappings;
        if (REPOINIT_FACTORY_PID.equals(cfg.getFactoryPid())) {
            CharSequence[] scripts = (String[])Converters.standardConverter().convert(configurationProperties.get("scripts")).to(String[].class);
            if (scripts != null && scripts.length > 0) {
                this.getAclManager().addRepoinitExtention(cfg.getPid(), String.join((CharSequence)System.lineSeparator(), scripts), runMode, this);
            }
            DefaultFeaturesManager.checkReferences(configurationProperties, cfg.getPid());
            return true;
        }
        if (REPOINIT_PID.equals(cfg.getPid())) {
            DefaultFeaturesManager.checkReferences(configurationProperties, cfg.getPid());
            return true;
        }
        if (cfg.getPid().startsWith(SERVICE_USER_MAPPING_PID) && !(newMappings = this.convertMappings(mappings = (String[])Converters.standardConverter().convert(configurationProperties.get("user.mapping")).to(String[].class), cfg.getPid(), enforceServiceMappingByPrincipal)).isEmpty()) {
            configurationProperties.put("user.mapping", newMappings.toArray(new String[0]));
        }
        return false;
    }

    private List<String> convertMappings(@Nullable String[] mappings, @NotNull String pid, boolean enforceServiceMappingByPrincipal) throws ConverterException {
        if (mappings == null) {
            return Collections.emptyList();
        }
        ArrayList<String> newMappings = new ArrayList<String>();
        for (String usermapping : mappings) {
            if (usermapping == null || usermapping.trim().isEmpty()) {
                this.logger.warn("ServiceUserMapping: Ignoring empty mapping in {}", (Object)pid);
                continue;
            }
            try {
                Mapping mapping = new Mapping(usermapping, enforceServiceMappingByPrincipal);
                this.getAclManager().addMapping(mapping);
                newMappings.add(mapping.asString());
            }
            catch (IllegalArgumentException iae) {
                throw new ConverterException("ServiceUserMapping: Detected invalid mapping in " + pid);
            }
        }
        return newMappings;
    }

    @Override
    public void addConfiguration(@Nullable String runMode, @NotNull Configuration cfg, @NotNull String path, @NotNull Dictionary<String, Object> configurationProperties) throws IOException, ConverterException {
        if (this.handleRepoinitAndMappings(runMode, cfg, configurationProperties, this.enforceServiceMappingByPrincipal)) {
            return;
        }
        Feature feature = this.getRunMode(runMode);
        Configuration configuration = feature.getConfigurations().getConfiguration(cfg.getPid());
        if (configuration == null) {
            configuration = new Configuration(cfg.getPid());
            feature.getConfigurations().add((Object)configuration);
            this.pidToPathMapping.put(cfg.getPid(), path);
        } else {
            switch (this.configurationHandling) {
                case STRICT: {
                    throw new ConverterException("Configuration '" + cfg.getPid() + "' already defined in Feature Model '" + feature.getId().toMvnId() + "', set the 'mergeConfigurations' flag to 'true' if you want to merge multiple configurations with same PID");
                }
                case ORDERED: {
                    String oldPath = this.pidToPathMapping.get(cfg.getPid());
                    if (oldPath == null || oldPath.compareTo(path) > 0) {
                        this.pidToPathMapping.put(cfg.getPid(), path);
                        feature.getConfigurations().remove((Object)configuration);
                        configuration = new Configuration(cfg.getPid());
                        feature.getConfigurations().add((Object)configuration);
                        break;
                    }
                    return;
                }
            }
        }
        this.adjustConfigurationProperties(configuration, configurationProperties);
    }

    private void adjustConfigurationProperties(@NotNull Configuration configuration, @NotNull Dictionary<String, Object> configurationProperties) {
        Enumeration<String> keys = configurationProperties.keys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            Object[] value = configurationProperties.get(key);
            if (value instanceof Collection) {
                value = ((Collection)value).toArray();
            }
            configuration.getProperties().put(key, value);
        }
        configuration.getProperties().remove("service.pid");
        configuration.getProperties().remove("service.bundleLocation");
        configuration.getProperties().remove("service.factoryPid");
        if (!this.packageIds.isEmpty()) {
            ArrayList<String> origins = new ArrayList<String>();
            Object val = configuration.getProperties().get(CONFIGURATION_ORIGINS);
            if (val != null) {
                origins.addAll(Arrays.asList(val.toString().split(",")));
            }
            origins.add(String.join((CharSequence)"|", this.packageIds));
            configuration.getProperties().put(CONFIGURATION_ORIGINS, String.join((CharSequence)",", origins));
        }
    }

    private void addAPIRegions(@NotNull Feature feature, @Nullable List<String> exportedPackages) throws IOException {
        if (exportedPackages == null) {
            exportedPackages = Collections.emptyList();
        }
        if (exportedPackages.isEmpty() && this.targetAPIRegions.isEmpty()) {
            return;
        }
        ApiRegions regions = new ApiRegions();
        if (this.exportsToAPIRegion != null) {
            ApiRegion ar = new ApiRegion(this.exportsToAPIRegion);
            exportedPackages.stream().forEach(e -> ar.add(new ApiExport(e)));
            regions.add(ar);
        }
        this.targetAPIRegions.stream().forEach(r -> regions.add(new ApiRegion(r)));
        Extension apiRegions = new Extension(ExtensionType.JSON, "api-regions", ExtensionState.OPTIONAL);
        apiRegions.setJSONStructure((JsonStructure)regions.toJSONArray());
        feature.getExtensions().add((Object)apiRegions);
    }

    @Override
    public void serialize() throws IOException {
        RunmodeMapper runmodeMapper = RunmodeMapper.open(this.featureModelsOutputDirectory);
        this.serialize(this.targetFeature, null, runmodeMapper);
        if (!this.runModes.isEmpty()) {
            for (Map.Entry<String, Feature> runmodeEntry : this.runModes.entrySet()) {
                String runmode = runmodeEntry.getKey();
                this.serialize(runmodeEntry.getValue(), runmode, runmodeMapper);
            }
        }
        runmodeMapper.save();
    }

    private void serialize(Feature feature, String runMode, RunmodeMapper runmodeMapper) throws IOException {
        this.addAPIRegions(feature, this.apiRegionExports.get(runMode));
        StringBuilder fileNameBuilder = new StringBuilder().append(this.prefix != null ? this.prefix : "").append(feature.getId().getArtifactId());
        String classifier = feature.getId().getClassifier();
        if (classifier != null && !classifier.isEmpty()) {
            fileNameBuilder.append('-').append(classifier);
        }
        if (this.properties != null) {
            this.properties.put("filename", fileNameBuilder.toString());
        }
        fileNameBuilder.append(JSON_FILE_EXTENSION);
        String fileName = fileNameBuilder.toString();
        File targetFile = new File(this.featureModelsOutputDirectory, fileName);
        if (!targetFile.getParentFile().exists()) {
            targetFile.getParentFile().mkdirs();
        }
        if (this.artifactIdOverride != null && !this.artifactIdOverride.isEmpty()) {
            String interpolatedIdOverride = this.interpolator.interpolate(this.artifactIdOverride, this.properties);
            ArtifactId idOverrride = DefaultFeaturesManager.appendRunmode(ArtifactId.parse((String)interpolatedIdOverride), runMode);
            feature = feature.copy(idOverrride);
        }
        this.logger.info("Writing resulting Feature Model '{}' to file '{}'...", (Object)feature.getId(), (Object)targetFile);
        try (FileWriter targetWriter = new FileWriter(targetFile);){
            FeatureJSONWriter.write((Writer)targetWriter, (Feature)feature);
            this.logger.info("'{}' Feature File successfully written!", (Object)targetFile);
            runmodeMapper.addOrUpdate(runMode, fileName);
        }
    }

    @NotNull
    public synchronized DefaultFeaturesManager setAPIRegions(@NotNull List<String> regions) {
        this.targetAPIRegions.clear();
        this.targetAPIRegions.addAll(regions);
        return this;
    }

    @NotNull
    public synchronized DefaultFeaturesManager setExportToAPIRegion(@NotNull String region) {
        this.exportsToAPIRegion = region;
        return this;
    }

    @Override
    public void addOrAppendRepoInitExtension(@NotNull String source, @NotNull String text, @Nullable String runMode) {
        if (runMode == null) {
            this.logger.info("Adding global repo-init");
        } else {
            this.logger.info("Adding repo-init for run mode: {}", (Object)runMode);
        }
        text = "# origin=".concat(String.join((CharSequence)"|", this.packageIds)).concat(" source=").concat(source).concat(System.lineSeparator()).concat(text);
        Extension repoInitExtension = this.getRunMode(runMode).getExtensions().getByName("repoinit");
        if (repoInitExtension == null) {
            repoInitExtension = new Extension(ExtensionType.TEXT, "repoinit", ExtensionState.REQUIRED);
            this.getRunMode(runMode).getExtensions().add((Object)repoInitExtension);
            repoInitExtension.setText(text);
        } else {
            repoInitExtension.setText(repoInitExtension.getText().concat(System.lineSeparator()).concat(text));
        }
    }

    @Override
    public void addOrAppendOakIndexDefinitionsExtension(String source, String text) throws IOException, ConverterException {
        Extension oakIndexDefsExtension = this.getRunMode(null).getExtensions().getByName("oak-index-definitions");
        if (oakIndexDefsExtension == null) {
            oakIndexDefsExtension = new Extension(ExtensionType.JSON, "oak-index-definitions", ExtensionState.OPTIONAL);
            this.getRunMode(null).getExtensions().add((Object)oakIndexDefsExtension);
            oakIndexDefsExtension.setJSON(text);
        } else {
            oakIndexDefsExtension.setJSON(oakIndexDefsExtension.getText().concat(System.lineSeparator()).concat(text));
        }
    }

    private static void checkReferences(@NotNull Dictionary<String, Object> configurationProperties, @NotNull String pid) throws ConverterException {
        String[] references = (String[])Converters.standardConverter().convert(configurationProperties.get("references")).to(String[].class);
        if (references != null && references.length > 0) {
            for (String r : references) {
                if (r == null || r.trim().isEmpty()) continue;
                throw new ConverterException("References are not supported for repoinit (configuration " + pid + ")");
            }
        }
    }

    @Override
    public void start() {
    }

    @Override
    public void end() {
    }

    @Override
    public void startPackage(@NotNull VaultPackage originalPackage) {
        this.packageIds.push(originalPackage.getId().toString());
    }

    @Override
    public void endPackage(@NotNull PackageId originalPackageId, @NotNull VaultPackage convertedPackage) {
        this.packageIds.pop();
    }

    @Override
    public void startSubPackage(@NotNull String path, @NotNull VaultPackage originalPackage) {
        this.packageIds.push(originalPackage.getId().toString());
    }

    @Override
    public void endSubPackage(@NotNull String path, @NotNull PackageId originalPackageId, @NotNull VaultPackage convertedPackage) {
        this.packageIds.pop();
    }

    public static enum ConfigurationHandling {
        ORDERED,
        MERGE,
        STRICT;

    }
}

