/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.state;

import org.apache.jackrabbit.core.id.ItemId;
import org.apache.jackrabbit.core.id.NodeId;
import org.apache.jackrabbit.core.id.PropertyId;
import org.apache.jackrabbit.core.state.ItemState;
import org.apache.jackrabbit.core.value.InternalValue;
import org.apache.jackrabbit.spi.Name;

public class PropertyState
extends ItemState {
    private PropertyId id;
    private InternalValue[] values;
    private int type;
    private boolean multiValued;

    public PropertyState(PropertyState overlayedState, int initialStatus, boolean isTransient) {
        super(overlayedState, initialStatus, isTransient);
        this.pull();
    }

    public PropertyState(PropertyId id, int initialStatus, boolean isTransient) {
        super(initialStatus, isTransient);
        this.id = id;
        this.type = 0;
        this.values = InternalValue.EMPTY_ARRAY;
        this.multiValued = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void copy(ItemState state, boolean syncModCount) {
        ItemState itemState = state;
        synchronized (itemState) {
            PropertyState propState = (PropertyState)state;
            this.id = propState.id;
            this.type = propState.type;
            this.values = propState.values;
            this.multiValued = propState.multiValued;
            if (syncModCount) {
                this.setModCount(state.getModCount());
            }
        }
    }

    public boolean isNode() {
        return false;
    }

    public ItemId getId() {
        return this.id;
    }

    public PropertyId getPropertyId() {
        return this.id;
    }

    public NodeId getParentId() {
        return this.id.getParentId();
    }

    public Name getName() {
        return this.id.getName();
    }

    public void setType(int type) {
        this.type = type;
    }

    public void setMultiValued(boolean multiValued) {
        this.multiValued = multiValued;
    }

    public int getType() {
        return this.type;
    }

    public boolean isMultiValued() {
        return this.multiValued;
    }

    public void setValues(InternalValue[] values) {
        this.values = values;
    }

    public InternalValue[] getValues() {
        return this.values;
    }

    public long calculateMemoryFootprint() {
        return 350 + this.values.length * 100;
    }
}

