/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.query.ast;

import java.util.ArrayList;
import java.util.List;
import org.apache.jackrabbit.oak.api.Result;
import org.apache.jackrabbit.oak.query.ast.AstElement;
import org.apache.jackrabbit.oak.query.ast.AstElementFactory;
import org.apache.jackrabbit.oak.query.ast.AstVisitor;
import org.apache.jackrabbit.oak.query.ast.ConstraintImpl;
import org.apache.jackrabbit.oak.query.ast.JoinConditionImpl;
import org.apache.jackrabbit.oak.query.ast.JoinType;
import org.apache.jackrabbit.oak.query.ast.SelectorImpl;
import org.apache.jackrabbit.oak.query.ast.SourceImpl;
import org.apache.jackrabbit.oak.query.plan.ExecutionPlan;
import org.apache.jackrabbit.oak.query.plan.JoinExecutionPlan;
import org.apache.jackrabbit.oak.spi.query.Filter;
import org.apache.jackrabbit.oak.spi.state.NodeState;

public class JoinImpl
extends SourceImpl {
    private final JoinConditionImpl joinCondition;
    private JoinType joinType;
    private SourceImpl left;
    private SourceImpl right;
    private boolean leftNeedExecute;
    private boolean rightNeedExecute;
    private boolean leftNeedNext;
    private boolean foundJoinedRow;
    private boolean end;
    private NodeState rootState;
    private JoinExecutionPlan plan;

    public JoinImpl(SourceImpl left, SourceImpl right, JoinType joinType, JoinConditionImpl joinCondition) {
        this.left = left;
        this.right = right;
        this.joinType = joinType;
        this.joinCondition = joinCondition;
    }

    public ArrayList<SourceImpl> getInnerJoinSelectors() {
        ArrayList<SourceImpl> list = new ArrayList<SourceImpl>();
        switch (this.joinType) {
            case INNER: {
                list.addAll(this.left.getInnerJoinSelectors());
                list.addAll(this.right.getInnerJoinSelectors());
                break;
            }
            case LEFT_OUTER: {
                list.addAll(this.left.getInnerJoinSelectors());
                break;
            }
            case RIGHT_OUTER: {
                list.addAll(this.right.getInnerJoinSelectors());
            }
        }
        return list;
    }

    @Override
    public List<JoinConditionImpl> getInnerJoinConditions() {
        ArrayList<JoinConditionImpl> set = new ArrayList<JoinConditionImpl>();
        switch (this.joinType) {
            case INNER: {
                set.add(this.joinCondition);
                set.addAll(this.left.getInnerJoinConditions());
                set.addAll(this.right.getInnerJoinConditions());
            }
        }
        return set;
    }

    public JoinConditionImpl getJoinCondition() {
        return this.joinCondition;
    }

    public SourceImpl getLeft() {
        return this.left;
    }

    public SourceImpl getRight() {
        return this.right;
    }

    @Override
    boolean accept(AstVisitor v) {
        return v.visit(this);
    }

    @Override
    public String getPlan(NodeState rootState) {
        StringBuilder buff = new StringBuilder();
        buff.append(this.left.getPlan(rootState)).append(' ').append((Object)this.joinType).append(' ').append(this.right.getPlan(rootState)).append(" on ").append(this.joinCondition);
        return buff.toString();
    }

    @Override
    public String getIndexCostInfo(NodeState rootState) {
        StringBuilder buff = new StringBuilder();
        buff.append(this.toString());
        buff.append("{ ");
        buff.append(this.left.getIndexCostInfo(rootState));
        buff.append(", ");
        buff.append(this.right.getIndexCostInfo(rootState));
        buff.append(" }");
        return buff.toString();
    }

    public String toString() {
        return String.valueOf(this.left) + " " + String.valueOf((Object)this.joinType) + " " + String.valueOf(this.right) + " on " + String.valueOf(this.joinCondition);
    }

    @Override
    public void unprepare() {
        this.left.unprepare();
        this.right.unprepare();
        this.plan = null;
    }

    private void applyJoinConditions() {
        switch (this.joinType) {
            case INNER: {
                this.left.addJoinCondition(this.joinCondition, false);
                this.right.addJoinCondition(this.joinCondition, true);
                break;
            }
            case LEFT_OUTER: {
                this.left.setOuterJoin(true, false);
                this.right.setOuterJoin(false, true);
                this.left.addJoinCondition(this.joinCondition, false);
                this.right.addJoinCondition(this.joinCondition, true);
                break;
            }
            case RIGHT_OUTER: {
                this.joinType = JoinType.LEFT_OUTER;
                SourceImpl temp = this.left;
                this.left = this.right;
                this.right = temp;
                this.left.setOuterJoin(true, false);
                this.right.setOuterJoin(false, true);
                this.left.addJoinCondition(this.joinCondition, false);
                this.right.addJoinCondition(this.joinCondition, true);
            }
        }
    }

    @Override
    public void prepare(ExecutionPlan p) {
        if (!(p instanceof JoinExecutionPlan)) {
            throw new IllegalArgumentException("Not a join plan");
        }
        JoinExecutionPlan joinPlan = (JoinExecutionPlan)p;
        if (joinPlan.getJoin() != this) {
            throw new IllegalArgumentException("Not a plan for this join");
        }
        this.plan = joinPlan;
        this.applyJoinConditions();
        this.left.prepare(joinPlan.getLeftPlan());
        this.right.prepare(joinPlan.getRightPlan());
    }

    @Override
    public ExecutionPlan prepare() {
        if (this.plan != null) {
            return this.plan;
        }
        this.applyJoinConditions();
        ExecutionPlan leftPlan = this.left.prepare();
        ExecutionPlan rightPlan = this.right.prepare();
        double cost = leftPlan.getEstimatedCost() + 2.0 * rightPlan.getEstimatedCost();
        this.plan = new JoinExecutionPlan(this, leftPlan, rightPlan, cost);
        return this.plan;
    }

    @Override
    public SelectorImpl getSelector(String selectorName) {
        SelectorImpl s = this.left.getSelector(selectorName);
        if (s == null) {
            s = this.right.getSelector(selectorName);
        }
        return s;
    }

    @Override
    public void execute(NodeState rootState) {
        this.rootState = rootState;
        this.leftNeedExecute = true;
        this.end = false;
    }

    @Override
    public Filter createFilter(boolean preparing) {
        return this.left.createFilter(preparing);
    }

    @Override
    public void setQueryConstraint(ConstraintImpl queryConstraint) {
        this.left.setQueryConstraint(queryConstraint);
        this.right.setQueryConstraint(queryConstraint);
    }

    @Override
    public void setOuterJoin(boolean outerJoinLeftHandSide, boolean outerJoinRightHandSide) {
        this.left.setOuterJoin(outerJoinLeftHandSide, outerJoinRightHandSide);
        this.right.setOuterJoin(outerJoinLeftHandSide, outerJoinRightHandSide);
    }

    @Override
    public void addJoinCondition(JoinConditionImpl joinCondition, boolean forThisSelector) {
        this.left.addJoinCondition(joinCondition, forThisSelector);
        this.right.addJoinCondition(joinCondition, forThisSelector);
    }

    @Override
    public boolean next() {
        if (this.end) {
            return false;
        }
        if (this.leftNeedExecute) {
            this.left.execute(this.rootState);
            this.leftNeedExecute = false;
            this.leftNeedNext = true;
        }
        do {
            if (this.leftNeedNext) {
                if (!this.left.next()) {
                    this.end = true;
                    return false;
                }
                this.leftNeedNext = false;
                this.rightNeedExecute = true;
            }
            if (this.rightNeedExecute) {
                this.right.execute(this.rootState);
                this.foundJoinedRow = false;
                this.rightNeedExecute = false;
            }
            if (!this.right.next()) {
                this.leftNeedNext = true;
                continue;
            }
            if (!this.joinCondition.evaluate()) continue;
            this.foundJoinedRow = true;
            return true;
        } while (!this.right.isOuterJoinRightHandSide() || !this.leftNeedNext || this.foundJoinedRow);
        return true;
    }

    @Override
    public boolean isOuterJoinRightHandSide() {
        return this.left.isOuterJoinRightHandSide() || this.right.isOuterJoinRightHandSide();
    }

    @Override
    public long getSize(NodeState rootState, Result.SizePrecision precision, long max) {
        return -1L;
    }

    @Override
    public AstElement copyOf() {
        return new JoinImpl((SourceImpl)AstElementFactory.copyElementAndCheckReference(this.left), (SourceImpl)AstElementFactory.copyElementAndCheckReference(this.right), this.joinType, (JoinConditionImpl)AstElementFactory.copyElementAndCheckReference(this.joinCondition));
    }
}

