/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.mock.sling.context;

import org.apache.sling.featureflags.Features;
import org.apache.sling.featureflags.impl.ConfiguredFeature;
import org.apache.sling.testing.mock.sling.junit.SlingContext;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;

public class FeatureFlagsTest {
    @Rule
    public SlingContext context = new SlingContext();

    @Test
    public void testFeatureFlag_NotSet() {
        this.assertEnabled("feature.1", false);
    }

    @Test
    public void testFeatureFlag_Enabled() {
        this.context.registerInjectActivateService(new ConfiguredFeature(), new Object[]{"name", "feature.1", "enabled", true});
        this.assertEnabled("feature.1", true);
    }

    @Test
    public void testFeatureFlag__Disabled() {
        this.context.registerInjectActivateService(new ConfiguredFeature(), new Object[]{"name", "feature.1", "enabled", false});
        this.assertEnabled("feature.1", false);
    }

    private void assertEnabled(String featureFlag, boolean enabled) {
        Features features = (Features)this.context.getService(Features.class);
        Assert.assertNotNull((Object)features);
        Assert.assertEquals((String)"enabled", (Object)enabled, (Object)features.isEnabled("feature.1"));
    }
}

