# Apache Storm Website and Documentation
This is the source for the Release specific part of the Apache Storm website and documentation. It is statically generated using [jekyll](http://jekyllrb.com).

## Generate Javadoc

You have to generate javadoc on the project root before generating the document site.

```
mvn javadoc:javadoc -Dnotimestamp=true
mvn javadoc:aggregate -DreportOutputDirectory=./docs/ -DdestDir=javadocs -Dnotimestamp=true
```

You need to create a distribution package with gpg certificate. Please refer [here](https://github.com/apache/storm/blob/master/DEVELOPER.md#packaging).

## Site Generation
First install jekyll (assuming you have ruby installed):

```
gem install jekyll
```

Generate the site, and start a server locally:
```
cd docs
jekyll serve -w
```

The `-w` option tells jekyll to watch for changes to files and regenerate the site automatically when any content changes.

Point your browser to http://localhost:4000

By default, jekyll will generate the site in a `_site` directory.

This will only show the portion of the documentation that is specific to this release.

## Adding a new release to the website
In order to add a new release, you must have committer access to Storm's subversion repository at https://svn.apache.org/repos/asf/storm/site.

Release documentation is placed under the releases directory named after the release version.  Most metadata about the release will be generated automatically from the name using a jekyll plugin.  Or by placing them in the _data/releases.yml file.

To create a new release run the following from the main git directory

```
mvn javadoc:javadoc -Dnotimestamp=true
mvn javadoc:aggregate -DreportOutputDirectory=./docs/ -DdestDir=javadocs -Dnotimestamp=true
mkdir ${path_to_svn}/releases/${release_name}
#Copy everything over, and compare checksums, except for things that are part of the site,
# and are not release specific like the _* directories that are jekyll specific
# assests/ css/ and README.md
rsync -ac --delete --exclude _\* --exclude assets --exclude css --exclude README.md ./docs/ ${path_to_svn}/releases/${release_name}
cd ${path_to_svn}
svn add releases/${release_name}
svn commit
```

to publish a new release run

```
cd ${path_to_svn}
jekyll build -d publish/
svn add publish/ #Add any new files
svn commit
```

## How to release specific docs work

Release specific documentation is controlled by a jekyll plugin [releases.rb](./_plugins/releases.rb)

If the plugin is running from the git repo the config `storm_release_only` is set and the plugin will treat all of the markdown files as release specific file.

If it is running from the subversion repository it will look in the releases directory for release specific docs.

http://svn.apache.org/viewvc/storm/site/releases/

Each subdirectory named after the release in question. The "current" release is pointed to by a symlink in that directory called `current`.

The plugin sets three configs for each release page.

 * version - the version number of the release/directory
 * git-tree-base - a link to a directory in github that this version is on
 * git-blob-base - a link to where on github that this version is on, but should be used when pointing to files.

If `storm_release_only` is set for the project the version is determined from the maven pom.xml and the branch is the current branch in git.  If it is not set the version is determined by the name of the sub-directory and the branch is assumed to be a `"v#{version}"` which corresponds with our naming conventions.  For SNAPSHOT releases you will need to override this in `_data/releases.yml`

The plugin also augments the `site.data.releases` dataset.
Each release in the list includes the following, and each can be set in `_data/releases.yml` to override what is automatically generated by the plugin.

 * git-tag-or-branch - tag or branch name on github/apache/storm
 * git-tree-base - a link to a directory in github that this version is on
 * git-blob-base - a link to where on github that this version is on, but should be used when pointing to files.
 * base-name - name of the release files to download, without the .tar.gz
 * has-download - if this is an official release and a download link should be created.

So if you wanted to create a link to a file on github inside the release specific docs you would create a link like

```
[LICENSE]([DEVELOPER.md]({{page.git-blob-base}}/LICENSE)
```

If you wanted to create a maven string to tell people what dependency to use you would do something like

```
<dependency>
  ...
  <version>{{version}}</version>
</dependency>
```

If you want to refer to a javadoc for the current release use a relative path.  It will be in the javadocs subdirectory.

```
[TopologyBuilder](javadocs/org/apache/storm/topology/TopologyBuilder.html)
```
