/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.kubeclient;

import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.apache.flink.kubernetes.configuration.KubernetesLeaderElectionConfiguration;
import org.apache.flink.kubernetes.kubeclient.Endpoint;
import org.apache.flink.kubernetes.kubeclient.KubernetesConfigMapSharedWatcher;
import org.apache.flink.kubernetes.kubeclient.KubernetesJobManagerSpecification;
import org.apache.flink.kubernetes.kubeclient.resources.KubernetesConfigMap;
import org.apache.flink.kubernetes.kubeclient.resources.KubernetesLeaderElector;
import org.apache.flink.kubernetes.kubeclient.resources.KubernetesPod;
import org.apache.flink.kubernetes.kubeclient.resources.KubernetesService;
import org.apache.flink.kubernetes.kubeclient.resources.KubernetesWatch;

public interface FlinkKubeClient
extends AutoCloseable {
    public void createJobManagerComponent(KubernetesJobManagerSpecification var1);

    public CompletableFuture<Void> createTaskManagerPod(KubernetesPod var1);

    public CompletableFuture<Void> stopPod(String var1);

    public void stopAndCleanupCluster(String var1);

    public Optional<KubernetesService> getRestService(String var1);

    public Optional<Endpoint> getRestEndpoint(String var1);

    public List<KubernetesPod> getPodsWithLabels(Map<String, String> var1);

    public KubernetesWatch watchPodsAndDoCallback(Map<String, String> var1, WatchCallbackHandler<KubernetesPod> var2);

    public KubernetesLeaderElector createLeaderElector(KubernetesLeaderElectionConfiguration var1, KubernetesLeaderElector.LeaderCallbackHandler var2);

    public CompletableFuture<Void> createConfigMap(KubernetesConfigMap var1);

    public Optional<KubernetesConfigMap> getConfigMap(String var1);

    public CompletableFuture<Boolean> checkAndUpdateConfigMap(String var1, Function<KubernetesConfigMap, Optional<KubernetesConfigMap>> var2);

    public CompletableFuture<Void> deleteConfigMapsByLabels(Map<String, String> var1);

    public CompletableFuture<Void> deleteConfigMap(String var1);

    public KubernetesConfigMapSharedWatcher createConfigMapSharedWatcher(Map<String, String> var1);

    @Override
    public void close();

    public KubernetesPod loadPodFromTemplateFile(File var1);

    public static interface WatchCallbackHandler<T> {
        public void onAdded(List<T> var1);

        public void onModified(List<T> var1);

        public void onDeleted(List<T> var1);

        public void onError(List<T> var1);

        public void handleError(Throwable var1);
    }
}

