/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampark.console.core.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.apache.streampark.common.util.Utils;
import org.apache.streampark.console.base.domain.RestRequest;
import org.apache.streampark.console.base.domain.RestResponse;
import org.apache.streampark.console.core.annotation.AppUpdated;
import org.apache.streampark.console.core.entity.Project;
import org.apache.streampark.console.core.enums.GitAuthorizedError;
import org.apache.streampark.console.core.service.ProjectService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Validated
@RestController
@RequestMapping(value={"flink/project"})
public class ProjectController {
    private static final Logger log = LoggerFactory.getLogger(ProjectController.class);
    @Autowired
    private ProjectService projectService;

    @PostMapping(value={"create"})
    @RequiresPermissions(value={"project:create"})
    public RestResponse create(Project project) {
        Utils.required((project.getTeamId() != null ? 1 : 0) != 0, (Object)"The teamId cannot be null");
        return this.projectService.create(project);
    }

    @AppUpdated
    @PostMapping(value={"update"})
    @RequiresPermissions(value={"project:update"})
    public RestResponse update(Project project) {
        boolean update = this.projectService.update(project);
        return RestResponse.success().data(update);
    }

    @PostMapping(value={"get"})
    public RestResponse get(Long id) {
        return RestResponse.success().data(this.projectService.getById(id));
    }

    @PostMapping(value={"build"})
    @RequiresPermissions(value={"project:build"})
    public RestResponse build(Long id) throws Exception {
        this.projectService.build(id);
        return RestResponse.success();
    }

    @PostMapping(value={"buildlog"})
    @RequiresPermissions(value={"project:build"})
    public RestResponse buildLog(Long id, @RequestParam(value="startOffset", required=false) Long startOffset) {
        return this.projectService.getBuildLog(id, startOffset);
    }

    @PostMapping(value={"list"})
    @RequiresPermissions(value={"project:view"})
    public RestResponse list(Project project, RestRequest restRequest) {
        if (project.getTeamId() == null) {
            return RestResponse.success(Collections.emptyList());
        }
        IPage<Project> page = this.projectService.page(project, restRequest);
        return RestResponse.success().data(page);
    }

    @PostMapping(value={"branches"})
    public RestResponse branches(Project project) {
        List<String> branches = project.getAllBranches();
        return RestResponse.success().data(branches);
    }

    @PostMapping(value={"delete"})
    @RequiresPermissions(value={"project:delete"})
    public RestResponse delete(Long id) {
        Boolean deleted = this.projectService.delete(id);
        return RestResponse.success().data(deleted);
    }

    @PostMapping(value={"gitcheck"})
    public RestResponse gitCheck(Project project) {
        GitAuthorizedError error = project.gitCheck();
        return RestResponse.success().data(error.getType());
    }

    @PostMapping(value={"exists"})
    public RestResponse exists(Project project) {
        boolean exists = this.projectService.checkExists(project);
        return RestResponse.success().data(exists);
    }

    @PostMapping(value={"modules"})
    public RestResponse modules(Long id) {
        List<String> result = this.projectService.modules(id);
        return RestResponse.success().data(result);
    }

    @PostMapping(value={"jars"})
    public RestResponse jars(Project project) {
        List<String> result = this.projectService.jars(project);
        return RestResponse.success().data(result);
    }

    @PostMapping(value={"listconf"})
    public RestResponse listConf(Project project) {
        List<Map<String, Object>> list = this.projectService.listConf(project);
        return RestResponse.success().data(list);
    }

    @PostMapping(value={"select"})
    public RestResponse select(@RequestParam Long teamId) {
        List<Project> list = this.projectService.findByTeamId(teamId);
        return RestResponse.success().data(list);
    }
}

