/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampark.common.util;

import java.io.File;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.apache.streampark.common.util.Logger;
import org.apache.streampark.common.util.Logger$class;
import org.apache.streampark.common.util.SystemPropertyUtils$;
import scala.Function0;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public final class SystemPropertyUtils$
implements Logger {
    public static final SystemPropertyUtils$ MODULE$;
    private transient org.slf4j.Logger org$apache$streampark$common$util$Logger$$_logger;
    private final String org$apache$streampark$common$util$Logger$$prefix;

    static {
        new SystemPropertyUtils$();
    }

    @Override
    public org.slf4j.Logger org$apache$streampark$common$util$Logger$$_logger() {
        return this.org$apache$streampark$common$util$Logger$$_logger;
    }

    @Override
    public void org$apache$streampark$common$util$Logger$$_logger_$eq(org.slf4j.Logger x$1) {
        this.org$apache$streampark$common$util$Logger$$_logger = x$1;
    }

    @Override
    public String org$apache$streampark$common$util$Logger$$prefix() {
        return this.org$apache$streampark$common$util$Logger$$prefix;
    }

    @Override
    public void org$apache$streampark$common$util$Logger$_setter_$org$apache$streampark$common$util$Logger$$prefix_$eq(String x$1) {
        this.org$apache$streampark$common$util$Logger$$prefix = x$1;
    }

    @Override
    public String logName() {
        return Logger$class.logName(this);
    }

    @Override
    public org.slf4j.Logger logger() {
        return Logger$class.logger(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logger$class.logInfo(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logger$class.logInfo(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logger$class.logDebug(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logger$class.logDebug(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logger$class.logTrace(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logger$class.logTrace(this, msg, throwable);
    }

    @Override
    public void logWarn(Function0<String> msg) {
        Logger$class.logWarn(this, msg);
    }

    @Override
    public void logWarn(Function0<String> msg, Throwable throwable) {
        Logger$class.logWarn(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logger$class.logError(this, msg);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logger$class.logError(this, msg, throwable);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logger$class.initializeLogIfNecessary(this, isInterpreter);
    }

    public boolean contains(String key) {
        return this.get(key) != null;
    }

    public String get(String key) {
        return this.get(key, null);
    }

    public String get(String key, String string) {
        Try try_;
        block6: {
            String string2;
            block5: {
                String string3;
                block4: {
                    Predef$.MODULE$.require(key != null, (Function0)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return "[StreamPark] key must not be null.";
                        }
                    });
                    string3 = key;
                    if (string3.isEmpty()) {
                        throw new IllegalArgumentException("key must not be empty.");
                    }
                    try_ = Try$.MODULE$.apply((Function0)new Serializable(string3){
                        public static final long serialVersionUID = 0L;
                        public final String x1$1;

                        public final String apply() {
                            SecurityManager securityManager = System.getSecurityManager();
                            String string = securityManager == null ? System.getProperty(this.x1$1) : AccessController.doPrivileged(new PrivilegedAction<String>(this){
                                private final /* synthetic */ anonfun.3 $outer;

                                public String run() {
                                    return System.getProperty(this.$outer.x1$1);
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                }
                            });
                            return string;
                        }
                        {
                            this.x1$1 = x1$1;
                        }
                    });
                    if (!(try_ instanceof Success)) break block4;
                    Success success = (Success)try_;
                    String ok = (String)success.value();
                    String string4 = ok;
                    String string5 = string4 == null ? string : string4;
                    string2 = string5;
                    break block5;
                }
                if (!(try_ instanceof Failure)) break block6;
                Failure failure = (Failure)try_;
                Throwable e = failure.exception();
                this.logger().warn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unable to retrieve a system property '", "'; default values will be used, ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{string3, e.getMessage()})));
                string2 = string;
            }
            String string6 = string2;
            return string6;
        }
        throw new MatchError((Object)try_);
    }

    public boolean getBoolean(String key, boolean bl) {
        boolean bl2;
        String value = this.get(key);
        String string = value;
        if (string == null) {
            bl2 = bl;
        } else {
            boolean bl3 = "true".equals(string) ? true : ("yes".equals(string) ? true : "1".equals(string));
            if (bl3) {
                bl2 = true;
            } else {
                String string2;
                boolean bl4 = "false".equals(string) ? true : ("no".equals(string) ? true : "0".equals(string));
                if (bl4) {
                    bl2 = false;
                } else if (string != null && (string2 = string).isEmpty()) {
                    bl2 = false;
                } else {
                    this.logger().warn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unable to parse the boolean system property '", "':", " - using the default value: ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{key, value, BoxesRunTime.boxToBoolean((boolean)bl)})));
                    bl2 = bl;
                }
            }
        }
        return bl2;
    }

    public int getInt(String key, int n) {
        Try try_;
        block4: {
            int n2;
            block3: {
                block2: {
                    int ok;
                    try_ = Try$.MODULE$.apply((Function0)new Serializable(key){
                        public static final long serialVersionUID = 0L;
                        private final String key$1;

                        public final int apply() {
                            return this.apply$mcI$sp();
                        }

                        public int apply$mcI$sp() {
                            return new StringOps(Predef$.MODULE$.augmentString(SystemPropertyUtils$.MODULE$.get(this.key$1))).toInt();
                        }
                        {
                            this.key$1 = key$1;
                        }
                    });
                    if (!(try_ instanceof Success)) break block2;
                    Success success = (Success)try_;
                    n2 = ok = BoxesRunTime.unboxToInt((Object)success.value());
                    break block3;
                }
                if (!(try_ instanceof Failure)) break block4;
                n2 = n;
            }
            return n2;
        }
        throw new MatchError((Object)try_);
    }

    public long getLong(String key, long l) {
        Try try_;
        block4: {
            long l2;
            block3: {
                block2: {
                    long ok;
                    try_ = Try$.MODULE$.apply((Function0)new Serializable(key){
                        public static final long serialVersionUID = 0L;
                        private final String key$2;

                        public final long apply() {
                            return this.apply$mcJ$sp();
                        }

                        public long apply$mcJ$sp() {
                            return new StringOps(Predef$.MODULE$.augmentString(SystemPropertyUtils$.MODULE$.get(this.key$2))).toLong();
                        }
                        {
                            this.key$2 = key$2;
                        }
                    });
                    if (!(try_ instanceof Success)) break block2;
                    Success success = (Success)try_;
                    l2 = ok = BoxesRunTime.unboxToLong((Object)success.value());
                    break block3;
                }
                if (!(try_ instanceof Failure)) break block4;
                l2 = l;
            }
            return l2;
        }
        throw new MatchError((Object)try_);
    }

    public String set(String key, String value) {
        return (String)System.getProperties().setProperty(key, value);
    }

    public String getOrElseUpdate(String key, String string) {
        String string2;
        String string3 = this.get(key);
        if (string3 == null) {
            this.set(key, string);
            string2 = string;
        } else {
            string2 = string3;
        }
        return string2;
    }

    public void setAppHome(String key, Class<?> clazz) {
        if (this.get(key) == null) {
            String jarOrClassPath = clazz.getProtectionDomain().getCodeSource().getLocation().getPath();
            File file = new File(jarOrClassPath);
            String appHome = jarOrClassPath.endsWith("jar") ? file.getParentFile().getParentFile().getPath() : file.getPath().replaceAll("classes/$", "");
            this.set(key, appHome);
        }
    }

    public String getTmpdir() {
        return this.get("java.io.tmpdir", "temp");
    }

    private SystemPropertyUtils$() {
        MODULE$ = this;
        Logger$class.$init$(this);
    }
}

