/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.config.plugins.visitors;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.Node;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.util.PluginType;
import org.apache.logging.log4j.core.config.plugins.visitors.AbstractPluginVisitor;

public class PluginElementVisitor
extends AbstractPluginVisitor<PluginElement> {
    public PluginElementVisitor() {
        super(PluginElement.class);
    }

    @Override
    public Object visit(Configuration configuration, Node node, LogEvent event, StringBuilder log2) {
        String name = ((PluginElement)this.annotation).value();
        if (this.conversionType.isArray()) {
            this.setConversionType(this.conversionType.getComponentType());
            ArrayList values2 = new ArrayList();
            ArrayList<Node> used = new ArrayList<Node>();
            log2.append("={");
            boolean first = true;
            for (Node child : node.getChildren()) {
                PluginType<?> childType = child.getType();
                if (!name.equalsIgnoreCase(childType.getElementName()) && !this.conversionType.isAssignableFrom(childType.getPluginClass())) continue;
                if (!first) {
                    log2.append(", ");
                }
                first = false;
                used.add(child);
                Object childObject = child.getObject();
                if (childObject == null) {
                    LOGGER.error("Null object returned for {} in {}.", (Object)child.getName(), (Object)node.getName());
                    continue;
                }
                if (childObject.getClass().isArray()) {
                    log2.append(Arrays.toString((Object[])childObject)).append('}');
                    node.getChildren().removeAll(used);
                    return childObject;
                }
                log2.append(child.toString());
                values2.add(childObject);
            }
            log2.append('}');
            if (!values2.isEmpty() && !this.conversionType.isAssignableFrom(values2.get(0).getClass())) {
                LOGGER.error("Attempted to assign attribute {} to list of type {} which is incompatible with {}.", (Object)name, (Object)values2.get(0).getClass(), (Object)this.conversionType);
                return null;
            }
            node.getChildren().removeAll(used);
            Object[] array2 = (Object[])Array.newInstance(this.conversionType, values2.size());
            for (int i = 0; i < array2.length; ++i) {
                array2[i] = values2.get(i);
            }
            return array2;
        }
        Node namedNode = this.findNamedNode(name, node.getChildren());
        if (namedNode == null) {
            log2.append(name).append("=null");
            return null;
        }
        log2.append(namedNode.getName()).append('(').append(namedNode.toString()).append(')');
        node.getChildren().remove(namedNode);
        return namedNode.getObject();
    }

    private Node findNamedNode(String name, Iterable<Node> children2) {
        for (Node child : children2) {
            PluginType<?> childType = child.getType();
            if (childType == null) {
                // empty if block
            }
            if (!name.equalsIgnoreCase(childType.getElementName()) && !this.conversionType.isAssignableFrom(childType.getPluginClass())) continue;
            return child;
        }
        return null;
    }
}

