/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampark.flink.client.trait;

import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.apache.flink.api.common.JobID;
import org.apache.flink.client.deployment.ClusterSpecification;
import org.apache.flink.client.program.ClusterClient;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.DeploymentOptions;
import org.apache.flink.kubernetes.KubernetesClusterClientFactory;
import org.apache.flink.kubernetes.KubernetesClusterDescriptor;
import org.apache.flink.kubernetes.configuration.KubernetesConfigOptions;
import org.apache.streampark.common.enums.ExecutionMode;
import org.apache.streampark.common.enums.FlinkK8sRestExposedType;
import org.apache.streampark.flink.client.bean.CancelRequest;
import org.apache.streampark.flink.client.bean.CancelResponse;
import org.apache.streampark.flink.client.bean.SubmitRequest;
import org.apache.streampark.flink.client.trait.KubernetesNativeSubmitTrait;
import org.apache.streampark.flink.kubernetes.IngressController$;
import org.apache.streampark.flink.packer.pipeline.DockerImageBuildResponse;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public abstract class KubernetesNativeSubmitTrait$class {
    public static void setConfig(KubernetesNativeSubmitTrait $this, SubmitRequest submitRequest, Configuration flinkConfig) {
        $this.EnhanceFlinkConfiguration($this.EnhanceFlinkConfiguration($this.EnhanceFlinkConfiguration(flinkConfig).safeSet(KubernetesConfigOptions.CLUSTER_ID, submitRequest.k8sSubmitParam().clusterId())).safeSet(KubernetesConfigOptions.NAMESPACE, submitRequest.k8sSubmitParam().kubernetesNamespace())).safeSet(KubernetesConfigOptions.REST_SERVICE_EXPOSED_TYPE, KubernetesNativeSubmitTrait$class.covertToServiceExposedType($this, submitRequest.k8sSubmitParam().flinkRestExposedType()));
        if (submitRequest.buildResult() != null) {
            ExecutionMode executionMode = submitRequest.executionMode();
            ExecutionMode executionMode2 = ExecutionMode.KUBERNETES_NATIVE_APPLICATION;
            if (!(executionMode != null ? !executionMode.equals(executionMode2) : executionMode2 != null)) {
                DockerImageBuildResponse buildResult = (DockerImageBuildResponse)submitRequest.buildResult();
                buildResult.podTemplatePaths().foreach((Function1)new Serializable($this, flinkConfig){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ KubernetesNativeSubmitTrait $outer;
                    private final Configuration flinkConfig$1;

                    public final Configuration apply(Tuple2<String, String> p) {
                        return this.$outer.EnhanceFlinkConfiguration(this.$outer.EnhanceFlinkConfiguration(this.$outer.EnhanceFlinkConfiguration(this.flinkConfig$1).safeSet(KubernetesConfigOptions.KUBERNETES_POD_TEMPLATE, p._2())).safeSet(KubernetesConfigOptions.JOB_MANAGER_POD_TEMPLATE, p._2())).safeSet(KubernetesConfigOptions.TASK_MANAGER_POD_TEMPLATE, p._2());
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.flinkConfig$1 = flinkConfig$1;
                    }
                });
            }
        }
        Object object = ((String)flinkConfig.get(KubernetesConfigOptions.NAMESPACE)).isEmpty() ? BoxesRunTime.boxToBoolean((boolean)flinkConfig.removeConfig(KubernetesConfigOptions.NAMESPACE)) : BoxedUnit.UNIT;
        $this.logInfo((Function0)new Serializable($this, flinkConfig){
            public static final long serialVersionUID = 0L;
            private final Configuration flinkConfig$1;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |------------------------------------------------------------------\n         |Effective submit configuration: ", "\n         |------------------------------------------------------------------\n         |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.flinkConfig$1})))).stripMargin();
            }
            {
                this.flinkConfig$1 = flinkConfig$1;
            }
        });
    }

    public static CancelResponse doCancel(KubernetesNativeSubmitTrait $this, CancelRequest cancelRequest, Configuration flinkConfig) throws Exception {
        Predef$.MODULE$.require(StringUtils.isNotBlank((CharSequence)cancelRequest.clusterId()), (Function0)new Serializable($this, flinkConfig){
            public static final long serialVersionUID = 0L;
            private final Configuration flinkConfig$2;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"[flink-submit] stop flink job failed, clusterId is null, mode=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.flinkConfig$2.get(DeploymentOptions.TARGET)}));
            }
            {
                this.flinkConfig$2 = flinkConfig$2;
            }
        });
        $this.EnhanceFlinkConfiguration($this.EnhanceFlinkConfiguration(flinkConfig).safeSet(KubernetesConfigOptions.CLUSTER_ID, cancelRequest.clusterId())).safeSet(KubernetesConfigOptions.NAMESPACE, cancelRequest.kubernetesNamespace());
        KubernetesClusterDescriptor clusterDescriptor = null;
        ClusterClient client = null;
        try {
            clusterDescriptor = $this.getK8sClusterDescriptor(flinkConfig);
            client = clusterDescriptor.retrieve(flinkConfig.getString(KubernetesConfigOptions.CLUSTER_ID)).getClusterClient();
            JobID jobID = JobID.fromHexString((String)cancelRequest.jobId());
            String actionResult = $this.org$apache$streampark$flink$client$trait$KubernetesNativeSubmitTrait$$super$cancelJob(cancelRequest, jobID, client);
            IngressController$.MODULE$.deleteIngress(cancelRequest.clusterId(), cancelRequest.kubernetesNamespace());
            return new CancelResponse(actionResult);
        }
        catch (Exception exception) {
            $this.logger().error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"[flink-submit] stop flink job failed, mode=", ", cancelRequest=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{flinkConfig.get(DeploymentOptions.TARGET), cancelRequest})));
            throw exception;
        }
        finally {
            if (client != null) {
                client.close();
            }
            if (clusterDescriptor != null) {
                clusterDescriptor.close();
            }
        }
    }

    public static Tuple2 getK8sClusterDescriptorAndSpecification(KubernetesNativeSubmitTrait $this, Configuration flinkConfig) {
        KubernetesClusterClientFactory clientFactory = new KubernetesClusterClientFactory();
        KubernetesClusterDescriptor clusterDescriptor = clientFactory.createClusterDescriptor(flinkConfig);
        ClusterSpecification clusterSpecification = clientFactory.getClusterSpecification(flinkConfig);
        return new Tuple2((Object)clusterDescriptor, (Object)clusterSpecification);
    }

    /*
     * WARNING - void declaration
     */
    public static KubernetesClusterDescriptor getK8sClusterDescriptor(KubernetesNativeSubmitTrait $this, Configuration flinkConfig) {
        void var3_3;
        KubernetesClusterClientFactory clientFactory = new KubernetesClusterClientFactory();
        KubernetesClusterDescriptor clusterDescriptor = clientFactory.createClusterDescriptor(flinkConfig);
        return var3_3;
    }

    public static String flinkConfIdentifierInfo(KubernetesNativeSubmitTrait $this, @Nonnull Configuration conf) {
        return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"executionMode=", ", clusterId=", ", "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{conf.get(DeploymentOptions.TARGET), conf.get(KubernetesConfigOptions.CLUSTER_ID)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"namespace=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{conf.get(KubernetesConfigOptions.NAMESPACE)}))).toString();
    }

    private static KubernetesConfigOptions.ServiceExposedType covertToServiceExposedType(KubernetesNativeSubmitTrait $this, FlinkK8sRestExposedType exposedType) {
        FlinkK8sRestExposedType flinkK8sRestExposedType = exposedType;
        KubernetesConfigOptions.ServiceExposedType serviceExposedType = FlinkK8sRestExposedType.ClusterIP.equals(flinkK8sRestExposedType) ? KubernetesConfigOptions.ServiceExposedType.ClusterIP : (FlinkK8sRestExposedType.LoadBalancer.equals(flinkK8sRestExposedType) ? KubernetesConfigOptions.ServiceExposedType.LoadBalancer : (FlinkK8sRestExposedType.NodePort.equals(flinkK8sRestExposedType) ? KubernetesConfigOptions.ServiceExposedType.NodePort : KubernetesConfigOptions.ServiceExposedType.LoadBalancer));
        return serviceExposedType;
    }

    public static String getDefaultKubernetesConf(KubernetesNativeSubmitTrait $this, String k8sConf) {
        String homePath = System.getProperty("user.home");
        return k8sConf == null ? homePath.concat("/.kube/config") : k8sConf.replace("~", homePath);
    }

    public static void $init$(KubernetesNativeSubmitTrait $this) {
        $this.org$apache$streampark$flink$client$trait$KubernetesNativeSubmitTrait$_setter_$fatJarCached_$eq(new HashMap());
    }
}

