/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.functions.sink.filesystem;

import java.io.IOException;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.serialization.BulkWriter;
import org.apache.flink.core.fs.RecoverableFsDataOutputStream;
import org.apache.flink.streaming.api.functions.sink.filesystem.InProgressFileWriter;
import org.apache.flink.streaming.api.functions.sink.filesystem.OutputStreamBasedPartFileWriter;
import org.apache.flink.util.Preconditions;

@Internal
final class BulkPartWriter<IN, BucketID>
extends OutputStreamBasedPartFileWriter<IN, BucketID> {
    private final BulkWriter<IN> writer;

    BulkPartWriter(BucketID bucketId, RecoverableFsDataOutputStream currentPartStream, BulkWriter<IN> writer, long creationTime) {
        super(bucketId, currentPartStream, creationTime);
        this.writer = (BulkWriter)Preconditions.checkNotNull(writer);
    }

    @Override
    public void write(IN element, long currentTime) throws IOException {
        this.writer.addElement(element);
        this.markWrite(currentTime);
    }

    @Override
    public InProgressFileWriter.InProgressFileRecoverable persist() {
        throw new UnsupportedOperationException("Bulk Part Writers do not support \"pause and resume\" operations.");
    }

    @Override
    public InProgressFileWriter.PendingFileRecoverable closeForCommit() throws IOException {
        this.writer.flush();
        this.writer.finish();
        return super.closeForCommit();
    }
}

