/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.client.deployment.application;

import java.util.ArrayList;
import java.util.List;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.JobID;
import org.apache.flink.client.ClientUtils;
import org.apache.flink.client.deployment.application.ApplicationRunner;
import org.apache.flink.client.deployment.application.executors.WebSubmissionExecutorServiceLoader;
import org.apache.flink.client.program.PackagedProgram;
import org.apache.flink.client.program.ProgramInvocationException;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.DeploymentOptions;
import org.apache.flink.runtime.dispatcher.DispatcherGateway;
import org.apache.flink.util.FlinkRuntimeException;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class DetachedApplicationRunner
implements ApplicationRunner {
    private static final Logger LOG = LoggerFactory.getLogger(DetachedApplicationRunner.class);
    private final boolean enforceSingleJobExecution;

    public DetachedApplicationRunner(boolean enforceSingleJobExecution) {
        this.enforceSingleJobExecution = enforceSingleJobExecution;
    }

    @Override
    public List<JobID> run(DispatcherGateway dispatcherGateway, PackagedProgram program, Configuration configuration) {
        Preconditions.checkNotNull((Object)dispatcherGateway);
        Preconditions.checkNotNull((Object)program);
        Preconditions.checkNotNull((Object)configuration);
        return this.tryExecuteJobs(dispatcherGateway, program, configuration);
    }

    private List<JobID> tryExecuteJobs(DispatcherGateway dispatcherGateway, PackagedProgram program, Configuration configuration) {
        configuration.set(DeploymentOptions.ATTACHED, (Object)false);
        ArrayList<JobID> applicationJobIds = new ArrayList<JobID>();
        WebSubmissionExecutorServiceLoader executorServiceLoader = new WebSubmissionExecutorServiceLoader(applicationJobIds, dispatcherGateway);
        try {
            ClientUtils.executeProgram(executorServiceLoader, configuration, program, this.enforceSingleJobExecution, true);
        }
        catch (ProgramInvocationException e) {
            LOG.warn("Could not execute application: ", (Throwable)e);
            throw new FlinkRuntimeException("Could not execute application.", (Throwable)e);
        }
        return applicationJobIds;
    }
}

