/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.client.program;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.client.deployment.application.EntryClassInformationProvider;
import org.apache.flink.client.deployment.application.FromClasspathEntryClassInformationProvider;
import org.apache.flink.client.deployment.application.FromJarEntryClassInformationProvider;
import org.apache.flink.client.program.PackagedProgram;
import org.apache.flink.client.program.PackagedProgramRetriever;
import org.apache.flink.client.program.PackagedProgramUtils;
import org.apache.flink.client.program.ProgramInvocationException;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.util.FileUtils;
import org.apache.flink.util.FlinkException;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.function.FunctionUtils;

public class DefaultPackagedProgramRetriever
implements PackagedProgramRetriever {
    private final EntryClassInformationProvider entryClassInformationProvider;
    private final String[] programArguments;
    private final List<URL> userClasspath;
    private final Configuration configuration;

    public static DefaultPackagedProgramRetriever create(@Nullable File userLibDir, @Nullable String jobClassName, String[] programArgs, Configuration configuration) throws FlinkException {
        return DefaultPackagedProgramRetriever.create(userLibDir, null, jobClassName, programArgs, configuration);
    }

    public static DefaultPackagedProgramRetriever create(@Nullable File userLibDir, @Nullable File jarFile, @Nullable String jobClassName, String[] programArgs, Configuration configuration) throws FlinkException {
        List<URL> userClasspath;
        try {
            userClasspath = DefaultPackagedProgramRetriever.extractUserClasspath(userLibDir);
        }
        catch (IOException e) {
            throw new FlinkException("An error occurred while extracting the user classpath.", (Throwable)e);
        }
        EntryClassInformationProvider entryClassInformationProvider = DefaultPackagedProgramRetriever.createEntryClassInformationProvider(userLibDir == null ? null : userClasspath, jarFile, jobClassName, programArgs);
        return new DefaultPackagedProgramRetriever(entryClassInformationProvider, programArgs, userClasspath, configuration);
    }

    @VisibleForTesting
    static EntryClassInformationProvider createEntryClassInformationProvider(@Nullable Iterable<URL> userClasspath, @Nullable File jarFile, @Nullable String jobClassName, String[] programArgs) throws FlinkException {
        if (PackagedProgramUtils.isPython(jobClassName).booleanValue() || PackagedProgramUtils.isPython(programArgs)) {
            return FromJarEntryClassInformationProvider.createFromPythonJar();
        }
        if (jarFile != null) {
            return FromJarEntryClassInformationProvider.createFromCustomJar(jarFile, jobClassName);
        }
        if (userClasspath != null) {
            return DefaultPackagedProgramRetriever.fromUserClasspath(jobClassName, userClasspath);
        }
        return DefaultPackagedProgramRetriever.fromSystemClasspath(jobClassName);
    }

    private static EntryClassInformationProvider fromSystemClasspath(@Nullable String jobClassName) throws FlinkException {
        if (jobClassName != null) {
            return FromClasspathEntryClassInformationProvider.createWithJobClassAssumingOnSystemClasspath(jobClassName);
        }
        try {
            return FromClasspathEntryClassInformationProvider.createFromSystemClasspath();
        }
        catch (IOException | IllegalArgumentException | NoSuchElementException t) {
            throw DefaultPackagedProgramRetriever.createGenericFlinkException(t);
        }
    }

    private static EntryClassInformationProvider fromUserClasspath(@Nullable String jobClassName, Iterable<URL> userClasspath) throws FlinkException {
        try {
            if (jobClassName != null) {
                return FromClasspathEntryClassInformationProvider.create(jobClassName, userClasspath);
            }
            return FromClasspathEntryClassInformationProvider.createFromClasspath(userClasspath);
        }
        catch (IOException e) {
            throw DefaultPackagedProgramRetriever.createGenericFlinkException(e);
        }
    }

    private static FlinkException createGenericFlinkException(Throwable t) {
        return new FlinkException("An error occurred while access the provided classpath.", t);
    }

    private DefaultPackagedProgramRetriever(EntryClassInformationProvider entryClassInformationProvider, String[] programArguments, List<URL> userClasspath, Configuration configuration) {
        this.entryClassInformationProvider = (EntryClassInformationProvider)Preconditions.checkNotNull((Object)entryClassInformationProvider, (String)"No EntryClassInformationProvider passed.");
        this.programArguments = (String[])Preconditions.checkNotNull((Object)programArguments, (String)"No program parameter array passed.");
        this.userClasspath = (List)Preconditions.checkNotNull(userClasspath, (String)"No user classpath passed.");
        this.configuration = (Configuration)Preconditions.checkNotNull((Object)configuration, (String)"No Flink configuration was passed.");
    }

    @Override
    public PackagedProgram getPackagedProgram() throws FlinkException {
        try {
            PackagedProgram.Builder packagedProgramBuilder = PackagedProgram.newBuilder().setUserClassPaths(this.userClasspath).setArguments(this.programArguments).setConfiguration(this.configuration);
            this.entryClassInformationProvider.getJobClassName().ifPresent(packagedProgramBuilder::setEntryPointClassName);
            this.entryClassInformationProvider.getJarFile().ifPresent(packagedProgramBuilder::setJarFile);
            return packagedProgramBuilder.build();
        }
        catch (ProgramInvocationException e) {
            throw new FlinkException("Could not load the provided entrypoint class.", (Throwable)e);
        }
    }

    private static List<URL> extractUserClasspath(@Nullable File userLibDir) throws IOException {
        if (userLibDir == null) {
            return Collections.emptyList();
        }
        Path workingDirectory = FileUtils.getCurrentWorkingDirectory();
        List relativeJarURLs = FileUtils.listFilesInDirectory((Path)userLibDir.toPath(), FileUtils::isJarFile).stream().map(path -> FileUtils.relativizePath((Path)workingDirectory, (Path)path)).map(FunctionUtils.uncheckedFunction(FileUtils::toURL)).collect(Collectors.toList());
        return Collections.unmodifiableList(relativeJarURLs);
    }
}

