/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampark.console.core.bean;

import java.io.Serializable;
import java.util.Date;
import java.util.TimeZone;
import org.apache.streampark.common.enums.ExecutionMode;
import org.apache.streampark.common.util.DateUtils;
import org.apache.streampark.common.util.YarnUtils;
import org.apache.streampark.console.core.entity.Application;
import org.apache.streampark.console.core.enums.CheckPointStatus;
import org.apache.streampark.console.core.enums.FlinkAppState;

public class AlertTemplate
implements Serializable {
    private String title;
    private String subject;
    private String jobName;
    private String status;
    private Integer type;
    private String startTime;
    private String endTime;
    private String duration;
    private String link;
    private String cpFailureRateInterval;
    private Integer cpMaxFailureInterval;
    private Boolean restart;
    private Integer restartIndex;
    private Integer totalRestart;
    private boolean atAll = false;

    private static AlertTemplate of(Application application) {
        long duration = application.getEndTime() == null ? System.currentTimeMillis() - application.getStartTime().getTime() : application.getEndTime().getTime() - application.getStartTime().getTime();
        AlertTemplate template = new AlertTemplate();
        template.setJobName(application.getJobName());
        if (ExecutionMode.isYarnMode((Integer)application.getExecutionMode())) {
            String format = "%s/proxy/%s/";
            String url = String.format(format, YarnUtils.getRMWebAppURL(), application.getAppId());
            template.setLink(url);
        } else {
            template.setLink(null);
        }
        template.setStartTime(DateUtils.format((Date)application.getStartTime(), (String)DateUtils.fullFormat(), (TimeZone)TimeZone.getDefault()));
        template.setEndTime(DateUtils.format((Date)(application.getEndTime() == null ? new Date() : application.getEndTime()), (String)DateUtils.fullFormat(), (TimeZone)TimeZone.getDefault()));
        template.setDuration(DateUtils.toDuration((long)duration));
        boolean needRestart = application.isNeedRestartOnFailed() && application.getRestartCount() > 0;
        template.setRestart(needRestart);
        if (needRestart) {
            template.setRestartIndex(application.getRestartCount());
            template.setTotalRestart(application.getRestartSize());
        }
        return template;
    }

    public static AlertTemplate of(Application application, FlinkAppState appState) {
        AlertTemplate template = AlertTemplate.of(application);
        template.setType(1);
        template.setTitle(String.format("Notify: %s %s", application.getJobName(), appState.name()));
        template.setSubject(String.format("StreamPark Alert: %s %s", template.getJobName(), appState));
        template.setStatus(appState.name());
        return template;
    }

    public static AlertTemplate of(Application application, CheckPointStatus checkPointStatus) {
        AlertTemplate template = AlertTemplate.of(application);
        template.setType(2);
        template.setCpFailureRateInterval(DateUtils.toDuration((long)(application.getCpFailureRateInterval() * 1000 * 60)));
        template.setCpMaxFailureInterval(application.getCpMaxFailureInterval());
        template.setTitle(String.format("Notify: %s checkpoint FAILED", application.getJobName()));
        template.setSubject(String.format("StreamPark Alert: %s, checkPoint is Failed", template.getJobName()));
        return template;
    }

    public String getTitle() {
        return this.title;
    }

    public String getSubject() {
        return this.subject;
    }

    public String getJobName() {
        return this.jobName;
    }

    public String getStatus() {
        return this.status;
    }

    public Integer getType() {
        return this.type;
    }

    public String getStartTime() {
        return this.startTime;
    }

    public String getEndTime() {
        return this.endTime;
    }

    public String getDuration() {
        return this.duration;
    }

    public String getLink() {
        return this.link;
    }

    public String getCpFailureRateInterval() {
        return this.cpFailureRateInterval;
    }

    public Integer getCpMaxFailureInterval() {
        return this.cpMaxFailureInterval;
    }

    public Boolean getRestart() {
        return this.restart;
    }

    public Integer getRestartIndex() {
        return this.restartIndex;
    }

    public Integer getTotalRestart() {
        return this.totalRestart;
    }

    public boolean isAtAll() {
        return this.atAll;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public void setJobName(String jobName) {
        this.jobName = jobName;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public void setStartTime(String startTime) {
        this.startTime = startTime;
    }

    public void setEndTime(String endTime) {
        this.endTime = endTime;
    }

    public void setDuration(String duration) {
        this.duration = duration;
    }

    public void setLink(String link) {
        this.link = link;
    }

    public void setCpFailureRateInterval(String cpFailureRateInterval) {
        this.cpFailureRateInterval = cpFailureRateInterval;
    }

    public void setCpMaxFailureInterval(Integer cpMaxFailureInterval) {
        this.cpMaxFailureInterval = cpMaxFailureInterval;
    }

    public void setRestart(Boolean restart) {
        this.restart = restart;
    }

    public void setRestartIndex(Integer restartIndex) {
        this.restartIndex = restartIndex;
    }

    public void setTotalRestart(Integer totalRestart) {
        this.totalRestart = totalRestart;
    }

    public void setAtAll(boolean atAll) {
        this.atAll = atAll;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AlertTemplate)) {
            return false;
        }
        AlertTemplate other = (AlertTemplate)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isAtAll() != other.isAtAll()) {
            return false;
        }
        Integer this$type = this.getType();
        Integer other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)this$type).equals(other$type)) {
            return false;
        }
        Integer this$cpMaxFailureInterval = this.getCpMaxFailureInterval();
        Integer other$cpMaxFailureInterval = other.getCpMaxFailureInterval();
        if (this$cpMaxFailureInterval == null ? other$cpMaxFailureInterval != null : !((Object)this$cpMaxFailureInterval).equals(other$cpMaxFailureInterval)) {
            return false;
        }
        Boolean this$restart = this.getRestart();
        Boolean other$restart = other.getRestart();
        if (this$restart == null ? other$restart != null : !((Object)this$restart).equals(other$restart)) {
            return false;
        }
        Integer this$restartIndex = this.getRestartIndex();
        Integer other$restartIndex = other.getRestartIndex();
        if (this$restartIndex == null ? other$restartIndex != null : !((Object)this$restartIndex).equals(other$restartIndex)) {
            return false;
        }
        Integer this$totalRestart = this.getTotalRestart();
        Integer other$totalRestart = other.getTotalRestart();
        if (this$totalRestart == null ? other$totalRestart != null : !((Object)this$totalRestart).equals(other$totalRestart)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        String this$subject = this.getSubject();
        String other$subject = other.getSubject();
        if (this$subject == null ? other$subject != null : !this$subject.equals(other$subject)) {
            return false;
        }
        String this$jobName = this.getJobName();
        String other$jobName = other.getJobName();
        if (this$jobName == null ? other$jobName != null : !this$jobName.equals(other$jobName)) {
            return false;
        }
        String this$status = this.getStatus();
        String other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        String this$startTime = this.getStartTime();
        String other$startTime = other.getStartTime();
        if (this$startTime == null ? other$startTime != null : !this$startTime.equals(other$startTime)) {
            return false;
        }
        String this$endTime = this.getEndTime();
        String other$endTime = other.getEndTime();
        if (this$endTime == null ? other$endTime != null : !this$endTime.equals(other$endTime)) {
            return false;
        }
        String this$duration = this.getDuration();
        String other$duration = other.getDuration();
        if (this$duration == null ? other$duration != null : !this$duration.equals(other$duration)) {
            return false;
        }
        String this$link = this.getLink();
        String other$link = other.getLink();
        if (this$link == null ? other$link != null : !this$link.equals(other$link)) {
            return false;
        }
        String this$cpFailureRateInterval = this.getCpFailureRateInterval();
        String other$cpFailureRateInterval = other.getCpFailureRateInterval();
        return !(this$cpFailureRateInterval == null ? other$cpFailureRateInterval != null : !this$cpFailureRateInterval.equals(other$cpFailureRateInterval));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AlertTemplate;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isAtAll() ? 79 : 97);
        Integer $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)$type).hashCode());
        Integer $cpMaxFailureInterval = this.getCpMaxFailureInterval();
        result = result * 59 + ($cpMaxFailureInterval == null ? 43 : ((Object)$cpMaxFailureInterval).hashCode());
        Boolean $restart = this.getRestart();
        result = result * 59 + ($restart == null ? 43 : ((Object)$restart).hashCode());
        Integer $restartIndex = this.getRestartIndex();
        result = result * 59 + ($restartIndex == null ? 43 : ((Object)$restartIndex).hashCode());
        Integer $totalRestart = this.getTotalRestart();
        result = result * 59 + ($totalRestart == null ? 43 : ((Object)$totalRestart).hashCode());
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        String $subject = this.getSubject();
        result = result * 59 + ($subject == null ? 43 : $subject.hashCode());
        String $jobName = this.getJobName();
        result = result * 59 + ($jobName == null ? 43 : $jobName.hashCode());
        String $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        String $startTime = this.getStartTime();
        result = result * 59 + ($startTime == null ? 43 : $startTime.hashCode());
        String $endTime = this.getEndTime();
        result = result * 59 + ($endTime == null ? 43 : $endTime.hashCode());
        String $duration = this.getDuration();
        result = result * 59 + ($duration == null ? 43 : $duration.hashCode());
        String $link = this.getLink();
        result = result * 59 + ($link == null ? 43 : $link.hashCode());
        String $cpFailureRateInterval = this.getCpFailureRateInterval();
        result = result * 59 + ($cpFailureRateInterval == null ? 43 : $cpFailureRateInterval.hashCode());
        return result;
    }

    public String toString() {
        return "AlertTemplate(title=" + this.getTitle() + ", subject=" + this.getSubject() + ", jobName=" + this.getJobName() + ", status=" + this.getStatus() + ", type=" + this.getType() + ", startTime=" + this.getStartTime() + ", endTime=" + this.getEndTime() + ", duration=" + this.getDuration() + ", link=" + this.getLink() + ", cpFailureRateInterval=" + this.getCpFailureRateInterval() + ", cpMaxFailureInterval=" + this.getCpMaxFailureInterval() + ", restart=" + this.getRestart() + ", restartIndex=" + this.getRestartIndex() + ", totalRestart=" + this.getTotalRestart() + ", atAll=" + this.isAtAll() + ")";
    }
}

