/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampark.console.system.controller;

import java.util.ArrayList;
import java.util.Map;
import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.apache.streampark.console.base.domain.RestResponse;
import org.apache.streampark.console.base.domain.router.VueRouter;
import org.apache.streampark.console.core.service.CommonService;
import org.apache.streampark.console.system.entity.Menu;
import org.apache.streampark.console.system.service.MenuService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Validated
@RestController
@RequestMapping(value={"/menu"})
public class MenuController {
    private static final Logger log = LoggerFactory.getLogger(MenuController.class);
    @Autowired
    private MenuService menuService;
    @Autowired
    private CommonService commonService;

    @PostMapping(value={"router"})
    public RestResponse getUserRouters(Long teamId) {
        ArrayList<VueRouter<Menu>> routers = this.menuService.getUserRouters(this.commonService.getUserId(), teamId);
        return RestResponse.success(routers);
    }

    @PostMapping(value={"list"})
    @RequiresPermissions(value={"menu:view"})
    public RestResponse menuList(Menu menu) {
        Map<String, Object> maps = this.menuService.findMenus(menu);
        return RestResponse.success(maps);
    }

    @PostMapping(value={"post"})
    @RequiresPermissions(value={"menu:add"})
    public RestResponse addMenu(@Valid Menu menu) {
        this.menuService.createMenu(menu);
        return RestResponse.success();
    }

    @DeleteMapping(value={"delete"})
    @RequiresPermissions(value={"menu:delete"})
    public RestResponse deleteMenus(@NotBlank(message="{required}") @NotBlank(message="{required}") String menuIds) throws Exception {
        String[] ids = menuIds.split(",");
        this.menuService.deleteMenus(ids);
        return RestResponse.success();
    }

    @PutMapping(value={"update"})
    @RequiresPermissions(value={"menu:update"})
    public RestResponse updateMenu(@Valid Menu menu) throws Exception {
        this.menuService.updateMenu(menu);
        return RestResponse.success();
    }
}

