/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampark.console.system.security.impl;

import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.apache.streampark.console.base.util.ShaHashUtils;
import org.apache.streampark.console.core.enums.UserType;
import org.apache.streampark.console.system.entity.User;
import org.apache.streampark.console.system.security.Authenticator;
import org.apache.streampark.console.system.security.impl.ldap.LdapService;
import org.apache.streampark.console.system.service.UserService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AuthenticatorImpl
implements Authenticator {
    @Autowired
    private UserService usersService;
    @Autowired
    private LdapService ldapService;

    @Override
    public User authenticate(String username, String password) {
        User user = this.usersService.findByName(username);
        if (user == null) {
            return null;
        }
        String salt = user.getSalt();
        password = ShaHashUtils.encrypt(salt, password);
        if (!StringUtils.equals((CharSequence)user.getPassword(), (CharSequence)password)) {
            return null;
        }
        return user;
    }

    @Override
    public User ldapAuthenticate(String username, String password) throws Exception {
        String ldapEmail = this.ldapService.ldapLogin(username, password);
        if (ldapEmail == null) {
            return null;
        }
        User user = this.usersService.findByName(username);
        if (user != null || !this.ldapService.createIfUserNotExists()) {
            return user;
        }
        User newUser = new User();
        newUser.setCreateTime(new Date());
        newUser.setUsername(username);
        newUser.setNickName(username);
        newUser.setUserType(UserType.USER);
        newUser.setStatus("1");
        newUser.setSex("2");
        newUser.setPassword(password);
        this.usersService.createUser(newUser);
        return newUser;
    }
}

