/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.spring.web.readers.operation;

import com.fasterxml.classmate.ResolvedType;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestPart;
import springfox.documentation.schema.ResolvedTypes;
import springfox.documentation.schema.plugins.SchemaPluginsManager;
import springfox.documentation.service.ResolvedMethodParameter;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.schema.ViewProviderPlugin;
import springfox.documentation.spi.service.OperationModelsProviderPlugin;
import springfox.documentation.spi.service.contexts.RequestMappingContext;

@Component
@Order(value=-2147483648)
public class OperationModelsProvider
implements OperationModelsProviderPlugin {
    private static final Logger LOG = LoggerFactory.getLogger(OperationModelsProvider.class);
    private final SchemaPluginsManager pluginsManager;

    @Autowired
    public OperationModelsProvider(SchemaPluginsManager pluginsManager) {
        this.pluginsManager = pluginsManager;
    }

    public void apply(RequestMappingContext context) {
        this.collectFromReturnType(context);
        this.collectParameters(context);
        this.collectGlobalModels(context);
    }

    private void collectGlobalModels(RequestMappingContext context) {
        for (ResolvedType each : context.getAdditionalModels()) {
            context.operationModelsBuilder().addInputParam(each);
            context.operationModelsBuilder().addReturn(each);
        }
    }

    public boolean supports(DocumentationType delimiter) {
        return true;
    }

    private void collectFromReturnType(RequestMappingContext context) {
        ResolvedType modelType = context.getReturnType();
        modelType = context.alternateFor(modelType);
        LOG.debug("Adding return parameter of type {}", (Object)ResolvedTypes.resolvedTypeSignature((ResolvedType)modelType).orElse("<null>"));
        context.operationModelsBuilder().addReturn(modelType, this.viewForReturn(context));
    }

    private void collectParameters(RequestMappingContext context) {
        LOG.debug("Reading parameters models for handlerMethod |{}|", (Object)context.getName());
        List parameterTypes = context.getParameters();
        for (ResolvedMethodParameter parameterType : parameterTypes) {
            if (!parameterType.hasParameterAnnotation(RequestBody.class) && !parameterType.hasParameterAnnotation(RequestPart.class)) continue;
            ResolvedType modelType = context.alternateFor(parameterType.getParameterType());
            LOG.debug("Adding input parameter of type {}", (Object)ResolvedTypes.resolvedTypeSignature((ResolvedType)modelType).orElse("<null>"));
            context.operationModelsBuilder().addInputParam(modelType, this.viewForParameter(context, parameterType), new HashSet());
        }
        LOG.debug("Finished reading parameters models for handlerMethod |{}|", (Object)context.getName());
    }

    private Optional<ResolvedType> viewForReturn(RequestMappingContext context) {
        ViewProviderPlugin viewProvider = this.pluginsManager.viewProvider(context.getDocumentationContext().getDocumentationType());
        return viewProvider.viewFor(context);
    }

    private Optional<ResolvedType> viewForParameter(RequestMappingContext context, ResolvedMethodParameter parameter) {
        ViewProviderPlugin viewProvider = this.pluginsManager.viewProvider(context.getDocumentationContext().getDocumentationType());
        return viewProvider.viewFor(parameter);
    }
}

