/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.spring.web.scanners;

import java.util.Collection;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import springfox.documentation.service.ApiDescription;
import springfox.documentation.service.ResourceGroup;
import springfox.documentation.spi.service.contexts.Orderings;

class ResourceGroups {
    private ResourceGroups() {
        throw new UnsupportedOperationException();
    }

    static Iterable<ResourceGroup> collectResourceGroups(Collection<ApiDescription> apiDescriptions) {
        return apiDescriptions.stream().map(ResourceGroups.toResourceGroups()).collect(Collectors.toList());
    }

    static Iterable<ResourceGroup> sortedByName(Set<ResourceGroup> resourceGroups) {
        return resourceGroups.stream().sorted(Orderings.resourceGroupComparator()).collect(Collectors.toList());
    }

    static Predicate<ApiDescription> belongsTo(String groupName) {
        return input -> !input.getGroupName().isPresent() || groupName.equals(input.getGroupName().get());
    }

    private static Function<ApiDescription, ResourceGroup> toResourceGroups() {
        return input -> new ResourceGroup(input.getGroupName().orElse("default"), null);
    }
}

