/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampark.console.core.controller;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import org.apache.streampark.console.base.domain.RestResponse;
import org.apache.streampark.console.base.exception.ApiDetailException;
import org.apache.streampark.console.core.entity.FlinkEnv;
import org.apache.streampark.console.core.service.FlinkEnvService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="FLINK_ENV_TAG")
@Validated
@RestController
@RequestMapping(value={"flink/env"})
public class FlinkEnvController {
    private static final Logger log = LoggerFactory.getLogger(FlinkEnvController.class);
    @Autowired
    private FlinkEnvService flinkEnvService;

    @Operation(summary="Get flink environment")
    @PostMapping(value={"list"})
    public RestResponse list() {
        List list = this.flinkEnvService.list();
        return RestResponse.success(list);
    }

    @Operation(summary="Verify flink environment")
    @PostMapping(value={"check"})
    public RestResponse check(FlinkEnv version) {
        Integer checkResp = this.flinkEnvService.check(version);
        return RestResponse.success(checkResp);
    }

    @Operation(summary="Create flink environment")
    @PostMapping(value={"create"})
    public RestResponse create(FlinkEnv version) {
        try {
            this.flinkEnvService.create(version);
        }
        catch (Exception e) {
            throw new ApiDetailException(e);
        }
        return RestResponse.success(true);
    }

    @Operation(summary="Get flink environment")
    @PostMapping(value={"get"})
    public RestResponse get(Long id) throws Exception {
        FlinkEnv flinkEnv = (FlinkEnv)this.flinkEnvService.getById(id);
        flinkEnv.unzipFlinkConf();
        return RestResponse.success(flinkEnv);
    }

    @Operation(summary="Sync flink environment conf")
    @PostMapping(value={"sync"})
    public RestResponse sync(Long id) throws Exception {
        this.flinkEnvService.syncConf(id);
        return RestResponse.success();
    }

    @Operation(summary="Update flink environment")
    @PostMapping(value={"update"})
    public RestResponse update(FlinkEnv version) throws Exception {
        try {
            this.flinkEnvService.update(version);
        }
        catch (Exception e) {
            throw new ApiDetailException(e);
        }
        return RestResponse.success(true);
    }

    @Operation(summary="Delete flink environment")
    @PostMapping(value={"delete"})
    public RestResponse delete(Long id) {
        this.flinkEnvService.delete(id);
        return RestResponse.success();
    }

    @Operation(summary="Check flink environment is valid, else throw exception")
    @PostMapping(value={"validity"})
    public RestResponse validity(FlinkEnv version) {
        this.flinkEnvService.validity(version.getId());
        return RestResponse.success(true);
    }

    @Operation(summary="Update flink environment as default")
    @PostMapping(value={"default"})
    public RestResponse setDefault(Long id) {
        this.flinkEnvService.setDefault(id);
        return RestResponse.success();
    }
}

