/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.typeutils.base;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.typeutils.GenericTypeSerializerConfigSnapshot;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerSchemaCompatibility;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.api.java.typeutils.runtime.DataInputViewStream;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.util.InstantiationUtil;
import org.apache.flink.util.Preconditions;

@Internal
public final class EnumSerializer<T extends Enum<T>>
extends TypeSerializer<T> {
    private static final long serialVersionUID = 1L;
    private final Class<T> enumClass;
    private Map<T, Integer> valueToOrdinal;
    private T[] values;

    public EnumSerializer(Class<T> enumClass) {
        this(enumClass, (Enum[])enumClass.getEnumConstants());
    }

    private EnumSerializer(Class<T> enumClass, T[] enumValues) {
        this.enumClass = Preconditions.checkNotNull(enumClass);
        this.values = (Enum[])Preconditions.checkNotNull(enumValues);
        Preconditions.checkArgument(Enum.class.isAssignableFrom(enumClass), "not an enum");
        Preconditions.checkArgument(this.values.length > 0, "cannot use an empty enum");
        this.valueToOrdinal = new EnumMap<T, Integer>(this.enumClass);
        int i = 0;
        for (T value : this.values) {
            this.valueToOrdinal.put(value, i++);
        }
    }

    @Override
    public boolean isImmutableType() {
        return true;
    }

    @Override
    public EnumSerializer<T> duplicate() {
        return this;
    }

    @Override
    public T createInstance() {
        Preconditions.checkState(this.values != null);
        return this.values[0];
    }

    @Override
    public T copy(T from) {
        return from;
    }

    @Override
    public T copy(T from, T reuse) {
        return from;
    }

    @Override
    public int getLength() {
        return 4;
    }

    @Override
    public void serialize(T record, DataOutputView target) throws IOException {
        target.writeInt(this.valueToOrdinal.get(record));
    }

    @Override
    public T deserialize(DataInputView source) throws IOException {
        return this.values[source.readInt()];
    }

    @Override
    public T deserialize(T reuse, DataInputView source) throws IOException {
        return this.values[source.readInt()];
    }

    @Override
    public void copy(DataInputView source, DataOutputView target) throws IOException {
        target.write(source, 4);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof EnumSerializer) {
            EnumSerializer other = (EnumSerializer)obj;
            return other.enumClass == this.enumClass && Arrays.equals(this.values, other.values);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.enumClass.hashCode();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.values == null) {
            this.values = (Enum[])this.enumClass.getEnumConstants();
            this.valueToOrdinal = new EnumMap<T, Integer>(this.enumClass);
            int i = 0;
            for (T value : this.values) {
                this.valueToOrdinal.put(value, i++);
            }
        }
    }

    @Override
    public EnumSerializerSnapshot<T> snapshotConfiguration() {
        return new EnumSerializerSnapshot(this.enumClass, this.values);
    }

    @VisibleForTesting
    T[] getValues() {
        return this.values;
    }

    @VisibleForTesting
    Map<T, Integer> getValueToOrdinal() {
        return this.valueToOrdinal;
    }

    public String toString() {
        return "EnumSerializer{enumClass=" + this.enumClass + ", values=" + Arrays.toString(this.values) + '}';
    }

    @Deprecated
    public static final class EnumSerializerConfigSnapshot<T extends Enum<T>>
    extends GenericTypeSerializerConfigSnapshot<T> {
        private static final int VERSION = 2;
        private List<String> enumConstants;

        @Override
        public void write(DataOutputView out) throws IOException {
            super.write(out);
            out.writeInt(this.enumConstants.size());
            for (String enumConstant : this.enumConstants) {
                out.writeUTF(enumConstant);
            }
        }

        @Override
        public void read(DataInputView in) throws IOException {
            block19: {
                super.read(in);
                if (this.getReadVersion() == 1) {
                    try (DataInputViewStream inViewWrapper = new DataInputViewStream(in);){
                        try {
                            Enum[] legacyEnumConstants = (Enum[])InstantiationUtil.deserializeObject(inViewWrapper, this.getUserCodeClassLoader());
                            this.enumConstants = EnumSerializerConfigSnapshot.buildEnumConstantsList((Enum[])legacyEnumConstants);
                            break block19;
                        }
                        catch (ClassNotFoundException e) {
                            throw new IOException("The requested enum class cannot be found in classpath.", e);
                        }
                        catch (IllegalArgumentException e) {
                            throw new IOException("A previously existing enum constant of " + this.getTypeClass().getName() + " no longer exists.", e);
                        }
                    }
                }
                if (this.getReadVersion() == 2) {
                    int numEnumConstants = in.readInt();
                    this.enumConstants = new ArrayList<String>(numEnumConstants);
                    for (int i = 0; i < numEnumConstants; ++i) {
                        this.enumConstants.add(in.readUTF());
                    }
                } else {
                    throw new IOException("Cannot deserialize EnumSerializerConfigSnapshot with version " + this.getReadVersion());
                }
            }
        }

        @Override
        public TypeSerializerSchemaCompatibility<T> resolveSchemaCompatibility(TypeSerializer<T> newSerializer) {
            Class enumClass = this.getTypeClass();
            Enum[] previousEnums = (Enum[])Array.newInstance(enumClass, this.enumConstants.size());
            for (int i = 0; i < this.enumConstants.size(); ++i) {
                String enumName = this.enumConstants.get(i);
                try {
                    previousEnums[i] = Enum.valueOf(enumClass, enumName);
                    continue;
                }
                catch (IllegalArgumentException e) {
                    throw new RuntimeException("Could not create a restore serializer for enum " + enumClass + ". Probably because an enum value was removed.");
                }
            }
            return new EnumSerializerSnapshot(enumClass, previousEnums).resolveSchemaCompatibility(newSerializer);
        }

        @Override
        public int getVersion() {
            return 2;
        }

        @Override
        public int[] getCompatibleVersions() {
            return new int[]{2, 1};
        }

        List<String> getEnumConstants() {
            return this.enumConstants;
        }

        @Override
        public boolean equals(Object obj) {
            return super.equals(obj) && this.enumConstants.equals(((EnumSerializerConfigSnapshot)obj).getEnumConstants());
        }

        @Override
        public int hashCode() {
            return super.hashCode() * 31 + this.enumConstants.hashCode();
        }

        private static <T extends Enum<T>> List<String> buildEnumConstantsList(T[] enumConstantsArr) {
            ArrayList<String> res = new ArrayList<String>(enumConstantsArr.length);
            for (T enumConstant : enumConstantsArr) {
                res.add(((Enum)enumConstant).name());
            }
            return res;
        }
    }

    public static final class EnumSerializerSnapshot<T extends Enum<T>>
    implements TypeSerializerSnapshot<T> {
        private static final int CURRENT_VERSION = 3;
        private T[] previousEnums;
        private Class<T> enumClass;

        public EnumSerializerSnapshot() {
        }

        EnumSerializerSnapshot(Class<T> enumClass, T[] enums) {
            this.enumClass = Preconditions.checkNotNull(enumClass);
            this.previousEnums = (Enum[])Preconditions.checkNotNull(enums);
        }

        @Override
        public int getCurrentVersion() {
            return 3;
        }

        @Override
        public void writeSnapshot(DataOutputView out) throws IOException {
            Preconditions.checkState(this.enumClass != null, "Enum class can not be null.");
            out.writeUTF(this.enumClass.getName());
            out.writeInt(this.previousEnums.length);
            for (T enumConstant : this.previousEnums) {
                out.writeUTF(((Enum)enumConstant).name());
            }
        }

        @Override
        public void readSnapshot(int readVersion, DataInputView in, ClassLoader userCodeClassLoader) throws IOException {
            this.enumClass = InstantiationUtil.resolveClassByName(in, userCodeClassLoader);
            int numEnumConstants = in.readInt();
            Enum[] previousEnums = (Enum[])Array.newInstance(this.enumClass, numEnumConstants);
            for (int i = 0; i < numEnumConstants; ++i) {
                String enumName = in.readUTF();
                try {
                    previousEnums[i] = Enum.valueOf(this.enumClass, enumName);
                    continue;
                }
                catch (IllegalArgumentException e) {
                    throw new IllegalStateException("Could not create a restore serializer for enum " + this.enumClass + ". Probably because an enum value was removed.");
                }
            }
            this.previousEnums = previousEnums;
        }

        @Override
        public TypeSerializer<T> restoreSerializer() {
            Preconditions.checkState(this.enumClass != null, "Enum class can not be null.");
            return new EnumSerializer(this.enumClass, (Enum[])this.previousEnums);
        }

        @Override
        public TypeSerializerSchemaCompatibility<T> resolveSchemaCompatibility(TypeSerializer<T> newSerializer) {
            if (!(newSerializer instanceof EnumSerializer)) {
                return TypeSerializerSchemaCompatibility.incompatible();
            }
            EnumSerializer newEnumSerializer = (EnumSerializer)newSerializer;
            if (!this.enumClass.equals(newEnumSerializer.enumClass)) {
                return TypeSerializerSchemaCompatibility.incompatible();
            }
            Object[] currentEnums = (Enum[])this.enumClass.getEnumConstants();
            if (Arrays.equals(this.previousEnums, currentEnums)) {
                return TypeSerializerSchemaCompatibility.compatibleAsIs();
            }
            LinkedHashSet<Enum> reconfiguredEnumSet = new LinkedHashSet<Enum>(Arrays.asList(this.previousEnums));
            reconfiguredEnumSet.addAll(Arrays.asList(currentEnums));
            Enum[] reconfiguredEnums = reconfiguredEnumSet.toArray((Enum[])Array.newInstance(this.enumClass, reconfiguredEnumSet.size()));
            EnumSerializer reconfiguredSerializer = new EnumSerializer(this.enumClass, reconfiguredEnums);
            return TypeSerializerSchemaCompatibility.compatibleWithReconfiguredSerializer(reconfiguredSerializer);
        }
    }
}

