/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.util;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.util.Preconditions;

@Internal
public final class LinkedOptionalMap<K, V> {
    private final LinkedHashMap<String, KeyValue<K, V>> underlyingMap;

    public static <K, V> LinkedOptionalMap<K, V> optionalMapOf(Map<K, V> sourceMap, Function<K, String> keyNameGetter) {
        LinkedHashMap underlyingMap = new LinkedHashMap(sourceMap.size());
        sourceMap.forEach((? super K k, ? super V v) -> {
            String keyName = (String)keyNameGetter.apply(k);
            underlyingMap.put(keyName, new KeyValue<Object, Object>(k, v));
        });
        return new LinkedOptionalMap<K, V>(underlyingMap);
    }

    public static <K, V> MergeResult<K, V> mergeRightIntoLeft(LinkedOptionalMap<K, V> left, LinkedOptionalMap<K, V> right) {
        LinkedOptionalMap<K, V> merged = new LinkedOptionalMap<K, V>(left);
        merged.putAll(right);
        return new MergeResult<K, V>(merged, LinkedOptionalMap.isLeftPrefixOfRight(left, right));
    }

    public LinkedOptionalMap() {
        this(new LinkedHashMap<String, KeyValue<K, V>>());
    }

    public LinkedOptionalMap(int initialSize) {
        this(new LinkedHashMap<String, KeyValue<K, V>>(initialSize));
    }

    LinkedOptionalMap(LinkedOptionalMap<K, V> linkedOptionalMap) {
        this(new LinkedHashMap<String, KeyValue<K, V>>(linkedOptionalMap.underlyingMap));
    }

    private LinkedOptionalMap(LinkedHashMap<String, KeyValue<K, V>> underlyingMap) {
        this.underlyingMap = Preconditions.checkNotNull(underlyingMap);
    }

    public int size() {
        return this.underlyingMap.size();
    }

    public void put(String keyName, @Nullable K key, @Nullable V value) {
        Preconditions.checkNotNull(keyName);
        this.underlyingMap.compute(keyName, (unused, kv) -> kv == null ? new KeyValue<Object, Object>(key, value) : kv.merge(key, value));
    }

    void putAll(LinkedOptionalMap<K, V> right) {
        for (Map.Entry<String, KeyValue<K, V>> entry : right.underlyingMap.entrySet()) {
            KeyValue<K, V> kv = entry.getValue();
            this.put(entry.getKey(), kv.key, kv.value);
        }
    }

    public Set<String> absentKeysOrValues() {
        return this.underlyingMap.entrySet().stream().filter(LinkedOptionalMap::keyOrValueIsAbsent).map(Map.Entry::getKey).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    public boolean hasAbsentKeysOrValues() {
        for (Map.Entry<String, KeyValue<K, V>> entry : this.underlyingMap.entrySet()) {
            if (!LinkedOptionalMap.keyOrValueIsAbsent(entry)) continue;
            return true;
        }
        return false;
    }

    public <E extends Throwable> void forEach(ConsumerWithException<K, V, E> consumer) throws E {
        for (Map.Entry<String, KeyValue<K, V>> entry : this.underlyingMap.entrySet()) {
            KeyValue<K, V> kv = entry.getValue();
            consumer.accept(entry.getKey(), kv.key, kv.value);
        }
    }

    public Set<KeyValue<K, V>> getPresentEntries() {
        return this.underlyingMap.entrySet().stream().filter(entry -> !LinkedOptionalMap.keyOrValueIsAbsent(entry)).map(Map.Entry::getValue).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    public LinkedHashMap<K, V> unwrapOptionals() {
        LinkedHashMap unwrapped = new LinkedHashMap(this.underlyingMap.size());
        for (Map.Entry<String, KeyValue<K, V>> entry : this.underlyingMap.entrySet()) {
            String namedKey = entry.getKey();
            KeyValue<K, V> kv = entry.getValue();
            if (kv.key == null) {
                throw new IllegalStateException("Missing key '" + namedKey + "'");
            }
            if (kv.value == null) {
                throw new IllegalStateException("Missing value for the key '" + namedKey + "'");
            }
            unwrapped.put(kv.key, kv.value);
        }
        return unwrapped;
    }

    public Set<String> keyNames() {
        return this.underlyingMap.keySet();
    }

    private static <K, V> boolean keyOrValueIsAbsent(Map.Entry<String, KeyValue<K, V>> entry) {
        KeyValue<K, V> kv = entry.getValue();
        return kv.key == null || kv.value == null;
    }

    @VisibleForTesting
    static <K, V> boolean isLeftPrefixOfRight(LinkedOptionalMap<K, V> left, LinkedOptionalMap<K, V> right) {
        Iterator<String> rightKeys = right.keyNames().iterator();
        for (String leftKey : left.keyNames()) {
            if (!rightKeys.hasNext()) {
                return false;
            }
            String rightKey = rightKeys.next();
            if (leftKey.equals(rightKey)) continue;
            return false;
        }
        return true;
    }

    public static final class MergeResult<K, V> {
        private final LinkedOptionalMap<K, V> merged;
        private final Set<String> missingKeys;
        private final boolean isOrderedSubset;

        MergeResult(LinkedOptionalMap<K, V> merged, boolean isOrderedSubset) {
            this.merged = merged;
            this.missingKeys = merged.absentKeysOrValues();
            this.isOrderedSubset = isOrderedSubset;
        }

        public boolean hasMissingKeys() {
            return !this.missingKeys.isEmpty();
        }

        public Set<String> missingKeys() {
            return this.missingKeys;
        }

        public LinkedHashMap<K, V> getMerged() {
            return this.merged.unwrapOptionals();
        }

        public boolean isOrderedSubset() {
            return this.isOrderedSubset;
        }
    }

    public static final class KeyValue<K, V> {
        K key;
        V value;

        KeyValue(K key, V value) {
            this.key = key;
            this.value = value;
        }

        public K getKey() {
            return this.key;
        }

        public V getValue() {
            return this.value;
        }

        KeyValue<K, V> merge(K key, V value) {
            this.key = KeyValue.firstNonNull(key, this.key);
            this.value = KeyValue.firstNonNull(value, this.value);
            return this;
        }

        private static <T> T firstNonNull(T first, T second) {
            if (first != null) {
                return first;
            }
            return second;
        }
    }

    @FunctionalInterface
    public static interface ConsumerWithException<K, V, E extends Throwable> {
        public void accept(@Nonnull String var1, @Nullable K var2, @Nullable V var3) throws E;
    }
}

