/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.optimizer.dag;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.flink.api.common.ExecutionMode;
import org.apache.flink.api.common.operators.AbstractUdfOperator;
import org.apache.flink.api.common.operators.CompilerHints;
import org.apache.flink.api.common.operators.Operator;
import org.apache.flink.api.common.operators.SemanticProperties;
import org.apache.flink.api.common.operators.util.FieldSet;
import org.apache.flink.optimizer.CompilerException;
import org.apache.flink.optimizer.DataStatistics;
import org.apache.flink.optimizer.costs.CostEstimator;
import org.apache.flink.optimizer.dag.DagConnection;
import org.apache.flink.optimizer.dag.EstimateProvider;
import org.apache.flink.optimizer.dag.SingleInputNode;
import org.apache.flink.optimizer.dataproperties.InterestingProperties;
import org.apache.flink.optimizer.dataproperties.RequestedGlobalProperties;
import org.apache.flink.optimizer.dataproperties.RequestedLocalProperties;
import org.apache.flink.optimizer.plan.PlanNode;
import org.apache.flink.optimizer.plandump.DumpableConnection;
import org.apache.flink.optimizer.plandump.DumpableNode;
import org.apache.flink.runtime.operators.shipping.ShipStrategyType;
import org.apache.flink.util.Visitable;
import org.apache.flink.util.Visitor;

public abstract class OptimizerNode
implements Visitable<OptimizerNode>,
EstimateProvider,
DumpableNode<OptimizerNode> {
    public static final int MAX_DYNAMIC_PATH_COST_WEIGHT = 100;
    private final Operator<?> operator;
    private List<String> broadcastConnectionNames = new ArrayList<String>();
    private List<DagConnection> broadcastConnections = new ArrayList<DagConnection>();
    private List<DagConnection> outgoingConnections;
    private InterestingProperties intProps;
    protected List<UnclosedBranchDescriptor> openBranches;
    protected Set<OptimizerNode> closedBranchingNodes;
    protected List<OptimizerNode> hereJoinedBranches;
    protected long estimatedOutputSize = -1L;
    protected long estimatedNumRecords = -1L;
    protected Set<FieldSet> uniqueFields;
    private int parallelism = -1;
    private long minimalMemoryPerSubTask = -1L;
    protected int id = -1;
    protected int costWeight = 1;
    protected boolean onDynamicPath;
    protected List<PlanNode> cachedPlans;

    public OptimizerNode(Operator<?> op) {
        this.operator = op;
        this.readStubAnnotations();
    }

    protected OptimizerNode(OptimizerNode toCopy) {
        this.operator = toCopy.operator;
        this.intProps = toCopy.intProps;
        this.openBranches = toCopy.openBranches;
        this.closedBranchingNodes = toCopy.closedBranchingNodes;
        this.estimatedOutputSize = toCopy.estimatedOutputSize;
        this.estimatedNumRecords = toCopy.estimatedNumRecords;
        this.parallelism = toCopy.parallelism;
        this.minimalMemoryPerSubTask = toCopy.minimalMemoryPerSubTask;
        this.id = toCopy.id;
        this.costWeight = toCopy.costWeight;
        this.onDynamicPath = toCopy.onDynamicPath;
    }

    public abstract String getOperatorName();

    public abstract void setInput(Map<Operator<?>, OptimizerNode> var1, ExecutionMode var2);

    public void setBroadcastInputs(Map<Operator<?>, OptimizerNode> operatorToNode, ExecutionMode defaultExchangeMode) {
        if (!(this.getOperator() instanceof AbstractUdfOperator)) {
            return;
        }
        AbstractUdfOperator operator = (AbstractUdfOperator)this.getOperator();
        for (Map.Entry input : operator.getBroadcastInputs().entrySet()) {
            OptimizerNode predecessor = operatorToNode.get(input.getValue());
            DagConnection connection = new DagConnection(predecessor, this, ShipStrategyType.BROADCAST, defaultExchangeMode);
            this.addBroadcastConnection((String)input.getKey(), connection);
            predecessor.addOutgoingConnection(connection);
        }
    }

    public abstract List<DagConnection> getIncomingConnections();

    public abstract void computeInterestingPropertiesForInputs(CostEstimator var1);

    public abstract void computeUnclosedBranchStack();

    protected List<UnclosedBranchDescriptor> computeUnclosedBranchStackForBroadcastInputs(List<UnclosedBranchDescriptor> branchesSoFar) {
        for (DagConnection broadcastInput : this.getBroadcastConnections()) {
            OptimizerNode bcSource = broadcastInput.getSource();
            this.addClosedBranches(bcSource.closedBranchingNodes);
            List<UnclosedBranchDescriptor> bcBranches = bcSource.getBranchesForParent(broadcastInput);
            ArrayList<UnclosedBranchDescriptor> mergedBranches = new ArrayList<UnclosedBranchDescriptor>();
            this.mergeLists(branchesSoFar, bcBranches, mergedBranches, true);
            branchesSoFar = mergedBranches.isEmpty() ? Collections.emptyList() : mergedBranches;
        }
        return branchesSoFar;
    }

    public abstract List<PlanNode> getAlternativePlans(CostEstimator var1);

    public abstract void accept(Visitor<OptimizerNode> var1);

    public abstract SemanticProperties getSemanticProperties();

    @Override
    public Iterable<OptimizerNode> getPredecessors() {
        ArrayList<OptimizerNode> allPredecessors = new ArrayList<OptimizerNode>();
        for (DagConnection dagConnection : this.getIncomingConnections()) {
            allPredecessors.add(dagConnection.getSource());
        }
        for (DagConnection conn : this.getBroadcastConnections()) {
            allPredecessors.add(conn.getSource());
        }
        return allPredecessors;
    }

    public int getId() {
        return this.id;
    }

    public void initId(int id) {
        if (id <= 0) {
            throw new IllegalArgumentException();
        }
        if (this.id != -1) {
            throw new IllegalStateException("Id has already been initialized.");
        }
        this.id = id;
    }

    public void addBroadcastConnection(String name, DagConnection broadcastConnection) {
        this.broadcastConnectionNames.add(name);
        this.broadcastConnections.add(broadcastConnection);
    }

    public List<String> getBroadcastConnectionNames() {
        return this.broadcastConnectionNames;
    }

    public List<DagConnection> getBroadcastConnections() {
        return this.broadcastConnections;
    }

    public void addOutgoingConnection(DagConnection connection) {
        if (this.outgoingConnections == null) {
            this.outgoingConnections = new ArrayList<DagConnection>();
        } else if (this.outgoingConnections.size() == 64) {
            throw new CompilerException("Cannot currently handle nodes with more than 64 outputs.");
        }
        this.outgoingConnections.add(connection);
    }

    public List<DagConnection> getOutgoingConnections() {
        return this.outgoingConnections;
    }

    public Operator<?> getOperator() {
        return this.operator;
    }

    public int getParallelism() {
        return this.parallelism;
    }

    public void setParallelism(int parallelism) {
        if (parallelism < 1 && parallelism != -1) {
            throw new IllegalArgumentException("Parallelism of " + parallelism + " is invalid.");
        }
        this.parallelism = parallelism;
    }

    public long getMinimalMemoryAcrossAllSubTasks() {
        return this.minimalMemoryPerSubTask == -1L ? -1L : this.minimalMemoryPerSubTask * (long)this.parallelism;
    }

    public boolean isOnDynamicPath() {
        return this.onDynamicPath;
    }

    public void identifyDynamicPath(int costWeight) {
        boolean dynamicIn;
        boolean anyDynamic = false;
        boolean allDynamic = true;
        for (DagConnection conn : this.getIncomingConnections()) {
            dynamicIn = conn.isOnDynamicPath();
            anyDynamic |= dynamicIn;
            allDynamic &= dynamicIn;
        }
        for (DagConnection conn : this.getBroadcastConnections()) {
            dynamicIn = conn.isOnDynamicPath();
            anyDynamic |= dynamicIn;
            allDynamic &= dynamicIn;
        }
        if (anyDynamic) {
            this.onDynamicPath = true;
            this.costWeight = costWeight;
            if (!allDynamic) {
                for (DagConnection conn : this.getIncomingConnections()) {
                    if (conn.getSource().isOnDynamicPath()) continue;
                    conn.setMaterializationMode(conn.getMaterializationMode().makeCached());
                }
            }
        }
    }

    public int getCostWeight() {
        return this.costWeight;
    }

    public int getMaxDepth() {
        int maxDepth = 0;
        for (DagConnection conn : this.getIncomingConnections()) {
            maxDepth = Math.max(maxDepth, conn.getMaxDepth());
        }
        for (DagConnection conn : this.getBroadcastConnections()) {
            maxDepth = Math.max(maxDepth, conn.getMaxDepth());
        }
        return maxDepth;
    }

    public InterestingProperties getInterestingProperties() {
        return this.intProps;
    }

    @Override
    public long getEstimatedOutputSize() {
        return this.estimatedOutputSize;
    }

    @Override
    public long getEstimatedNumRecords() {
        return this.estimatedNumRecords;
    }

    public void setEstimatedOutputSize(long estimatedOutputSize) {
        this.estimatedOutputSize = estimatedOutputSize;
    }

    public void setEstimatedNumRecords(long estimatedNumRecords) {
        this.estimatedNumRecords = estimatedNumRecords;
    }

    @Override
    public float getEstimatedAvgWidthPerOutputRecord() {
        if (this.estimatedOutputSize > 0L && this.estimatedNumRecords > 0L) {
            return (float)this.estimatedOutputSize / (float)this.estimatedNumRecords;
        }
        return -1.0f;
    }

    public boolean isBranching() {
        return this.getOutgoingConnections() != null && this.getOutgoingConnections().size() > 1;
    }

    public void markAllOutgoingConnectionsAsPipelineBreaking() {
        if (this.outgoingConnections == null) {
            throw new IllegalStateException("The outgoing connections have not yet been initialized.");
        }
        for (DagConnection conn : this.getOutgoingConnections()) {
            conn.markBreaksPipeline();
        }
    }

    public boolean haveAllOutputConnectionInterestingProperties() {
        for (DagConnection conn : this.getOutgoingConnections()) {
            if (conn.getInterestingProperties() != null) continue;
            return false;
        }
        return true;
    }

    public void computeUnionOfInterestingPropertiesFromSuccessors() {
        List<DagConnection> conns = this.getOutgoingConnections();
        if (conns.size() == 0) {
            this.intProps = new InterestingProperties();
        } else {
            this.intProps = conns.get(0).getInterestingProperties().clone();
            for (int i = 1; i < conns.size(); ++i) {
                this.intProps.addInterestingProperties(conns.get(i).getInterestingProperties());
            }
        }
        this.intProps.dropTrivials();
    }

    public void clearInterestingProperties() {
        this.intProps = null;
        for (DagConnection conn : this.getIncomingConnections()) {
            conn.clearInterestingProperties();
        }
        for (DagConnection conn : this.getBroadcastConnections()) {
            conn.clearInterestingProperties();
        }
    }

    public void computeOutputEstimates(DataStatistics statistics) {
        for (DagConnection c : this.getIncomingConnections()) {
            if (c.getSource() != null) continue;
            throw new CompilerException("Bug: Estimate computation called before inputs have been set.");
        }
        this.computeOperatorSpecificDefaultEstimates(statistics);
        if (this.estimatedOutputSize < 0L) {
            this.estimatedOutputSize = -1L;
        }
        if (this.estimatedNumRecords < 0L) {
            this.estimatedNumRecords = -1L;
        }
        if (this.getOperator() == null || this.getOperator().getCompilerHints() == null) {
            return;
        }
        CompilerHints hints = this.getOperator().getCompilerHints();
        if (hints.getOutputSize() >= 0L) {
            this.estimatedOutputSize = hints.getOutputSize();
        }
        if (hints.getOutputCardinality() >= 0L) {
            this.estimatedNumRecords = hints.getOutputCardinality();
        }
        if (hints.getFilterFactor() >= 0.0f) {
            OptimizerNode pred;
            if (this.estimatedNumRecords >= 0L) {
                this.estimatedNumRecords = (long)((float)this.estimatedNumRecords * hints.getFilterFactor());
                if (this.estimatedOutputSize >= 0L) {
                    this.estimatedOutputSize = (long)((float)this.estimatedOutputSize * hints.getFilterFactor());
                }
            } else if (this instanceof SingleInputNode && (pred = ((SingleInputNode)this).getPredecessorNode()) != null && pred.getEstimatedNumRecords() >= 0L) {
                this.estimatedNumRecords = (long)((float)pred.getEstimatedNumRecords() * hints.getFilterFactor());
            }
        }
        if (hints.getAvgOutputRecordSize() >= 1.0f) {
            if (this.estimatedNumRecords == -1L && this.estimatedOutputSize >= 0L) {
                this.estimatedNumRecords = (long)((float)this.estimatedOutputSize / hints.getAvgOutputRecordSize());
            } else if (this.estimatedOutputSize == -1L && this.estimatedNumRecords >= 0L) {
                this.estimatedOutputSize = (long)((float)this.estimatedNumRecords * hints.getAvgOutputRecordSize());
            }
        }
    }

    protected abstract void computeOperatorSpecificDefaultEstimates(DataStatistics var1);

    protected void readStubAnnotations() {
        this.readUniqueFieldsAnnotation();
    }

    protected void readUniqueFieldsAnnotation() {
        Set uniqueFieldSets;
        if (this.operator.getCompilerHints() != null && (uniqueFieldSets = this.operator.getCompilerHints().getUniqueFields()) != null) {
            if (this.uniqueFields == null) {
                this.uniqueFields = new HashSet<FieldSet>();
            }
            this.uniqueFields.addAll(uniqueFieldSets);
        }
    }

    public Set<FieldSet> getUniqueFields() {
        return this.uniqueFields == null ? Collections.emptySet() : this.uniqueFields;
    }

    protected void prunePlanAlternatives(List<PlanNode> plans) {
        if (plans.isEmpty()) {
            throw new CompilerException("No plan meeting the requirements could be created @ " + this + ". Most likely reason: Too restrictive plan hints.");
        }
        if (plans.size() == 1) {
            return;
        }
        if (this.openBranches == null || this.openBranches.isEmpty()) {
            this.prunePlanAlternativesWithCommonBranching(plans);
        } else {
            final OptimizerNode[] branchDeterminers = new OptimizerNode[this.openBranches.size()];
            for (int i = 0; i < branchDeterminers.length; ++i) {
                branchDeterminers[i] = this.openBranches.get(this.openBranches.size() - 1 - i).getBranchingNode();
            }
            Comparator<PlanNode> sorter = new Comparator<PlanNode>(){

                @Override
                public int compare(PlanNode o1, PlanNode o2) {
                    for (OptimizerNode branchDeterminer : branchDeterminers) {
                        int hash2;
                        PlanNode n1 = o1.getCandidateAtBranchPoint(branchDeterminer);
                        PlanNode n2 = o2.getCandidateAtBranchPoint(branchDeterminer);
                        int hash1 = System.identityHashCode(n1);
                        if (hash1 == (hash2 = System.identityHashCode(n2))) continue;
                        return hash1 - hash2;
                    }
                    return 0;
                }
            };
            Collections.sort(plans, sorter);
            ArrayList<PlanNode> result = new ArrayList<PlanNode>();
            ArrayList<PlanNode> turn = new ArrayList<PlanNode>();
            PlanNode[] determinerChoice = new PlanNode[branchDeterminers.length];
            while (!plans.isEmpty()) {
                turn.clear();
                PlanNode determiner = plans.remove(plans.size() - 1);
                turn.add(determiner);
                for (int i = 0; i < determinerChoice.length; ++i) {
                    determinerChoice[i] = determiner.getCandidateAtBranchPoint(branchDeterminers[i]);
                }
                boolean stillEqual = true;
                for (int k = plans.size() - 1; k >= 0 && stillEqual; --k) {
                    PlanNode toCheck = plans.get(k);
                    for (int i = 0; i < branchDeterminers.length; ++i) {
                        PlanNode checkerChoice = toCheck.getCandidateAtBranchPoint(branchDeterminers[i]);
                        if (checkerChoice == determinerChoice[i]) continue;
                        stillEqual = false;
                        break;
                    }
                    if (!stillEqual) continue;
                    plans.remove(k);
                    turn.add(toCheck);
                }
                if (turn.size() > 1) {
                    this.prunePlanAlternativesWithCommonBranching(turn);
                }
                result.addAll(turn);
            }
            plans.clear();
            plans.addAll(result);
        }
    }

    protected void prunePlanAlternativesWithCommonBranching(List<PlanNode> plans) {
        RequestedGlobalProperties[] gps = this.intProps.getGlobalProperties().toArray(new RequestedGlobalProperties[this.intProps.getGlobalProperties().size()]);
        RequestedLocalProperties[] lps = this.intProps.getLocalProperties().toArray(new RequestedLocalProperties[this.intProps.getLocalProperties().size()]);
        PlanNode[][] toKeep = new PlanNode[gps.length][];
        PlanNode[] cheapestForGlobal = new PlanNode[gps.length];
        PlanNode cheapest = null;
        for (PlanNode candidate : plans) {
            if (cheapest == null || cheapest.getCumulativeCosts().compareTo(candidate.getCumulativeCosts()) > 0) {
                cheapest = candidate;
            }
            for (int i = 0; i < gps.length; ++i) {
                PlanNode[] localMatches;
                if (!gps[i].isMetBy(candidate.getGlobalProperties())) continue;
                if (cheapestForGlobal[i] == null || cheapestForGlobal[i].getCumulativeCosts().compareTo(candidate.getCumulativeCosts()) > 0) {
                    cheapestForGlobal[i] = candidate;
                }
                if (toKeep[i] == null) {
                    localMatches = new PlanNode[lps.length];
                    toKeep[i] = localMatches;
                } else {
                    localMatches = toKeep[i];
                }
                for (int k = 0; k < lps.length; ++k) {
                    PlanNode previous;
                    if (!lps[k].isMetBy(candidate.getLocalProperties()) || (previous = localMatches[k]) != null && previous.getCumulativeCosts().compareTo(candidate.getCumulativeCosts()) <= 0) continue;
                    localMatches[k] = candidate;
                }
            }
        }
        plans.clear();
        if (cheapest != null) {
            plans.add(cheapest);
            cheapest.setPruningMarker();
        }
        for (int i = 0; i < gps.length; ++i) {
            PlanNode n;
            if (toKeep[i] != null) {
                PlanNode[] localMatches;
                for (PlanNode n2 : localMatches = toKeep[i]) {
                    if (n2 == null || n2.isPruneMarkerSet()) continue;
                    n2.setPruningMarker();
                    plans.add(n2);
                }
            }
            if (cheapestForGlobal[i] == null || (n = cheapestForGlobal[i]).isPruneMarkerSet()) continue;
            n.setPruningMarker();
            plans.add(n);
        }
    }

    public boolean hasUnclosedBranches() {
        return this.openBranches != null && !this.openBranches.isEmpty();
    }

    public Set<OptimizerNode> getClosedBranchingNodes() {
        return this.closedBranchingNodes;
    }

    public List<UnclosedBranchDescriptor> getOpenBranches() {
        return this.openBranches;
    }

    protected List<UnclosedBranchDescriptor> getBranchesForParent(DagConnection toParent) {
        if (this.outgoingConnections.size() == 1) {
            if (this.openBranches == null || this.openBranches.isEmpty()) {
                return Collections.emptyList();
            }
            return new ArrayList<UnclosedBranchDescriptor>(this.openBranches);
        }
        if (this.outgoingConnections.size() > 1) {
            int num;
            ArrayList<UnclosedBranchDescriptor> branches = new ArrayList<UnclosedBranchDescriptor>(4);
            if (this.openBranches != null) {
                branches.addAll(this.openBranches);
            }
            for (num = 0; num < this.outgoingConnections.size() && this.outgoingConnections.get(num) != toParent; ++num) {
            }
            if (num >= this.outgoingConnections.size()) {
                throw new CompilerException("Error in compiler: Parent to get branch info for is not contained in the outgoing connections.");
            }
            long bitvector = 1L << num;
            branches.add(new UnclosedBranchDescriptor(this, bitvector));
            return branches;
        }
        throw new CompilerException("Error in compiler: Cannot get branch info for successor in a node with no successors.");
    }

    protected void removeClosedBranches(List<UnclosedBranchDescriptor> openList) {
        if (openList == null || openList.isEmpty() || this.closedBranchingNodes == null || this.closedBranchingNodes.isEmpty()) {
            return;
        }
        Iterator<UnclosedBranchDescriptor> it = openList.iterator();
        while (it.hasNext()) {
            if (!this.closedBranchingNodes.contains(it.next().getBranchingNode())) continue;
            it.remove();
        }
    }

    protected void addClosedBranches(Set<OptimizerNode> alreadyClosed) {
        if (alreadyClosed == null || alreadyClosed.isEmpty()) {
            return;
        }
        if (this.closedBranchingNodes == null) {
            this.closedBranchingNodes = new HashSet<OptimizerNode>(alreadyClosed);
        } else {
            this.closedBranchingNodes.addAll(alreadyClosed);
        }
    }

    protected void addClosedBranch(OptimizerNode alreadyClosed) {
        if (this.closedBranchingNodes == null) {
            this.closedBranchingNodes = new HashSet<OptimizerNode>();
        }
        this.closedBranchingNodes.add(alreadyClosed);
    }

    protected boolean areBranchCompatible(PlanNode plan1, PlanNode plan2) {
        if (plan1 == null || plan2 == null) {
            throw new NullPointerException();
        }
        if (this.hereJoinedBranches == null || this.hereJoinedBranches.isEmpty()) {
            return true;
        }
        for (OptimizerNode joinedBrancher : this.hereJoinedBranches) {
            PlanNode branch1Cand = plan1.getCandidateAtBranchPoint(joinedBrancher);
            PlanNode branch2Cand = plan2.getCandidateAtBranchPoint(joinedBrancher);
            if (branch1Cand == null || branch2Cand == null || branch1Cand == branch2Cand) continue;
            return false;
        }
        return true;
    }

    protected final boolean mergeLists(List<UnclosedBranchDescriptor> child1open, List<UnclosedBranchDescriptor> child2open, List<UnclosedBranchDescriptor> result, boolean markJoinedBranchesAsPipelineBreaking) {
        this.removeClosedBranches(child1open);
        this.removeClosedBranches(child2open);
        result.clear();
        if (child1open == null || child1open.isEmpty()) {
            if (child2open != null && !child2open.isEmpty()) {
                result.addAll(child2open);
            }
            return false;
        }
        if (child2open == null || child2open.isEmpty()) {
            result.addAll(child1open);
            return false;
        }
        int index1 = child1open.size() - 1;
        int index2 = child2open.size() - 1;
        boolean didCloseABranch = false;
        while (index1 >= 0 || index2 >= 0) {
            long vector2;
            int id2;
            int id1 = -1;
            int n = id2 = index2 >= 0 ? child2open.get(index2).getBranchingNode().getId() : -1;
            while (index1 >= 0 && (id1 = child1open.get(index1).getBranchingNode().getId()) > id2) {
                result.add(child1open.get(index1));
                --index1;
            }
            while (index2 >= 0 && (id2 = child2open.get(index2).getBranchingNode().getId()) > id1) {
                result.add(child2open.get(index2));
                --index2;
            }
            if (id1 != id2) continue;
            didCloseABranch = true;
            OptimizerNode currBanchingNode = child1open.get(index1).getBranchingNode();
            long vector1 = child1open.get(index1).getJoinedPathsVector();
            if (vector1 == (vector2 = child2open.get(index2).getJoinedPathsVector())) {
                result.add(child1open.get(index1));
            } else {
                if (markJoinedBranchesAsPipelineBreaking) {
                    currBanchingNode.markAllOutgoingConnectionsAsPipelineBreaking();
                }
                if (this.hereJoinedBranches == null) {
                    this.hereJoinedBranches = new ArrayList<OptimizerNode>(2);
                }
                this.hereJoinedBranches.add(currBanchingNode);
                long joinedInputs = vector1 | vector2;
                long allInputs = (1L << currBanchingNode.getOutgoingConnections().size()) - 1L;
                if (joinedInputs == allInputs) {
                    this.addClosedBranch(currBanchingNode);
                } else {
                    result.add(new UnclosedBranchDescriptor(currBanchingNode, joinedInputs));
                }
            }
            --index1;
            --index2;
        }
        Collections.reverse(result);
        return didCloseABranch;
    }

    @Override
    public OptimizerNode getOptimizerNode() {
        return this;
    }

    @Override
    public PlanNode getPlanNode() {
        return null;
    }

    @Override
    public Iterable<DumpableConnection<OptimizerNode>> getDumpableInputs() {
        ArrayList<DumpableConnection<OptimizerNode>> allInputs = new ArrayList<DumpableConnection<OptimizerNode>>();
        allInputs.addAll(this.getIncomingConnections());
        allInputs.addAll(this.getBroadcastConnections());
        return allInputs;
    }

    public String toString() {
        StringBuilder bld = new StringBuilder();
        bld.append(this.getOperatorName());
        bld.append(" (").append(this.getOperator().getName()).append(") ");
        int i = 1;
        for (DagConnection conn : this.getIncomingConnections()) {
            String shipStrategyName = conn.getShipStrategy() == null ? "null" : conn.getShipStrategy().name();
            bld.append('(').append(i++).append(":").append(shipStrategyName).append(')');
        }
        return bld.toString();
    }

    public static final class UnclosedBranchDescriptor {
        protected OptimizerNode branchingNode;
        protected long joinedPathsVector;

        protected UnclosedBranchDescriptor(OptimizerNode branchingNode, long joinedPathsVector) {
            this.branchingNode = branchingNode;
            this.joinedPathsVector = joinedPathsVector;
        }

        public OptimizerNode getBranchingNode() {
            return this.branchingNode;
        }

        public long getJoinedPathsVector() {
            return this.joinedPathsVector;
        }

        public String toString() {
            return "(" + this.branchingNode.getOperator() + ") [" + this.joinedPathsVector + "]";
        }
    }
}

