/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.util;

import java.io.Serializable;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.annotation.Nonnull;
import org.apache.flink.util.Preconditions;

public class EvictingBoundedList<T>
implements Iterable<T>,
Serializable {
    private static final long serialVersionUID = -1863961980953613146L;
    private final T defaultElement;
    private final Object[] elements;
    private int idx;
    private int count;
    private long modCount;

    public EvictingBoundedList(int sizeLimit) {
        this(sizeLimit, null);
    }

    public EvictingBoundedList(EvictingBoundedList<T> other) {
        Preconditions.checkNotNull(other);
        this.defaultElement = other.defaultElement;
        this.elements = (Object[])other.elements.clone();
        this.idx = other.idx;
        this.count = other.count;
        this.modCount = 0L;
    }

    public EvictingBoundedList(int sizeLimit, T defaultElement) {
        this.elements = new Object[sizeLimit];
        this.defaultElement = defaultElement;
        this.idx = 0;
        this.count = 0;
        this.modCount = 0L;
    }

    public int size() {
        return this.count;
    }

    public boolean isEmpty() {
        return 0 == this.count;
    }

    public boolean add(T t) {
        this.elements[this.idx] = t;
        this.idx = (this.idx + 1) % this.elements.length;
        ++this.count;
        ++this.modCount;
        return true;
    }

    public void clear() {
        if (!this.isEmpty()) {
            for (int i = 0; i < this.elements.length; ++i) {
                this.elements[i] = null;
            }
            this.count = 0;
            this.idx = 0;
            ++this.modCount;
        }
    }

    public T get(int index) {
        if (index >= 0 && index < this.count) {
            return this.isDroppedIndex(index) ? this.getDefaultElement() : this.accessInternal(index % this.elements.length);
        }
        throw new IndexOutOfBoundsException(String.valueOf(index));
    }

    public int getSizeLimit() {
        return this.elements.length;
    }

    public T set(int index, T element) {
        Preconditions.checkArgument((index >= 0 && index < this.count ? 1 : 0) != 0);
        ++this.modCount;
        if (this.isDroppedIndex(index)) {
            return this.getDefaultElement();
        }
        int idx = index % this.elements.length;
        T old = this.accessInternal(idx);
        this.elements[idx] = element;
        return old;
    }

    public T getDefaultElement() {
        return this.defaultElement;
    }

    private boolean isDroppedIndex(int idx) {
        return idx < this.count - this.elements.length;
    }

    private T accessInternal(int arrayIndex) {
        return (T)this.elements[arrayIndex];
    }

    @Override
    @Nonnull
    public Iterator<T> iterator() {
        return new Iterator<T>(){
            int pos = 0;
            final long oldModCount = EvictingBoundedList.access$000(EvictingBoundedList.this);

            @Override
            public boolean hasNext() {
                return this.pos < EvictingBoundedList.this.count;
            }

            @Override
            public T next() {
                if (this.oldModCount != EvictingBoundedList.this.modCount) {
                    throw new ConcurrentModificationException();
                }
                if (this.pos < EvictingBoundedList.this.count) {
                    return EvictingBoundedList.this.get(this.pos++);
                }
                throw new NoSuchElementException("Iterator exhausted.");
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Read-only iterator");
            }
        };
    }
}

