/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampark.console.core.enums;

import java.io.Serializable;
import org.apache.streampark.flink.kubernetes.enums.FlinkJobState;
import scala.Enumeration;

public enum FlinkAppState implements Serializable
{
    ADDED(0),
    INITIALIZING(1),
    CREATED(2),
    STARTING(3),
    RESTARTING(4),
    RUNNING(5),
    FAILING(6),
    FAILED(7),
    CANCELLING(8),
    CANCELED(9),
    FINISHED(10),
    SUSPENDED(11),
    RECONCILING(12),
    LOST(13),
    MAPPING(14),
    OTHER(15),
    REVOKED(16),
    SILENT(17),
    TERMINATED(18),
    POS_TERMINATED(19),
    SUCCEEDED(20),
    KILLED(-9);

    private final int value;

    private FlinkAppState(int value) {
        this.value = value;
    }

    public static FlinkAppState of(Integer state) {
        for (FlinkAppState appState : FlinkAppState.values()) {
            if (appState.value != state) continue;
            return appState;
        }
        return OTHER;
    }

    public static FlinkAppState of(String name) {
        for (FlinkAppState appState : FlinkAppState.values()) {
            if (!appState.name().equals(name)) continue;
            return appState;
        }
        return OTHER;
    }

    public static boolean isEndState(Integer appState) {
        if (appState == null) {
            return false;
        }
        FlinkAppState flinkAppState = FlinkAppState.of(appState);
        return CANCELED == flinkAppState || FAILED == flinkAppState || KILLED == flinkAppState || ADDED == flinkAppState || FINISHED == flinkAppState || SUCCEEDED == flinkAppState || LOST == flinkAppState || TERMINATED == flinkAppState;
    }

    public int getValue() {
        return this.value;
    }

    public static class Bridge {
        public static FlinkAppState fromK8sFlinkJobState(Enumeration.Value flinkJobState) {
            return FlinkAppState.of(flinkJobState.toString());
        }

        public static Enumeration.Value toK8sFlinkJobState(FlinkAppState flinkAppState) {
            return FlinkJobState.of((String)flinkAppState.name());
        }
    }
}

