/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.guice.plexus.scanners;

import org.sonatype.guice.asm.ClassWriter;
import org.sonatype.guice.asm.MethodVisitor;
import org.sonatype.guice.bean.reflect.ClassSpace;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class CloningClassLoader
extends ClassLoader {
    private static final String CLONE_MARKER = "$__plexus";
    private final ClassSpace space;

    CloningClassLoader(ClassSpace space) {
        this.space = space;
    }

    @Override
    protected synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        if (!name.contains(CLONE_MARKER)) {
            return this.space.loadClass(name);
        }
        return super.loadClass(name, resolve);
    }

    static String proxyName(String realName, int cloneId) {
        StringBuilder buf = new StringBuilder();
        if (realName.startsWith("java")) {
            buf.append('$');
        }
        return buf.append(realName).append(CLONE_MARKER).append(cloneId).toString();
    }

    static String getRealName(String proxyName) {
        int cloneMarker = proxyName.indexOf(CLONE_MARKER);
        return cloneMarker < 0 ? proxyName : proxyName.substring('$' == proxyName.charAt(0) ? 1 : 0, cloneMarker);
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        String proxyName = name.replace('.', '/');
        String superName = CloningClassLoader.getRealName(proxyName);
        ClassWriter cw = new ClassWriter(1);
        cw.visit(49, 17, proxyName, null, superName, null);
        MethodVisitor mv = cw.visitMethod(1, "<init>", "()V", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, superName, "<init>", "()V");
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
        cw.visitEnd();
        byte[] buf = cw.toByteArray();
        return this.defineClass(name, buf, 0, buf.length);
    }

    public String toString() {
        return this.space.toString();
    }
}

