/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampark.console.core.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.model.AuthConfig;
import com.github.dockerjava.api.model.AuthResponse;
import com.github.dockerjava.core.DefaultDockerClientConfig;
import com.github.dockerjava.core.DockerClientConfig;
import com.github.dockerjava.core.DockerClientImpl;
import com.github.dockerjava.httpclient5.ApacheDockerHttpClient;
import com.github.dockerjava.transport.DockerHttpClient;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Transport;
import org.apache.commons.lang3.StringUtils;
import org.apache.streampark.console.core.bean.DockerConfig;
import org.apache.streampark.console.core.bean.MavenConfig;
import org.apache.streampark.console.core.bean.ResponseResult;
import org.apache.streampark.console.core.bean.SenderEmail;
import org.apache.streampark.console.core.entity.Setting;
import org.apache.streampark.console.core.mapper.SettingMapper;
import org.apache.streampark.console.core.service.SettingService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(propagation=Propagation.SUPPORTS, readOnly=true, rollbackFor={Exception.class})
public class SettingServiceImpl
extends ServiceImpl<SettingMapper, Setting>
implements SettingService,
ApplicationListener<ContextRefreshedEvent> {
    private static final Logger log = LoggerFactory.getLogger(SettingServiceImpl.class);
    private final Setting emptySetting = new Setting();

    @Override
    public Setting get(String key) {
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(Setting::getSettingKey, (Object)key);
        return (Setting)this.getOne((Wrapper)queryWrapper);
    }

    public void onApplicationEvent(ContextRefreshedEvent event) {
        List settingList = super.list();
        settingList.forEach(x -> SETTINGS.put(x.getSettingKey(), x));
    }

    @Override
    public boolean update(Setting setting) {
        try {
            String value = StringUtils.trimToNull((String)setting.getSettingValue());
            setting.setSettingValue(value);
            Setting entity = new Setting();
            entity.setSettingValue(setting.getSettingValue());
            LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(Setting::getSettingKey, (Object)setting.getSettingKey());
            this.update(entity, (Wrapper)queryWrapper);
            MavenConfig.fromSetting(setting).updateConfig();
            Optional optional = Optional.ofNullable(SETTINGS.get(setting.getSettingKey()));
            optional.ifPresent(x -> x.setSettingValue(value));
            return true;
        }
        catch (Exception e) {
            log.error("Update setting failed!", (Throwable)e);
            return false;
        }
    }

    @Override
    public boolean updateDocker(DockerConfig dockerConfig) {
        List<Setting> settings = DockerConfig.toSettings(dockerConfig);
        for (Setting each : settings) {
            if (this.update(each)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean updateEmail(SenderEmail senderEmail) {
        List<Setting> settings = SenderEmail.toSettings(senderEmail);
        for (Setting each : settings) {
            if (this.update(each)) continue;
            return false;
        }
        return true;
    }

    @Override
    public SenderEmail getSenderEmail() {
        try {
            String host = ((Setting)SETTINGS.get("alert.email.host")).getSettingValue();
            String port = ((Setting)SETTINGS.get("alert.email.port")).getSettingValue();
            String from = ((Setting)SETTINGS.get("alert.email.from")).getSettingValue();
            String userName = ((Setting)SETTINGS.get("alert.email.userName")).getSettingValue();
            String password = ((Setting)SETTINGS.get("alert.email.password")).getSettingValue();
            String ssl = ((Setting)SETTINGS.get("alert.email.ssl")).getSettingValue();
            SenderEmail senderEmail = new SenderEmail();
            senderEmail.setHost(host);
            if (StringUtils.isNotBlank((CharSequence)port)) {
                senderEmail.setPort(Integer.parseInt(port));
            }
            senderEmail.setFrom(from);
            senderEmail.setUserName(userName);
            senderEmail.setPassword(password);
            if (StringUtils.isNotBlank((CharSequence)ssl)) {
                senderEmail.setSsl(Boolean.parseBoolean(ssl));
            }
            return senderEmail;
        }
        catch (Exception e) {
            log.warn("Fault Alert Email is not set.", (Throwable)e);
            return null;
        }
    }

    @Override
    public String getIngressModeDefault() {
        return SETTINGS.getOrDefault("ingress.mode.default", this.emptySetting).getSettingValue();
    }

    @Override
    public DockerConfig getDockerConfig() {
        List<Setting> settingList = ((SettingMapper)this.baseMapper).querySettingByKeys(Arrays.asList("docker.register.address", "docker.register.user", "docker.register.password", "docker.register.namespace"));
        DockerConfig dockerConfig = new DockerConfig();
        settingList.forEach(setting -> {
            switch (setting.getSettingKey()) {
                case "docker.register.address": {
                    dockerConfig.setAddress(setting.getSettingValue());
                    break;
                }
                case "docker.register.user": {
                    dockerConfig.setUserName(setting.getSettingValue());
                    break;
                }
                case "docker.register.password": {
                    dockerConfig.setPassword(setting.getSettingValue());
                    break;
                }
                case "docker.register.namespace": {
                    dockerConfig.setNamespace(setting.getSettingValue());
                    break;
                }
            }
        });
        return dockerConfig;
    }

    @Override
    public ResponseResult checkDocker(DockerConfig dockerConfig) {
        DefaultDockerClientConfig config = DefaultDockerClientConfig.createDefaultConfigBuilder().withRegistryUrl(dockerConfig.getAddress()).build();
        ApacheDockerHttpClient httpClient = new ApacheDockerHttpClient.Builder().dockerHost(config.getDockerHost()).build();
        ResponseResult result = new ResponseResult();
        try (DockerClient dockerClient = DockerClientImpl.getInstance((DockerClientConfig)config, (DockerHttpClient)httpClient);){
            AuthConfig authConfig = new AuthConfig().withUsername(dockerConfig.getUserName()).withPassword(dockerConfig.getPassword()).withRegistryAddress(dockerConfig.getAddress());
            AuthResponse response = dockerClient.authCmd().withAuthConfig(authConfig).exec();
            if (response.getStatus().equals("Login Succeeded")) {
                result.setStatus(200);
            } else {
                result.setStatus(500);
                result.setMsg("docker login failed, status: " + response.getStatus());
            }
        }
        catch (Exception e) {
            if (e.getMessage().contains("LastErrorException")) {
                result.setStatus(400);
            }
            if (e.getMessage().contains("Status 401")) {
                result.setStatus(500);
                result.setMsg("Failed to validate Docker registry, unauthorized: incorrect username or password ");
            }
            result.setStatus(500);
            result.setMsg("Failed to validate Docker registry, error: " + e.getMessage());
        }
        return result;
    }

    @Override
    public ResponseResult checkEmail(SenderEmail senderEmail) {
        ResponseResult result = new ResponseResult();
        Properties props = new Properties();
        props.put("mail.smtp.auth", "true");
        if (senderEmail.isSsl()) {
            props.put("mail.smtp.starttls.enable", "true");
        }
        props.put("mail.smtp.host", senderEmail.getHost());
        props.put("mail.smtp.port", senderEmail.getPort());
        Session session = Session.getInstance((Properties)props);
        try {
            Transport transport = session.getTransport("smtp");
            transport.connect(senderEmail.getHost(), senderEmail.getUserName(), senderEmail.getPassword());
            transport.close();
            result.setStatus(200);
        }
        catch (MessagingException e) {
            result.setStatus(500);
            result.setMsg("connect to target mail server failed: " + e.getMessage());
        }
        return result;
    }
}

