/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.highavailability;

import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.flink.api.common.JobStatus;
import org.apache.flink.kubernetes.kubeclient.FlinkKubeClient;
import org.apache.flink.kubernetes.kubeclient.resources.KubernetesConfigMap;
import org.apache.flink.kubernetes.kubeclient.resources.KubernetesException;
import org.apache.flink.kubernetes.kubeclient.resources.KubernetesLeaderElector;
import org.apache.flink.runtime.checkpoint.CheckpointIDCounter;
import org.apache.flink.util.FlinkRuntimeException;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KubernetesCheckpointIDCounter
implements CheckpointIDCounter {
    private static final Logger LOG = LoggerFactory.getLogger(KubernetesCheckpointIDCounter.class);
    private final FlinkKubeClient kubeClient;
    private final String configMapName;
    private final String lockIdentity;
    private boolean running;

    public KubernetesCheckpointIDCounter(FlinkKubeClient kubeClient, String configMapName, String lockIdentity) {
        this.kubeClient = (FlinkKubeClient)Preconditions.checkNotNull((Object)kubeClient);
        this.configMapName = (String)Preconditions.checkNotNull((Object)configMapName);
        this.lockIdentity = (String)Preconditions.checkNotNull((Object)lockIdentity);
        this.running = false;
    }

    public void start() {
        if (!this.running) {
            this.running = true;
        }
    }

    public void shutdown(JobStatus jobStatus) {
        if (!this.running) {
            return;
        }
        this.running = false;
        LOG.info("Shutting down.");
        if (jobStatus.isGloballyTerminalState()) {
            LOG.info("Removing counter from ConfigMap {}", (Object)this.configMapName);
            this.kubeClient.checkAndUpdateConfigMap(this.configMapName, configMap -> {
                if (KubernetesLeaderElector.hasLeadership(configMap, this.lockIdentity)) {
                    configMap.getData().remove("counter");
                    return Optional.of(configMap);
                }
                return Optional.empty();
            });
        }
    }

    public long getAndIncrement() throws Exception {
        AtomicLong current = new AtomicLong();
        boolean updated = this.kubeClient.checkAndUpdateConfigMap(this.configMapName, configMap -> {
            if (KubernetesLeaderElector.hasLeadership(configMap, this.lockIdentity)) {
                long currentValue = this.getCurrentCounter((KubernetesConfigMap)configMap);
                current.set(currentValue);
                configMap.getData().put("counter", String.valueOf(currentValue + 1L));
                return Optional.of(configMap);
            }
            return Optional.empty();
        }).get();
        if (updated) {
            return current.get();
        }
        throw new KubernetesException("Failed to update ConfigMap " + this.configMapName + " since current KubernetesCheckpointIDCounter does not have the leadership.");
    }

    public long get() {
        return this.kubeClient.getConfigMap(this.configMapName).map(this::getCurrentCounter).orElseThrow(() -> new FlinkRuntimeException((Throwable)((Object)new KubernetesException("ConfigMap " + this.configMapName + " does not exist."))));
    }

    public void setCount(long newCount) throws Exception {
        this.kubeClient.checkAndUpdateConfigMap(this.configMapName, configMap -> {
            if (KubernetesLeaderElector.hasLeadership(configMap, this.lockIdentity)) {
                String existing = configMap.getData().get("counter");
                String newValue = String.valueOf(newCount);
                if (existing == null || !existing.equals(newValue)) {
                    configMap.getData().put("counter", String.valueOf(newCount));
                    return Optional.of(configMap);
                }
            }
            return Optional.empty();
        }).get();
    }

    private long getCurrentCounter(KubernetesConfigMap configMap) {
        if (configMap.getData().containsKey("counter")) {
            return Long.valueOf(configMap.getData().get("counter"));
        }
        return 1L;
    }
}

