/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.metrics;

import org.apache.flink.metrics.Counter;
import org.apache.flink.metrics.Meter;
import org.apache.flink.metrics.MeterView;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.util.Preconditions;

public class InputChannelMetrics {
    private static final String IO_NUM_BYTES_IN_LOCAL = "numBytesInLocal";
    private static final String IO_NUM_BYTES_IN_REMOTE = "numBytesInRemote";
    private static final String IO_NUM_BUFFERS_IN_LOCAL = "numBuffersInLocal";
    private static final String IO_NUM_BUFFERS_IN_REMOTE = "numBuffersInRemote";
    private final Counter numBytesInLocal;
    private final Counter numBytesInRemote;
    private final Counter numBuffersInLocal;
    private final Counter numBuffersInRemote;

    public InputChannelMetrics(MetricGroup ... parents) {
        this.numBytesInLocal = InputChannelMetrics.createCounter(IO_NUM_BYTES_IN_LOCAL, parents);
        this.numBytesInRemote = InputChannelMetrics.createCounter(IO_NUM_BYTES_IN_REMOTE, parents);
        this.numBuffersInLocal = InputChannelMetrics.createCounter(IO_NUM_BUFFERS_IN_LOCAL, parents);
        this.numBuffersInRemote = InputChannelMetrics.createCounter(IO_NUM_BUFFERS_IN_REMOTE, parents);
    }

    private static Counter createCounter(String name, MetricGroup ... parents) {
        Counter[] counters = new Counter[parents.length];
        for (int i = 0; i < parents.length; ++i) {
            counters[i] = parents[i].counter(name);
            parents[i].meter(name + "PerSecond", (Meter)new MeterView(counters[i]));
        }
        return new MultiCounterWrapper(counters);
    }

    public Counter getNumBytesInLocalCounter() {
        return this.numBytesInLocal;
    }

    public Counter getNumBytesInRemoteCounter() {
        return this.numBytesInRemote;
    }

    public Counter getNumBuffersInLocalCounter() {
        return this.numBuffersInLocal;
    }

    public Counter getNumBuffersInRemoteCounter() {
        return this.numBuffersInRemote;
    }

    private static class MultiCounterWrapper
    implements Counter {
        private final Counter[] counters;

        private MultiCounterWrapper(Counter ... counters) {
            Preconditions.checkArgument((counters.length > 0 ? 1 : 0) != 0);
            this.counters = counters;
        }

        public void inc() {
            for (Counter c : this.counters) {
                c.inc();
            }
        }

        public void inc(long n) {
            for (Counter c : this.counters) {
                c.inc(n);
            }
        }

        public void dec() {
            for (Counter c : this.counters) {
                c.dec();
            }
        }

        public void dec(long n) {
            for (Counter c : this.counters) {
                c.dec(n);
            }
        }

        public long getCount() {
            return this.counters[0].getCount();
        }
    }
}

