/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.summarize.aggregation;

import org.apache.flink.annotation.Internal;
import org.apache.flink.api.java.summarize.ObjectColumnSummary;
import org.apache.flink.api.java.summarize.aggregation.Aggregator;

@Internal
public class ObjectSummaryAggregator
implements Aggregator<Object, ObjectColumnSummary> {
    private long nonNullCount;
    private long nullCount;

    @Override
    public void aggregate(Object value) {
        if (value == null) {
            ++this.nullCount;
        } else {
            ++this.nonNullCount;
        }
    }

    @Override
    public void combine(Aggregator<Object, ObjectColumnSummary> otherSameType) {
        ObjectSummaryAggregator other = (ObjectSummaryAggregator)otherSameType;
        this.nonNullCount += other.nonNullCount;
        this.nullCount += other.nullCount;
    }

    @Override
    public ObjectColumnSummary result() {
        return new ObjectColumnSummary(this.nonNullCount, this.nullCount);
    }
}

