/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.operators.sink;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.apache.flink.api.connector.sink.GlobalCommitter;
import org.apache.flink.streaming.runtime.operators.sink.AbstractCommitterHandler;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class GlobalBatchCommitterHandler<CommT, GlobalCommT>
extends AbstractCommitterHandler<CommT, GlobalCommT, GlobalCommT> {
    private static final Logger LOG = LoggerFactory.getLogger(GlobalBatchCommitterHandler.class);
    private final GlobalCommitter<CommT, GlobalCommT> globalCommitter;

    public GlobalBatchCommitterHandler(GlobalCommitter<CommT, GlobalCommT> globalCommitter) {
        this.globalCommitter = (GlobalCommitter)Preconditions.checkNotNull(globalCommitter);
    }

    @Override
    public List<GlobalCommT> endOfInput() throws IOException, InterruptedException {
        List allCommittables = this.pollCommittables();
        if (!allCommittables.isEmpty()) {
            Object globalCommittable = this.globalCommitter.combine(allCommittables);
            this.recoveredCommittables(this.globalCommitter.commit(Collections.singletonList(globalCommittable)));
        }
        this.globalCommitter.endOfInput();
        return Collections.emptyList();
    }

    @Override
    protected void retry(List<GlobalCommT> recoveredCommittables) throws IOException, InterruptedException {
        this.recoveredCommittables(this.globalCommitter.commit(recoveredCommittables));
    }

    @Override
    public void close() throws Exception {
        this.globalCommitter.close();
        super.close();
    }
}

