/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.classloader;

import java.net.URL;
import java.security.PrivilegedAction;
import org.apache.axis2.classloader.MultiParentClassLoader;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.java.security.AccessController;

public class ThreadContextDescriptor {
    private ClassLoader oldClassLoader;
    private MessageContext oldMessageContext;

    public ClassLoader getOldClassLoader() {
        return this.oldClassLoader;
    }

    public void setOldClassLoader(ClassLoader oldClassLoader) {
        this.oldClassLoader = oldClassLoader;
    }

    public MessageContext getOldMessageContext() {
        return this.oldMessageContext;
    }

    public void setOldMessageContext(MessageContext oldMessageContext) {
        this.oldMessageContext = oldMessageContext;
    }

    public static ThreadContextDescriptor setThreadContext(final AxisService service) {
        ClassLoader contextClassLoader;
        ThreadContextDescriptor tc = new ThreadContextDescriptor();
        tc.oldMessageContext = MessageContext.currentMessageContext.get();
        tc.oldClassLoader = contextClassLoader = ThreadContextDescriptor.getContextClassLoader_doPriv();
        String serviceTCCL = (String)service.getParameterValue("ServiceTCCL");
        if (serviceTCCL != null) {
            if ((serviceTCCL = serviceTCCL.trim().toLowerCase()).equals("composite")) {
                final ClassLoader loader = (ClassLoader)java.security.AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        return new MultiParentClassLoader(new URL[0], new ClassLoader[]{service.getClassLoader(), contextClassLoader});
                    }
                });
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        Thread.currentThread().setContextClassLoader(loader);
                        return null;
                    }
                });
            } else if (serviceTCCL.equals("service")) {
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        Thread.currentThread().setContextClassLoader(service.getClassLoader());
                        return null;
                    }
                });
            }
        }
        return tc;
    }

    public static ThreadContextDescriptor setThreadContext(MessageContext msgContext) {
        AxisService service = msgContext.getAxisService();
        ThreadContextDescriptor tc = ThreadContextDescriptor.setThreadContext(service);
        MessageContext.setCurrentMessageContext(msgContext);
        return tc;
    }

    private static ClassLoader getContextClassLoader_doPriv() {
        return (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
    }
}

