/*
 * Decompiled with CFR 0.152.
 */
package javax.script;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.imageio.spi.ServiceRegistry;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.SimpleBindings;

public class ScriptEngineManager {
    private final HashSet engineSpis = new HashSet();
    private final HashMap nameAssociations = new HashMap();
    private final HashMap extensionAssociations = new HashMap();
    private final HashMap mimeTypeAssociations = new HashMap();
    private Bindings globalscope = new SimpleBindings();

    public ScriptEngineManager() {
        this(Thread.currentThread().getContextClassLoader());
    }

    public ScriptEngineManager(ClassLoader loader) {
        Iterator iterator = ServiceRegistry.lookupProviders(ScriptEngineFactory.class, loader);
        while (iterator.hasNext()) {
            int i;
            ScriptEngineFactory factory;
            try {
                factory = (ScriptEngineFactory)iterator.next();
            }
            catch (Error ignored) {
                continue;
            }
            this.engineSpis.add(factory);
            List data = factory.getNames();
            for (i = 0; i < data.size(); ++i) {
                this.nameAssociations.put(data.get(i), factory);
            }
            data = factory.getExtensions();
            for (i = 0; i < data.size(); ++i) {
                this.extensionAssociations.put(data.get(i), factory);
            }
            data = factory.getMimeTypes();
            for (i = 0; i < data.size(); ++i) {
                this.mimeTypeAssociations.put(data.get(i), factory);
            }
        }
        this.initXMLHelper(loader);
    }

    private void initXMLHelper(ClassLoader loader) {
        try {
            Class<?> xmlHelperClass = Class.forName("org.apache.bsf.xml.XMLHelper", true, loader);
            Method initMethod = xmlHelperClass.getMethod("init", new Class[0]);
            initMethod.invoke(null, new Object[0]);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public Object get(String key) {
        return this.globalscope.get(key);
    }

    public ScriptEngine getEngineByExtension(String extension) {
        if (extension == null) {
            throw new NullPointerException("extension must not be null");
        }
        ScriptEngine engine = null;
        ScriptEngineFactory factory = (ScriptEngineFactory)this.extensionAssociations.get(extension);
        if (factory != null) {
            engine = factory.getScriptEngine();
            engine.setBindings(this.globalscope, 200);
        }
        return engine;
    }

    public ScriptEngine getEngineByMimeType(String mimeType) {
        if (mimeType == null) {
            throw new NullPointerException("mimeType must not be null");
        }
        ScriptEngine engine = null;
        ScriptEngineFactory factory = (ScriptEngineFactory)this.mimeTypeAssociations.get(mimeType);
        if (factory != null) {
            engine = factory.getScriptEngine();
            engine.setBindings(this.globalscope, 200);
        }
        return engine;
    }

    public ScriptEngine getEngineByName(String shortName) {
        if (shortName == null) {
            throw new NullPointerException("shortName must not be null");
        }
        ScriptEngine engine = null;
        ScriptEngineFactory factory = (ScriptEngineFactory)this.nameAssociations.get(shortName);
        if (factory != null) {
            engine = factory.getScriptEngine();
            engine.setBindings(this.globalscope, 200);
        }
        return engine;
    }

    public List getEngineFactories() {
        ArrayList factories = new ArrayList();
        Iterator iter = this.engineSpis.iterator();
        while (iter.hasNext()) {
            factories.add(iter.next());
        }
        return factories;
    }

    public Bindings getBindings() {
        return this.globalscope;
    }

    public void put(String key, Object value) {
        if (key == null) {
            throw new NullPointerException("key must not be null");
        }
        if (key.length() == 0) {
            throw new IllegalArgumentException("key must not be the empty string");
        }
        this.globalscope.put(key, value);
    }

    public void registerEngineExtension(String extension, ScriptEngineFactory factory) {
        if (extension == null || factory == null) {
            throw new NullPointerException("parameters must be non-null");
        }
        this.extensionAssociations.put(extension, factory);
    }

    public void registerEngineName(String name, ScriptEngineFactory factory) {
        if (name == null || factory == null) {
            throw new NullPointerException("parameters must be non-null");
        }
        this.nameAssociations.put(name, factory);
    }

    public void registerEngineMimeType(String mimeType, ScriptEngineFactory factory) {
        if (mimeType == null || factory == null) {
            throw new NullPointerException("parameters must be non-null");
        }
        this.mimeTypeAssociations.put(mimeType, factory);
    }

    public void setBindings(Bindings bindings) {
        if (bindings == null) {
            throw new IllegalArgumentException("bindings must not be null");
        }
        this.globalscope = bindings;
    }
}

