/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.matrix.data;

import java.util.Iterator;
import org.apache.sysml.runtime.matrix.data.Converter;
import org.apache.sysml.runtime.matrix.data.IJV;
import org.apache.sysml.runtime.matrix.data.MatrixBlock;
import org.apache.sysml.runtime.matrix.data.MatrixCell;
import org.apache.sysml.runtime.matrix.data.MatrixIndexes;
import org.apache.sysml.runtime.matrix.data.Pair;
import org.apache.sysml.runtime.util.UtilFunctions;

public class BinaryBlockToBinaryCellConverter
implements Converter<MatrixIndexes, MatrixBlock, MatrixIndexes, MatrixCell> {
    private Iterator<IJV> sparseIterator = null;
    private double[] denseArray = null;
    private int denseArraySize = 0;
    private int nextInDenseArray = -1;
    private boolean sparse = true;
    private int thisBlockWidth = 0;
    private MatrixIndexes startIndexes = new MatrixIndexes();
    private boolean hasValue = false;
    private int brow;
    private int bcolumn;
    private MatrixIndexes returnIndexes = new MatrixIndexes();
    private MatrixCell cell = new MatrixCell();
    private Pair<MatrixIndexes, MatrixCell> pair = new Pair<MatrixIndexes, MatrixCell>(this.returnIndexes, this.cell);

    private void reset() {
        this.sparseIterator = null;
        this.denseArray = null;
        this.denseArraySize = 0;
        this.nextInDenseArray = -1;
        this.sparse = true;
        this.thisBlockWidth = 0;
    }

    @Override
    public void convert(MatrixIndexes k1, MatrixBlock v1) {
        this.reset();
        this.startIndexes.setIndexes(UtilFunctions.computeCellIndex(k1.getRowIndex(), this.brow, 0), UtilFunctions.computeCellIndex(k1.getColumnIndex(), this.bcolumn, 0));
        this.sparse = v1.isInSparseFormat();
        this.thisBlockWidth = v1.getNumColumns();
        if (this.sparse) {
            this.sparseIterator = v1.getSparseBlockIterator();
        } else {
            if (v1.getDenseBlock() == null) {
                return;
            }
            this.denseArray = v1.getDenseBlockValues();
            this.nextInDenseArray = 0;
            this.denseArraySize = v1.getNumRows() * v1.getNumColumns();
        }
        this.hasValue = v1.getNonZeros() > 0L;
    }

    @Override
    public boolean hasNext() {
        if (this.sparse) {
            this.hasValue = this.sparseIterator == null ? false : this.sparseIterator.hasNext();
        } else if (this.denseArray == null) {
            this.hasValue = false;
        } else {
            while (this.nextInDenseArray < this.denseArraySize && this.denseArray[this.nextInDenseArray] == 0.0) {
                ++this.nextInDenseArray;
            }
            this.hasValue = this.nextInDenseArray < this.denseArraySize;
        }
        return this.hasValue;
    }

    @Override
    public Pair<MatrixIndexes, MatrixCell> next() {
        double v;
        long j;
        long i;
        if (!this.hasValue) {
            return null;
        }
        if (this.sparse) {
            if (this.sparseIterator == null) {
                return null;
            }
            IJV tmpcell = this.sparseIterator.next();
            i = (long)tmpcell.getI() + this.startIndexes.getRowIndex();
            j = (long)tmpcell.getJ() + this.startIndexes.getColumnIndex();
            v = tmpcell.getV();
        } else {
            if (this.denseArray == null) {
                return null;
            }
            i = this.startIndexes.getRowIndex() + (long)(this.nextInDenseArray / this.thisBlockWidth);
            j = this.startIndexes.getColumnIndex() + (long)(this.nextInDenseArray % this.thisBlockWidth);
            v = this.denseArray[this.nextInDenseArray];
            ++this.nextInDenseArray;
        }
        this.returnIndexes.setIndexes(i, j);
        this.cell.setValue(v);
        return this.pair;
    }

    @Override
    public void setBlockSize(int nr, int nc) {
        this.brow = nr;
        this.bcolumn = nc;
    }
}

