/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.containermanager.launcher;

import java.io.File;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.event.Dispatcher;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.server.nodemanager.ContainerExecutor;
import org.apache.hadoop.yarn.server.nodemanager.Context;
import org.apache.hadoop.yarn.server.nodemanager.LocalDirsHandlerService;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.ContainerManagerImpl;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.application.Application;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.container.Container;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.container.ContainerEvent;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.container.ContainerEventType;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.container.ContainerExitEvent;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.launcher.ContainerLaunch;
import org.apache.hadoop.yarn.util.ConverterUtils;

public class RecoveredContainerLaunch
extends ContainerLaunch {
    private static final Log LOG = LogFactory.getLog(RecoveredContainerLaunch.class);

    public RecoveredContainerLaunch(Context context, Configuration configuration, Dispatcher dispatcher, ContainerExecutor exec, Application app, Container container, LocalDirsHandlerService dirsHandler, ContainerManagerImpl containerManager) {
        super(context, configuration, dispatcher, exec, app, container, dirsHandler, containerManager);
        this.shouldLaunchContainer.set(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Integer call() {
        int retCode = ContainerExecutor.ExitCode.LOST.getExitCode();
        ContainerId containerId = this.container.getContainerId();
        String appIdStr = ConverterUtils.toString((ApplicationId)containerId.getApplicationAttemptId().getApplicationId());
        String containerIdStr = ConverterUtils.toString((ContainerId)containerId);
        this.dispatcher.getEventHandler().handle((Event)new ContainerEvent(containerId, ContainerEventType.CONTAINER_LAUNCHED));
        boolean notInterrupted = true;
        try {
            File pidFile = this.locatePidFile(appIdStr, containerIdStr);
            if (pidFile != null) {
                String pidPathStr = pidFile.getPath();
                this.pidFilePath = new Path(pidPathStr);
                this.exec.activateContainer(containerId, this.pidFilePath);
                retCode = this.exec.reacquireContainer(this.container.getUser(), containerId);
            } else {
                LOG.warn((Object)("Unable to locate pid file for container " + containerIdStr));
            }
        }
        catch (IOException e) {
            LOG.error((Object)("Unable to recover container " + containerIdStr), (Throwable)e);
        }
        catch (InterruptedException e) {
            LOG.warn((Object)("Interrupted while waiting for exit code from " + containerId));
            notInterrupted = false;
        }
        finally {
            if (notInterrupted) {
                this.completed.set(true);
                this.exec.deactivateContainer(containerId);
                try {
                    this.getContext().getNMStateStore().storeContainerCompleted(containerId, retCode);
                }
                catch (IOException e) {
                    LOG.error((Object)("Unable to set exit code for container " + containerId));
                }
            }
        }
        if (retCode != 0) {
            LOG.warn((Object)("Recovered container exited with a non-zero exit code " + retCode));
            this.dispatcher.getEventHandler().handle((Event)new ContainerExitEvent(containerId, ContainerEventType.CONTAINER_EXITED_WITH_FAILURE, retCode, "Container exited with a non-zero exit code " + retCode));
            return retCode;
        }
        LOG.info((Object)("Recovered container " + containerId + " succeeded"));
        this.dispatcher.getEventHandler().handle((Event)new ContainerEvent(containerId, ContainerEventType.CONTAINER_EXITED_WITH_SUCCESS));
        return 0;
    }

    private File locatePidFile(String appIdStr, String containerIdStr) {
        String pidSubpath = this.getPidFileSubpath(appIdStr, containerIdStr);
        for (String dir : this.getContext().getLocalDirsHandler().getLocalDirs()) {
            File pidFile = new File(dir, pidSubpath);
            if (!pidFile.exists()) continue;
            return pidFile;
        }
        return null;
    }
}

