/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.lops;

import java.util.HashMap;
import org.apache.sysml.hops.Hop;
import org.apache.sysml.lops.Data;
import org.apache.sysml.lops.Lop;
import org.apache.sysml.lops.LopProperties;
import org.apache.sysml.lops.LopsException;
import org.apache.sysml.lops.OutputParameters;
import org.apache.sysml.lops.compile.JobType;
import org.apache.sysml.parser.DataExpression;
import org.apache.sysml.parser.DataIdentifier;
import org.apache.sysml.parser.Expression;

public class DataGen
extends Lop {
    public static final String RAND_OPCODE = "rand";
    public static final String SEQ_OPCODE = "seq";
    public static final String SINIT_OPCODE = "sinit";
    public static final String SAMPLE_OPCODE = "sample";
    private int _numThreads = 1;
    private String baseDir;
    private HashMap<String, Lop> _inputParams;
    Hop.DataGenMethod method;

    public DataGen(Hop.DataGenMethod mthd, DataIdentifier id, HashMap<String, Lop> inputParametersLops, String baseDir, Expression.DataType dt, Expression.ValueType vt, LopProperties.ExecType et) {
        super(Lop.Type.DataGen, dt, vt);
        this.method = mthd;
        for (Lop lop : inputParametersLops.values()) {
            this.addInput(lop);
            lop.addOutput(this);
        }
        this._inputParams = inputParametersLops;
        this.init(id, baseDir, et);
    }

    public Hop.DataGenMethod getDataGenMethod() {
        return this.method;
    }

    public void init(DataIdentifier id, String baseDir, LopProperties.ExecType et) {
        this.getOutputParameters().setFormat(OutputParameters.Format.BINARY);
        this.getOutputParameters().setBlocked(true);
        this.getOutputParameters().setNumRows(id.getDim1());
        this.getOutputParameters().setNumCols(id.getDim2());
        this.getOutputParameters().setNnz(-1L);
        this.getOutputParameters().setRowsInBlock(id.getRowsInBlock());
        this.getOutputParameters().setColsInBlock(id.getColumnsInBlock());
        this.baseDir = baseDir;
        boolean breaksAlignment = false;
        boolean aligner = false;
        if (et == LopProperties.ExecType.MR) {
            boolean definesMRJob = true;
            this.lps.addCompatibility(JobType.DATAGEN);
            this.lps.setProperties(this.inputs, et, LopProperties.ExecLocation.Map, breaksAlignment, aligner, definesMRJob);
        } else {
            boolean definesMRJob = false;
            this.lps.addCompatibility(JobType.INVALID);
            this.lps.setProperties(this.inputs, et, LopProperties.ExecLocation.ControlProgram, breaksAlignment, aligner, definesMRJob);
        }
    }

    @Override
    public String getInstructions(String output) {
        switch (this.method) {
            case RAND: {
                return this.getRandInstructionCPSpark(output);
            }
            case SINIT: {
                return this.getSInitInstructionCPSpark(output);
            }
            case SEQ: {
                return this.getSeqInstructionCPSpark(output);
            }
            case SAMPLE: {
                return this.getSampleInstructionCPSpark(output);
            }
        }
        throw new LopsException("Unknown data generation method: " + (Object)((Object)this.method));
    }

    @Override
    public String getInstructions(int inputIndex, int outputIndex) {
        switch (this.method) {
            case RAND: {
                return this.getRandInstructionMR(inputIndex, outputIndex);
            }
            case SEQ: {
                return this.getSeqInstructionMR(inputIndex, outputIndex);
            }
        }
        throw new LopsException("Unknown data generation method: " + (Object)((Object)this.method));
    }

    private String getRandInstructionCPSpark(String output) {
        if (this.method != Hop.DataGenMethod.RAND) {
            throw new LopsException("Invalid instruction generation for data generation method " + (Object)((Object)this.method));
        }
        if (this.getInputs().size() != DataExpression.RAND_VALID_PARAM_NAMES.length) {
            throw new LopsException(this.printErrorLocation() + "Invalid number of operands (" + this.getInputs().size() + ") for a Rand operation");
        }
        StringBuilder sb = new StringBuilder();
        sb.append((Object)this.getExecType());
        sb.append("\u00b0");
        sb.append(RAND_OPCODE);
        sb.append("\u00b0");
        Lop iLop = this._inputParams.get("rows".toString());
        sb.append(iLop.prepScalarInputOperand(this.getExecType()));
        sb.append("\u00b0");
        iLop = this._inputParams.get("cols".toString());
        sb.append(iLop.prepScalarInputOperand(this.getExecType()));
        sb.append("\u00b0");
        sb.append(String.valueOf(this.getOutputParameters().getRowsInBlock()));
        sb.append("\u00b0");
        sb.append(String.valueOf(this.getOutputParameters().getColsInBlock()));
        sb.append("\u00b0");
        iLop = this._inputParams.get("min".toString());
        sb.append(iLop.prepScalarLabel());
        sb.append("\u00b0");
        iLop = this._inputParams.get("max".toString());
        sb.append(iLop.prepScalarLabel());
        sb.append("\u00b0");
        iLop = this._inputParams.get("sparsity".toString());
        if (iLop.isVariable()) {
            sb.append(iLop.prepScalarLabel());
        } else {
            sb.append(iLop.getOutputParameters().getLabel());
        }
        sb.append("\u00b0");
        iLop = this._inputParams.get("seed".toString());
        sb.append(iLop.prepScalarLabel());
        sb.append("\u00b0");
        if (this.getExecType() == LopProperties.ExecType.MR || this.getExecType() == LopProperties.ExecType.SPARK) {
            sb.append(this.baseDir);
            sb.append("\u00b0");
        }
        if ((iLop = this._inputParams.get("pdf".toString())).isVariable()) {
            throw new LopsException(this.printErrorLocation() + "Parameter " + "pdf" + " must be a literal for a Rand operation.");
        }
        sb.append(iLop.getOutputParameters().getLabel());
        sb.append("\u00b0");
        iLop = this._inputParams.get("lambda".toString());
        sb.append(iLop == null ? "" : iLop.prepScalarLabel());
        sb.append("\u00b0");
        if (this.getExecType() == LopProperties.ExecType.CP) {
            sb.append(this._numThreads);
            sb.append("\u00b0");
        }
        sb.append(this.prepOutputOperand(output));
        return sb.toString();
    }

    private String getSInitInstructionCPSpark(String output) {
        if (this.method != Hop.DataGenMethod.SINIT) {
            throw new LopsException("Invalid instruction generation for data generation method " + (Object)((Object)this.method));
        }
        Lop iLop = this._inputParams.get("rows".toString());
        String rowsString = iLop.prepScalarLabel();
        iLop = this._inputParams.get("cols".toString());
        String colsString = iLop.prepScalarLabel();
        String rowsInBlockString = String.valueOf(this.getOutputParameters().getRowsInBlock());
        String colsInBlockString = String.valueOf(this.getOutputParameters().getColsInBlock());
        iLop = this._inputParams.get("min".toString());
        String minString = iLop.getOutputParameters().getLabel();
        if (iLop.isVariable()) {
            throw new LopsException(this.printErrorLocation() + "Parameter " + "min" + " must be a literal for a Rand operation.");
        }
        StringBuilder sb = new StringBuilder();
        LopProperties.ExecType et = this.getExecType();
        sb.append((Object)et);
        sb.append("\u00b0");
        sb.append(SINIT_OPCODE);
        sb.append("\u00b0");
        sb.append(rowsString);
        sb.append("\u00b0");
        sb.append(colsString);
        sb.append("\u00b0");
        sb.append(rowsInBlockString);
        sb.append("\u00b0");
        sb.append(colsInBlockString);
        sb.append("\u00b0");
        sb.append(minString);
        sb.append("\u00b0");
        sb.append(this.prepOutputOperand(output));
        return sb.toString();
    }

    private String getSampleInstructionCPSpark(String output) {
        if (this.method != Hop.DataGenMethod.SAMPLE) {
            throw new LopsException("Invalid instruction generation for data generation method " + (Object)((Object)this.method));
        }
        Lop lsize = this._inputParams.get("rows".toString());
        String size = lsize.prepScalarInputOperand(this.getExecType());
        Lop lrange = this._inputParams.get("max".toString());
        String range = lrange.prepScalarLabel();
        Lop lreplace = this._inputParams.get("pdf".toString());
        String replace = lreplace.prepScalarLabel();
        Lop lseed = this._inputParams.get("seed".toString());
        String seed = lseed.prepScalarLabel();
        String rowsInBlockString = String.valueOf(this.getOutputParameters().getRowsInBlock());
        String colsInBlockString = String.valueOf(this.getOutputParameters().getColsInBlock());
        StringBuilder sb = new StringBuilder();
        sb.append((Object)this.getExecType());
        sb.append("\u00b0");
        sb.append(SAMPLE_OPCODE);
        sb.append("\u00b0");
        sb.append(range);
        sb.append("\u00b0");
        sb.append(size);
        sb.append("\u00b0");
        sb.append(replace);
        sb.append("\u00b0");
        sb.append(seed);
        sb.append("\u00b0");
        sb.append(rowsInBlockString);
        sb.append("\u00b0");
        sb.append(colsInBlockString);
        sb.append("\u00b0");
        sb.append(this.prepOutputOperand(output));
        return sb.toString();
    }

    private String getSeqInstructionCPSpark(String output) {
        if (this.method != Hop.DataGenMethod.SEQ) {
            throw new LopsException("Invalid instruction generation for data generation method " + (Object)((Object)this.method));
        }
        StringBuilder sb = new StringBuilder();
        LopProperties.ExecType et = this.getExecType();
        sb.append((Object)et);
        sb.append("\u00b0");
        Lop iLop = null;
        iLop = this._inputParams.get("from".toString());
        String fromString = iLop.prepScalarInputOperand(et);
        iLop = this._inputParams.get("to".toString());
        String toString = iLop.prepScalarInputOperand(et);
        iLop = this._inputParams.get("incr".toString());
        String incrString = iLop.prepScalarInputOperand(et);
        String rowsString = String.valueOf(this.getOutputParameters().getNumRows());
        String colsString = String.valueOf(this.getOutputParameters().getNumCols());
        String rowsInBlockString = String.valueOf(this.getOutputParameters().getRowsInBlock());
        String colsInBlockString = String.valueOf(this.getOutputParameters().getColsInBlock());
        sb.append(SEQ_OPCODE);
        sb.append("\u00b0");
        sb.append(rowsString);
        sb.append("\u00b0");
        sb.append(colsString);
        sb.append("\u00b0");
        sb.append(rowsInBlockString);
        sb.append("\u00b0");
        sb.append(colsInBlockString);
        sb.append("\u00b0");
        sb.append(fromString);
        sb.append("\u00b0");
        sb.append(toString);
        sb.append("\u00b0");
        sb.append(incrString);
        sb.append("\u00b0");
        if (et == LopProperties.ExecType.MR) {
            sb.append(this.baseDir);
            sb.append("\u00b0");
        }
        sb.append(this.prepOutputOperand(output));
        return sb.toString();
    }

    private String getRandInstructionMR(int inputIndex, int outputIndex) {
        if (this.getInputs().size() != DataExpression.RAND_VALID_PARAM_NAMES.length) {
            throw new LopsException(this.printErrorLocation() + "Invalid number of operands (" + this.getInputs().size() + ") for a Rand operation");
        }
        StringBuilder sb = new StringBuilder();
        sb.append((Object)this.getExecType());
        sb.append("\u00b0");
        sb.append(RAND_OPCODE);
        sb.append("\u00b0");
        sb.append(inputIndex);
        sb.append("\u00b0");
        sb.append(outputIndex);
        sb.append("\u00b0");
        Lop iLop = this._inputParams.get("rows".toString());
        sb.append(iLop.prepScalarInputOperand(this.getExecType()));
        sb.append("\u00b0");
        iLop = this._inputParams.get("cols".toString());
        sb.append(iLop.prepScalarInputOperand(this.getExecType()));
        sb.append("\u00b0");
        sb.append(String.valueOf(this.getOutputParameters().getRowsInBlock()));
        sb.append("\u00b0");
        sb.append(String.valueOf(this.getOutputParameters().getColsInBlock()));
        sb.append("\u00b0");
        iLop = this._inputParams.get("min".toString());
        sb.append(iLop.prepScalarInputOperand(this.getExecType()));
        sb.append("\u00b0");
        iLop = this._inputParams.get("max".toString());
        sb.append(iLop.prepScalarInputOperand(this.getExecType()));
        sb.append("\u00b0");
        iLop = this._inputParams.get("sparsity".toString());
        if (iLop.isVariable()) {
            sb.append(iLop.prepScalarLabel());
        } else {
            sb.append(iLop.getOutputParameters().getLabel());
        }
        sb.append("\u00b0");
        iLop = this._inputParams.get("seed".toString());
        sb.append(iLop.prepScalarLabel());
        sb.append("\u00b0");
        sb.append(this.baseDir);
        sb.append("\u00b0");
        iLop = this._inputParams.get("pdf".toString());
        if (iLop.isVariable()) {
            throw new LopsException(this.printErrorLocation() + "Parameter " + "pdf" + " must be a literal for a Rand operation.");
        }
        sb.append(iLop.getOutputParameters().getLabel());
        sb.append("\u00b0");
        iLop = this._inputParams.get("lambda".toString());
        sb.append(iLop == null ? "" : iLop.prepScalarLabel());
        return sb.toString();
    }

    private String getSeqInstructionMR(int inputIndex, int outputIndex) {
        StringBuilder sb = new StringBuilder();
        sb.append((Object)this.getExecType());
        sb.append("\u00b0");
        Lop iLop = null;
        iLop = this._inputParams.get("from".toString());
        String fromString = iLop.getOutputParameters().getLabel();
        if (iLop.getExecLocation() == LopProperties.ExecLocation.Data && !((Data)iLop).isLiteral() || iLop.getExecLocation() != LopProperties.ExecLocation.Data) {
            fromString = "\u00b6" + fromString + "\u00b6";
        }
        iLop = this._inputParams.get("to".toString());
        String toString = iLop.getOutputParameters().getLabel();
        if (iLop.getExecLocation() == LopProperties.ExecLocation.Data && !((Data)iLop).isLiteral() || iLop.getExecLocation() != LopProperties.ExecLocation.Data) {
            toString = "\u00b6" + toString + "\u00b6";
        }
        iLop = this._inputParams.get("incr".toString());
        String incrString = iLop.getOutputParameters().getLabel();
        if (iLop.getExecLocation() == LopProperties.ExecLocation.Data && !((Data)iLop).isLiteral() || iLop.getExecLocation() != LopProperties.ExecLocation.Data) {
            incrString = "\u00b6" + incrString + "\u00b6";
        }
        String rowsString = String.valueOf(this.getOutputParameters().getNumRows());
        String colsString = String.valueOf(this.getOutputParameters().getNumCols());
        String rowsInBlockString = String.valueOf(this.getOutputParameters().getRowsInBlock());
        String colsInBlockString = String.valueOf(this.getOutputParameters().getColsInBlock());
        sb.append(SEQ_OPCODE);
        sb.append("\u00b0");
        sb.append(inputIndex);
        sb.append("\u00b0");
        sb.append(outputIndex);
        sb.append("\u00b0");
        sb.append(rowsString);
        sb.append("\u00b0");
        sb.append(colsString);
        sb.append("\u00b0");
        sb.append(rowsInBlockString);
        sb.append("\u00b0");
        sb.append(colsInBlockString);
        sb.append("\u00b0");
        sb.append(fromString);
        sb.append("\u00b0");
        sb.append(toString);
        sb.append("\u00b0");
        sb.append(incrString);
        sb.append("\u00b0");
        sb.append(this.baseDir);
        return sb.toString();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.method.toString());
        sb.append(" ; num_rows=" + this.getOutputParameters().getNumRows());
        sb.append(" ; num_cols=" + this.getOutputParameters().getNumCols());
        sb.append(" ; nnz=" + this.getOutputParameters().getNnz());
        sb.append(" ; num_rows_per_block=" + this.getOutputParameters().getRowsInBlock());
        sb.append(" ; num_cols_per_block=" + this.getOutputParameters().getColsInBlock());
        sb.append(" ; format=" + (Object)((Object)this.getOutputParameters().getFormat()));
        sb.append(" ; blocked=" + this.getOutputParameters().isBlocked());
        sb.append(" ; dir=" + this.baseDir);
        return sb.toString();
    }

    public void setNumThreads(int k) {
        this._numThreads = k;
    }
}

