/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.matrix.mapred;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reducer;
import org.apache.hadoop.mapred.Reporter;
import org.apache.sysml.runtime.functionobjects.CM;
import org.apache.sysml.runtime.instructions.cp.CM_COV_Object;
import org.apache.sysml.runtime.instructions.cp.Data;
import org.apache.sysml.runtime.instructions.cp.KahanObject;
import org.apache.sysml.runtime.instructions.mr.GroupedAggregateInstruction;
import org.apache.sysml.runtime.matrix.data.MatrixCell;
import org.apache.sysml.runtime.matrix.data.MatrixIndexes;
import org.apache.sysml.runtime.matrix.data.TaggedMatrixIndexes;
import org.apache.sysml.runtime.matrix.data.WeightedCell;
import org.apache.sysml.runtime.matrix.mapred.MRJobConfiguration;
import org.apache.sysml.runtime.matrix.mapred.ReduceBase;
import org.apache.sysml.runtime.matrix.operators.AggregateOperator;
import org.apache.sysml.runtime.matrix.operators.CMOperator;
import org.apache.sysml.runtime.matrix.operators.Operator;

public class GroupedAggMRReducer
extends ReduceBase
implements Reducer<TaggedMatrixIndexes, WeightedCell, MatrixIndexes, MatrixCell> {
    private MatrixIndexes outIndex = new MatrixIndexes(1L, 1L);
    private MatrixCell outCell = new MatrixCell();
    private HashMap<Byte, GroupedAggregateInstruction> grpaggInstructions = new HashMap();
    private CM_COV_Object cmObj = new CM_COV_Object();
    private HashMap<Byte, CM> cmFn = new HashMap();
    private HashMap<Byte, ArrayList<Integer>> outputIndexesMapping = new HashMap();

    public void reduce(TaggedMatrixIndexes key, Iterator<WeightedCell> values, OutputCollector<MatrixIndexes, MatrixCell> out, Reporter report) throws IOException {
        block9: {
            this.commonSetup(report);
            GroupedAggregateInstruction ins = this.grpaggInstructions.get(key.getTag());
            Operator op = ins.getOperator();
            try {
                if (op instanceof CMOperator) {
                    this.cmObj.reset();
                    CM lcmFn = this.cmFn.get(key.getTag());
                    while (values.hasNext()) {
                        WeightedCell value = values.next();
                        lcmFn.execute(this.cmObj, value.getValue(), value.getWeight());
                    }
                    this.outCell.setValue(this.cmObj.getRequiredResult(op));
                    break block9;
                }
                if (op instanceof AggregateOperator) {
                    AggregateOperator aggop = (AggregateOperator)op;
                    if (aggop.correctionExists) {
                        KahanObject buffer = new KahanObject(aggop.initialValue, 0.0);
                        while (values.hasNext()) {
                            WeightedCell value = values.next();
                            aggop.increOp.fn.execute((Data)buffer, value.getValue() * value.getWeight());
                        }
                        this.outCell.setValue(buffer._sum);
                    } else {
                        double v = aggop.initialValue;
                        while (values.hasNext()) {
                            WeightedCell value = values.next();
                            v = aggop.increOp.fn.execute(v, value.getValue() * value.getWeight());
                        }
                        this.outCell.setValue(v);
                    }
                    break block9;
                }
                throw new IOException("Unsupported operator in instruction: " + ins);
            }
            catch (Exception ex) {
                throw new IOException(ex);
            }
        }
        this.outIndex.setIndexes((MatrixIndexes)key.getBaseObject());
        this.cachedValues.reset();
        this.cachedValues.set(key.getTag(), this.outIndex, this.outCell);
        this.processReducerInstructions();
        this.outputResultsFromCachedValues(report);
    }

    @Override
    public void configure(JobConf job) {
        super.configure(job);
        try {
            GroupedAggregateInstruction[] grpaggIns = MRJobConfiguration.getGroupedAggregateInstructions(job);
            if (grpaggIns == null) {
                throw new RuntimeException("no GroupAggregate Instructions found!");
            }
            for (GroupedAggregateInstruction ins : grpaggIns) {
                this.grpaggInstructions.put(ins.output, ins);
                if (ins.getOperator() instanceof CMOperator) {
                    this.cmFn.put(ins.output, CM.getCMFnObject(((CMOperator)ins.getOperator()).getAggOpType()));
                }
                this.outputIndexesMapping.put(ins.output, this.getOutputIndexes(ins.output));
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void close() throws IOException {
        super.close();
    }
}

