/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.matrix.sort;

import java.io.IOException;
import java.util.Iterator;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.MapReduceBase;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reducer;
import org.apache.hadoop.mapred.Reporter;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.matrix.data.MatrixBlock;
import org.apache.sysml.runtime.matrix.data.MatrixIndexes;
import org.apache.sysml.runtime.matrix.mapred.MRJobConfiguration;

public class IndexSortStitchupReducer
extends MapReduceBase
implements Reducer<MatrixIndexes, MatrixBlock, MatrixIndexes, MatrixBlock> {
    private MatrixBlock _tmpBlk = null;

    public void reduce(MatrixIndexes key, Iterator<MatrixBlock> values, OutputCollector<MatrixIndexes, MatrixBlock> out, Reporter report) throws IOException {
        try {
            MatrixBlock tmp = values.next();
            this._tmpBlk.reset(tmp.getNumRows(), tmp.getNumColumns());
            this._tmpBlk.merge(tmp, false);
            while (values.hasNext()) {
                tmp = values.next();
                this._tmpBlk.merge(tmp, false);
            }
        }
        catch (DMLRuntimeException ex) {
            throw new IOException(ex);
        }
        out.collect((Object)key, (Object)this._tmpBlk);
    }

    public void configure(JobConf job) {
        int brlen = MRJobConfiguration.getNumRowsPerBlock(job, (byte)0);
        this._tmpBlk = new MatrixBlock(brlen, 1, false);
    }
}

