/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.lops;

import org.apache.spark.storage.StorageLevel;
import org.apache.sysml.lops.Lop;
import org.apache.sysml.lops.LopProperties;
import org.apache.sysml.lops.LopsException;
import org.apache.sysml.lops.compile.JobType;
import org.apache.sysml.parser.Expression;

public class Checkpoint
extends Lop {
    public static final String OPCODE = "chkpoint";
    public static final StorageLevel DEFAULT_STORAGE_LEVEL = StorageLevel.MEMORY_AND_DISK();
    public static final StorageLevel SER_STORAGE_LEVEL = StorageLevel.MEMORY_AND_DISK_SER();
    public static final boolean CHECKPOINT_SPARSE_CSR = true;
    private StorageLevel _storageLevel;

    public Checkpoint(Lop input, Expression.DataType dt, Expression.ValueType vt, String level) {
        super(Lop.Type.Checkpoint, dt, vt);
        this.addInput(input);
        input.addOutput(this);
        this._storageLevel = StorageLevel.fromString((String)level);
        boolean breaksAlignment = false;
        boolean aligner = false;
        boolean definesMRJob = false;
        this.lps.addCompatibility(JobType.INVALID);
        this.lps.setProperties(this.inputs, LopProperties.ExecType.SPARK, LopProperties.ExecLocation.ControlProgram, breaksAlignment, aligner, definesMRJob);
    }

    public StorageLevel getStorageLevel() {
        return this._storageLevel;
    }

    public void setStorageLevel(StorageLevel level) {
        this._storageLevel = level;
    }

    @Override
    public String toString() {
        return "Checkpoint - storage.level = " + this._storageLevel.toString();
    }

    @Override
    public String getInstructions(String input1, String output) {
        if (this.getExecType() != LopProperties.ExecType.SPARK) {
            throw new LopsException("Wrong execution type for Checkpoint.getInstructions (expected: SPARK, found: " + (Object)((Object)this.getExecType()) + ").");
        }
        StringBuilder sb = new StringBuilder();
        sb.append((Object)this.getExecType());
        sb.append("\u00b0");
        sb.append(OPCODE);
        sb.append("\u00b0");
        sb.append(this.getInputs().get(0).prepInputOperand(input1));
        sb.append("\u00b0");
        sb.append(this.prepOutputOperand(output));
        sb.append("\u00b0");
        sb.append(Checkpoint.getStorageLevelString(this._storageLevel));
        return sb.toString();
    }

    public static String getStorageLevelString(StorageLevel level) {
        if (StorageLevel.NONE().equals((Object)level)) {
            return "NONE";
        }
        if (StorageLevel.MEMORY_ONLY().equals((Object)level)) {
            return "MEMORY_ONLY";
        }
        if (StorageLevel.MEMORY_ONLY_2().equals((Object)level)) {
            return "MEMORY_ONLY_2";
        }
        if (StorageLevel.MEMORY_ONLY_SER().equals((Object)level)) {
            return "MEMORY_ONLY_SER";
        }
        if (StorageLevel.MEMORY_ONLY_SER_2().equals((Object)level)) {
            return "MEMORY_ONLY_SER_2";
        }
        if (StorageLevel.MEMORY_AND_DISK().equals((Object)level)) {
            return "MEMORY_AND_DISK";
        }
        if (StorageLevel.MEMORY_AND_DISK_2().equals((Object)level)) {
            return "MEMORY_AND_DISK_2";
        }
        if (StorageLevel.MEMORY_AND_DISK_SER().equals((Object)level)) {
            return "MEMORY_AND_DISK_SER";
        }
        if (StorageLevel.MEMORY_AND_DISK_SER_2().equals((Object)level)) {
            return "MEMORY_AND_DISK_SER_2";
        }
        if (StorageLevel.DISK_ONLY().equals((Object)level)) {
            return "DISK_ONLY";
        }
        if (StorageLevel.DISK_ONLY_2().equals((Object)level)) {
            return "DISK_ONLY_2";
        }
        return "INVALID";
    }

    public static String getDefaultStorageLevelString() {
        return Checkpoint.getStorageLevelString(DEFAULT_STORAGE_LEVEL);
    }

    public static String getSerializeStorageLevelString() {
        return Checkpoint.getStorageLevelString(SER_STORAGE_LEVEL);
    }
}

