/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.controlprogram.paramserv;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.stream.Collectors;
import org.apache.sysml.parser.DataIdentifier;
import org.apache.sysml.parser.Expression;
import org.apache.sysml.parser.Statement;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.controlprogram.FunctionProgramBlock;
import org.apache.sysml.runtime.controlprogram.caching.MatrixObject;
import org.apache.sysml.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysml.runtime.controlprogram.paramserv.ParamServer;
import org.apache.sysml.runtime.controlprogram.paramserv.ParamservUtils;
import org.apache.sysml.runtime.controlprogram.parfor.stat.Timing;
import org.apache.sysml.runtime.instructions.cp.CPOperand;
import org.apache.sysml.runtime.instructions.cp.FunctionCallCPInstruction;

public abstract class PSWorker
implements Serializable {
    private static final long serialVersionUID = -3510485051178200118L;
    protected int _workerID;
    protected int _epochs;
    protected long _batchSize;
    protected ExecutionContext _ec;
    protected ParamServer _ps;
    protected DataIdentifier _output;
    protected FunctionCallCPInstruction _inst;
    protected MatrixObject _features;
    protected MatrixObject _labels;
    protected String _updFunc;
    protected Statement.PSFrequency _freq;

    protected PSWorker() {
    }

    protected PSWorker(int workerID, String updFunc, Statement.PSFrequency freq, int epochs, long batchSize, ExecutionContext ec, ParamServer ps) {
        this._workerID = workerID;
        this._updFunc = updFunc;
        this._freq = freq;
        this._epochs = epochs;
        this._batchSize = batchSize;
        this._ec = ec;
        this._ps = ps;
        this.setupUpdateFunction(updFunc, ec);
    }

    protected void setupUpdateFunction(String updFunc, ExecutionContext ec) {
        String[] cfn = ParamservUtils.getCompleteFuncName(updFunc, "_ps_");
        String ns = cfn[0];
        String fname = cfn[1];
        FunctionProgramBlock func = ec.getProgram().getFunctionProgramBlock(ns, fname);
        ArrayList<DataIdentifier> inputs = func.getInputParams();
        ArrayList<DataIdentifier> outputs = func.getOutputParams();
        CPOperand[] boundInputs = (CPOperand[])inputs.stream().map(input -> new CPOperand(input.getName(), input.getValueType(), input.getDataType())).toArray(CPOperand[]::new);
        ArrayList inputNames = inputs.stream().map(DataIdentifier::getName).collect(Collectors.toCollection(ArrayList::new));
        ArrayList outputNames = outputs.stream().map(DataIdentifier::getName).collect(Collectors.toCollection(ArrayList::new));
        this._inst = new FunctionCallCPInstruction(ns, fname, boundInputs, inputNames, func.getInputParamNames(), outputNames, "update function");
        this.checkInput(false, inputs, Expression.DataType.MATRIX, "features");
        this.checkInput(false, inputs, Expression.DataType.MATRIX, "labels");
        this.checkInput(false, inputs, Expression.DataType.LIST, "model");
        this.checkInput(true, inputs, Expression.DataType.LIST, "hyperparams");
        if (outputs.size() != 1) {
            throw new DMLRuntimeException(String.format("The output of the '%s' function should provide one list containing the gradients.", updFunc));
        }
        if (outputs.get(0).getDataType() != Expression.DataType.LIST) {
            throw new DMLRuntimeException(String.format("The output of the '%s' function should be type of list.", updFunc));
        }
        this._output = outputs.get(0);
    }

    private void checkInput(boolean optional, ArrayList<DataIdentifier> inputs, Expression.DataType dt, String pname) {
        if (optional && inputs.stream().noneMatch(input -> pname.equals(input.getName()))) {
            return;
        }
        if (inputs.stream().filter(input -> input.getDataType() == dt && pname.equals(input.getName())).count() != 1L) {
            throw new DMLRuntimeException(String.format("The '%s' function should provide an input of '%s' type named '%s'.", new Object[]{this._updFunc, dt, pname}));
        }
    }

    public void setFeatures(MatrixObject features) {
        this._features = features;
    }

    public void setLabels(MatrixObject labels) {
        this._labels = labels;
    }

    public MatrixObject getFeatures() {
        return this._features;
    }

    public MatrixObject getLabels() {
        return this._labels;
    }

    public abstract String getWorkerName();

    protected abstract void incWorkerNumber();

    protected abstract void accLocalModelUpdateTime(Timing var1);

    protected abstract void accBatchIndexingTime(Timing var1);

    protected abstract void accGradientComputeTime(Timing var1);

    protected void accNumEpochs(int n) {
    }

    protected void accNumBatches(int n) {
    }
}

