/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.matrix.sort;

import java.io.IOException;
import java.util.Iterator;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.MapReduceBase;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reducer;
import org.apache.hadoop.mapred.Reporter;
import org.apache.sysml.runtime.util.MapReduceTool;

public class ValueSortReducer<K extends WritableComparable, V extends Writable>
extends MapReduceBase
implements Reducer<K, V, K, V> {
    private String taskID = null;
    private boolean valueIsWeight = false;
    private long count = 0L;

    public void configure(JobConf job) {
        this.taskID = MapReduceTool.getUniqueKeyPerTask(job, false);
        this.valueIsWeight = job.getBoolean("value.is.weight", false);
    }

    public void reduce(K key, Iterator<V> values, OutputCollector<K, V> out, Reporter report) throws IOException {
        int sum = 0;
        while (values.hasNext()) {
            Writable value = (Writable)values.next();
            out.collect(key, (Object)value);
            if (this.valueIsWeight) {
                sum += ((IntWritable)value).get();
                continue;
            }
            ++sum;
        }
        this.count += (long)sum;
        report.incrCounter("num.values.in", this.taskID, (long)sum);
    }
}

