/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.util;

import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.math3.linear.Array2DRowRealMatrix;
import org.apache.sysml.parser.Expression;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.instructions.cp.BooleanObject;
import org.apache.sysml.runtime.io.FileFormatProperties;
import org.apache.sysml.runtime.io.MatrixReader;
import org.apache.sysml.runtime.io.MatrixReaderFactory;
import org.apache.sysml.runtime.io.MatrixWriter;
import org.apache.sysml.runtime.io.MatrixWriterFactory;
import org.apache.sysml.runtime.io.ReadProperties;
import org.apache.sysml.runtime.matrix.MatrixCharacteristics;
import org.apache.sysml.runtime.matrix.data.CTableMap;
import org.apache.sysml.runtime.matrix.data.DenseBlock;
import org.apache.sysml.runtime.matrix.data.DenseBlockFactory;
import org.apache.sysml.runtime.matrix.data.FrameBlock;
import org.apache.sysml.runtime.matrix.data.IJV;
import org.apache.sysml.runtime.matrix.data.InputInfo;
import org.apache.sysml.runtime.matrix.data.MatrixBlock;
import org.apache.sysml.runtime.matrix.data.MatrixIndexes;
import org.apache.sysml.runtime.matrix.data.OutputInfo;
import org.apache.sysml.runtime.matrix.data.SparseBlock;
import org.apache.sysml.runtime.util.UtilFunctions;

public class DataConverter {
    public static void writeMatrixToHDFS(MatrixBlock mat, String dir, OutputInfo outputinfo, MatrixCharacteristics mc) throws IOException {
        DataConverter.writeMatrixToHDFS(mat, dir, outputinfo, mc, -1, null);
    }

    public static void writeMatrixToHDFS(MatrixBlock mat, String dir, OutputInfo outputinfo, MatrixCharacteristics mc, int replication, FileFormatProperties formatProperties) throws IOException {
        DataConverter.writeMatrixToHDFS(mat, dir, outputinfo, mc, -1, null, false);
    }

    public static void writeMatrixToHDFS(MatrixBlock mat, String dir, OutputInfo outputinfo, MatrixCharacteristics mc, int replication, FileFormatProperties formatProperties, boolean diag) throws IOException {
        MatrixWriter writer = MatrixWriterFactory.createMatrixWriter(outputinfo, replication, formatProperties);
        writer.writeMatrixToHDFS(mat, dir, mc.getRows(), mc.getCols(), mc.getRowsPerBlock(), mc.getColsPerBlock(), mc.getNonZeros(), diag);
    }

    public static MatrixBlock readMatrixFromHDFS(String dir, InputInfo inputinfo, long rlen, long clen, int brlen, int bclen, boolean localFS) throws IOException {
        ReadProperties prop = new ReadProperties();
        prop.path = dir;
        prop.inputInfo = inputinfo;
        prop.rlen = rlen;
        prop.clen = clen;
        prop.brlen = brlen;
        prop.bclen = bclen;
        prop.localFS = localFS;
        return DataConverter.readMatrixFromHDFS(prop);
    }

    public static MatrixBlock readMatrixFromHDFS(String dir, InputInfo inputinfo, long rlen, long clen, int brlen, int bclen) throws IOException {
        ReadProperties prop = new ReadProperties();
        prop.path = dir;
        prop.inputInfo = inputinfo;
        prop.rlen = rlen;
        prop.clen = clen;
        prop.brlen = brlen;
        prop.bclen = bclen;
        return DataConverter.readMatrixFromHDFS(prop);
    }

    public static MatrixBlock readMatrixFromHDFS(String dir, InputInfo inputinfo, long rlen, long clen, int brlen, int bclen, long expectedNnz) throws IOException {
        ReadProperties prop = new ReadProperties();
        prop.path = dir;
        prop.inputInfo = inputinfo;
        prop.rlen = rlen;
        prop.clen = clen;
        prop.brlen = brlen;
        prop.bclen = bclen;
        prop.expectedNnz = expectedNnz;
        return DataConverter.readMatrixFromHDFS(prop);
    }

    public static MatrixBlock readMatrixFromHDFS(String dir, InputInfo inputinfo, long rlen, long clen, int brlen, int bclen, long expectedNnz, boolean localFS) throws IOException {
        ReadProperties prop = new ReadProperties();
        prop.path = dir;
        prop.inputInfo = inputinfo;
        prop.rlen = rlen;
        prop.clen = clen;
        prop.brlen = brlen;
        prop.bclen = bclen;
        prop.expectedNnz = expectedNnz;
        prop.localFS = localFS;
        return DataConverter.readMatrixFromHDFS(prop);
    }

    public static MatrixBlock readMatrixFromHDFS(String dir, InputInfo inputinfo, long rlen, long clen, int brlen, int bclen, long expectedNnz, FileFormatProperties formatProperties) throws IOException {
        ReadProperties prop = new ReadProperties();
        prop.path = dir;
        prop.inputInfo = inputinfo;
        prop.rlen = rlen;
        prop.clen = clen;
        prop.brlen = brlen;
        prop.bclen = bclen;
        prop.expectedNnz = expectedNnz;
        prop.formatProperties = formatProperties;
        return DataConverter.readMatrixFromHDFS(prop);
    }

    public static MatrixBlock readMatrixFromHDFS(ReadProperties prop) throws IOException {
        MatrixBlock ret = null;
        try {
            MatrixReader reader = MatrixReaderFactory.createMatrixReader(prop);
            ret = reader.readMatrixFromHDFS(prop.path, prop.rlen, prop.clen, prop.brlen, prop.bclen, prop.expectedNnz);
        }
        catch (DMLRuntimeException rex) {
            throw new IOException(rex);
        }
        return ret;
    }

    public static double[][] convertToDoubleMatrix(MatrixBlock mb) {
        double[][] ret;
        block5: {
            int rows = mb.getNumRows();
            int cols = mb.getNumColumns();
            ret = new double[rows][cols];
            if (mb.getNonZeros() <= 0L) break block5;
            if (mb.isInSparseFormat()) {
                Iterator<IJV> iter = mb.getSparseBlockIterator();
                while (iter.hasNext()) {
                    IJV cell = iter.next();
                    ret[cell.getI()][cell.getJ()] = cell.getV();
                }
            } else {
                double[] a = mb.getDenseBlockValues();
                int ix = 0;
                for (int i = 0; i < rows; ++i) {
                    int j = 0;
                    while (j < cols) {
                        ret[i][j] = a[ix];
                        ++j;
                        ++ix;
                    }
                }
            }
        }
        return ret;
    }

    public static boolean[] convertToBooleanVector(MatrixBlock mb) {
        boolean[] ret;
        block5: {
            int rows = mb.getNumRows();
            int cols = mb.getNumColumns();
            ret = new boolean[rows * cols];
            if (mb.getNonZeros() <= 0L) break block5;
            if (mb.isInSparseFormat()) {
                Iterator<IJV> iter = mb.getSparseBlockIterator();
                while (iter.hasNext()) {
                    IJV cell = iter.next();
                    ret[cell.getI() * cols + cell.getJ()] = cell.getV() != 0.0;
                }
            } else {
                int cix = 0;
                for (int i = 0; i < rows; ++i) {
                    int j = 0;
                    while (j < cols) {
                        ret[cix] = mb.getValueDenseUnsafe(i, j) != 0.0;
                        ++j;
                        ++cix;
                    }
                }
            }
        }
        return ret;
    }

    public static int[] convertToIntVector(MatrixBlock mb) {
        int rows = mb.getNumRows();
        int cols = mb.getNumColumns();
        int[] ret = new int[rows * cols];
        if (mb.isEmptyBlock(false)) {
            return ret;
        }
        if (mb.isInSparseFormat()) {
            Iterator<IJV> iter = mb.getSparseBlockIterator();
            while (iter.hasNext()) {
                IJV cell = iter.next();
                ret[cell.getI() * cols + cell.getJ()] = (int)cell.getV();
            }
        } else {
            int cix = 0;
            for (int i = 0; i < rows; ++i) {
                int j = 0;
                while (j < cols) {
                    ret[cix] = (int)mb.getValueDenseUnsafe(i, j);
                    ++j;
                    ++cix;
                }
            }
        }
        return ret;
    }

    public static long[] convertToLongVector(MatrixBlock mb) {
        int rows = mb.getNumRows();
        int cols = mb.getNumColumns();
        long[] ret = new long[rows * cols];
        if (mb.isEmptyBlock(false)) {
            return ret;
        }
        if (mb.isInSparseFormat()) {
            Iterator<IJV> iter = mb.getSparseBlockIterator();
            while (iter.hasNext()) {
                IJV cell = iter.next();
                ret[cell.getI() * cols + cell.getJ()] = (int)cell.getV();
            }
        } else {
            int cix = 0;
            for (int i = 0; i < rows; ++i) {
                int j = 0;
                while (j < cols) {
                    ret[cix] = (int)mb.getValueDenseUnsafe(i, j);
                    ++j;
                    ++cix;
                }
            }
        }
        return ret;
    }

    public static DenseBlock convertToDenseBlock(MatrixBlock mb) {
        return DataConverter.convertToDenseBlock(mb, true);
    }

    public static DenseBlock convertToDenseBlock(MatrixBlock mb, boolean deep) {
        DenseBlock ret;
        int rows = mb.getNumRows();
        int cols = mb.getNumColumns();
        DenseBlock denseBlock = ret = !mb.isInSparseFormat() && mb.isAllocated() && !deep ? mb.getDenseBlock() : DenseBlockFactory.createDenseBlock(rows, cols);
        if (!mb.isEmptyBlock(false)) {
            if (mb.isInSparseFormat()) {
                Iterator<IJV> iter = mb.getSparseBlockIterator();
                while (iter.hasNext()) {
                    IJV cell = iter.next();
                    ret.set(cell.getI(), cell.getJ(), cell.getV());
                }
            } else if (deep) {
                ret.set(mb.getDenseBlock());
            }
        }
        return ret;
    }

    public static double[] convertToDoubleVector(MatrixBlock mb) {
        return DataConverter.convertToDoubleVector(mb, true);
    }

    public static double[] convertToDoubleVector(MatrixBlock mb, boolean deep) {
        double[] ret;
        int rows = mb.getNumRows();
        int cols = mb.getNumColumns();
        double[] dArray = ret = !mb.isInSparseFormat() && mb.isAllocated() && !deep ? mb.getDenseBlockValues() : new double[rows * cols];
        if (!mb.isEmptyBlock(false)) {
            if (mb.isInSparseFormat()) {
                Iterator<IJV> iter = mb.getSparseBlockIterator();
                while (iter.hasNext()) {
                    IJV cell = iter.next();
                    ret[cell.getI() * cols + cell.getJ()] = cell.getV();
                }
            } else if (deep) {
                System.arraycopy(mb.getDenseBlockValues(), 0, ret, 0, rows * cols);
            }
        }
        return ret;
    }

    public static List<Double> convertToDoubleList(MatrixBlock mb) {
        int rows = mb.getNumRows();
        int cols = mb.getNumColumns();
        long nnz = mb.getNonZeros();
        ArrayList<Double> ret = new ArrayList<Double>();
        if (mb.isInSparseFormat()) {
            Iterator<IJV> iter = mb.getSparseBlockIterator();
            while (iter.hasNext()) {
                IJV cell = iter.next();
                ret.add(cell.getV());
            }
            for (long i = nnz; i < (long)rows * (long)cols; ++i) {
                ret.add(0.0);
            }
        } else {
            for (int i = 0; i < rows; ++i) {
                for (int j = 0; j < cols; ++j) {
                    ret.add(mb.getValueDenseUnsafe(i, j));
                }
            }
        }
        return ret;
    }

    public static MatrixBlock convertToMatrixBlock(double[][] data) {
        int rows = data.length;
        int cols = rows > 0 ? data[0].length : 0;
        MatrixBlock mb = new MatrixBlock(rows, cols, false);
        try {
            mb.init(data, rows, cols);
        }
        catch (Exception exception) {
            // empty catch block
        }
        mb.examSparsity();
        return mb;
    }

    public static MatrixBlock convertToMatrixBlock(double[] data, boolean columnVector) {
        int rows = columnVector ? data.length : 1;
        int cols = columnVector ? 1 : data.length;
        MatrixBlock mb = new MatrixBlock(rows, cols, false);
        mb.init(data, rows, cols);
        mb.examSparsity();
        return mb;
    }

    public static MatrixBlock convertToMatrixBlock(HashMap<MatrixIndexes, Double> map) {
        long nrows = 0L;
        long ncols = 0L;
        for (MatrixIndexes index : map.keySet()) {
            nrows = Math.max(nrows, index.getRowIndex());
            ncols = Math.max(ncols, index.getColumnIndex());
        }
        return DataConverter.convertToMatrixBlock(map, (int)nrows, (int)ncols);
    }

    public static MatrixBlock convertToMatrixBlock(HashMap<MatrixIndexes, Double> map, int rlen, int clen) {
        int nnz = map.size();
        boolean sparse = MatrixBlock.evalSparseFormatInMemory(rlen, clen, nnz);
        MatrixBlock mb = new MatrixBlock(rlen, clen, sparse, nnz);
        if (sparse) {
            for (Map.Entry<MatrixIndexes, Double> e : map.entrySet()) {
                MatrixIndexes index = e.getKey();
                double value = e.getValue();
                int rix = (int)index.getRowIndex();
                int cix = (int)index.getColumnIndex();
                if (value == 0.0 || rix > rlen || cix > clen) continue;
                mb.appendValue(rix - 1, cix - 1, value);
            }
            mb.sortSparseRows();
        } else {
            for (Map.Entry<MatrixIndexes, Double> e : map.entrySet()) {
                MatrixIndexes index = e.getKey();
                double value = e.getValue();
                int rix = (int)index.getRowIndex();
                int cix = (int)index.getColumnIndex();
                if (value == 0.0 || rix > rlen || cix > clen) continue;
                mb.quickSetValue(rix - 1, cix - 1, value);
            }
        }
        return mb;
    }

    public static MatrixBlock convertToMatrixBlock(CTableMap map) {
        int nrows = (int)map.getMaxRow();
        int ncols = (int)map.getMaxColumn();
        return DataConverter.convertToMatrixBlock(map, nrows, ncols);
    }

    public static MatrixBlock convertToMatrixBlock(CTableMap map, int rlen, int clen) {
        return map.toMatrixBlock(rlen, clen);
    }

    public static MatrixBlock convertToMatrixBlock(FrameBlock frame) {
        int m = frame.getNumRows();
        int n = frame.getNumColumns();
        MatrixBlock mb = new MatrixBlock(m, n, false);
        mb.allocateDenseBlock();
        Expression.ValueType[] schema = frame.getSchema();
        int dFreq = UtilFunctions.frequency(schema, Expression.ValueType.DOUBLE);
        if (dFreq == schema.length) {
            double[][] a = new double[n][];
            double[] c = mb.getDenseBlockValues();
            for (int j = 0; j < n; ++j) {
                a[j] = (double[])frame.getColumnData(j);
            }
            int blocksizeIJ = 16;
            for (int bi = 0; bi < m; bi += blocksizeIJ) {
                for (int bj = 0; bj < n; bj += blocksizeIJ) {
                    int bimin = Math.min(bi + blocksizeIJ, m);
                    int bjmin = Math.min(bj + blocksizeIJ, n);
                    int i = bi;
                    int aix = bi * n;
                    while (i < bimin) {
                        for (int j = bj; j < bjmin; ++j) {
                            c[aix + j] = a[j][i];
                        }
                        ++i;
                        aix += n;
                    }
                }
            }
        } else {
            for (int i = 0; i < frame.getNumRows(); ++i) {
                for (int j = 0; j < frame.getNumColumns(); ++j) {
                    mb.appendValue(i, j, UtilFunctions.objectToDouble(schema[j], frame.get(i, j)));
                }
            }
        }
        mb.examSparsity();
        return mb;
    }

    public static String[][] convertToStringFrame(FrameBlock frame) {
        String[][] ret = new String[frame.getNumRows()][];
        Iterator<String[]> iter = frame.getStringRowIterator();
        int i = 0;
        while (iter.hasNext()) {
            ret[i] = (String[])iter.next().clone();
            ++i;
        }
        return ret;
    }

    public static FrameBlock convertToFrameBlock(String[][] data) {
        if (data == null || data.length == 0) {
            return new FrameBlock();
        }
        Expression.ValueType[] schema = UtilFunctions.nCopies(data[0].length, Expression.ValueType.STRING);
        return DataConverter.convertToFrameBlock(data, schema);
    }

    public static FrameBlock convertToFrameBlock(String[][] data, Expression.ValueType[] schema) {
        if (data == null || data.length == 0) {
            return new FrameBlock();
        }
        return new FrameBlock(schema, data);
    }

    public static FrameBlock convertToFrameBlock(String[][] data, Expression.ValueType[] schema, String[] colnames) {
        if (data == null || data.length == 0) {
            return new FrameBlock();
        }
        return new FrameBlock(schema, colnames, data);
    }

    public static FrameBlock convertToFrameBlock(MatrixBlock mb) {
        return DataConverter.convertToFrameBlock(mb, Expression.ValueType.DOUBLE);
    }

    public static FrameBlock convertToFrameBlock(MatrixBlock mb, Expression.ValueType vt) {
        Expression.ValueType[] schema = UtilFunctions.nCopies(mb.getNumColumns(), vt);
        return DataConverter.convertToFrameBlock(mb, schema);
    }

    public static FrameBlock convertToFrameBlock(MatrixBlock mb, Expression.ValueType[] schema) {
        FrameBlock frame = new FrameBlock(schema);
        Object[] row = new Object[mb.getNumColumns()];
        if (mb.isInSparseFormat()) {
            SparseBlock sblock = mb.getSparseBlock();
            for (int i = 0; i < mb.getNumRows(); ++i) {
                Arrays.fill(row, null);
                if (sblock != null && !sblock.isEmpty(i)) {
                    int apos = sblock.pos(i);
                    int alen = sblock.size(i);
                    int[] aix = sblock.indexes(i);
                    double[] aval = sblock.values(i);
                    for (int j = apos; j < apos + alen; ++j) {
                        row[aix[j]] = UtilFunctions.doubleToObject(schema[aix[j]], aval[j]);
                    }
                }
                frame.appendRow(row);
            }
        } else {
            int dFreq = UtilFunctions.frequency(schema, Expression.ValueType.DOUBLE);
            if (schema.length == 1 && dFreq == 1 && mb.isAllocated()) {
                frame.reset();
                frame.appendColumns(new double[][]{mb.getDenseBlockValues()});
            } else if (dFreq == schema.length) {
                int m = mb.getNumRows();
                int n = mb.getNumColumns();
                double[] a = mb.getDenseBlockValues();
                double[][] c = new double[n][m];
                int blocksizeIJ = 16;
                if (!mb.isEmptyBlock(false)) {
                    for (int bi = 0; bi < m; bi += blocksizeIJ) {
                        for (int bj = 0; bj < n; bj += blocksizeIJ) {
                            int bimin = Math.min(bi + blocksizeIJ, m);
                            int bjmin = Math.min(bj + blocksizeIJ, n);
                            int i = bi;
                            int aix = bi * n;
                            while (i < bimin) {
                                for (int j = bj; j < bjmin; ++j) {
                                    c[j][i] = a[aix + j];
                                }
                                ++i;
                                aix += n;
                            }
                        }
                    }
                }
                frame.reset();
                frame.appendColumns(c);
            } else {
                for (int i = 0; i < mb.getNumRows(); ++i) {
                    for (int j = 0; j < mb.getNumColumns(); ++j) {
                        row[j] = UtilFunctions.doubleToObject(schema[j], mb.quickGetValue(i, j));
                    }
                    frame.appendRow(row);
                }
            }
        }
        return frame;
    }

    public static MatrixBlock[] convertToMatrixBlockPartitions(MatrixBlock mb, boolean colwise) {
        MatrixBlock[] ret;
        block10: {
            int i;
            double sparsity;
            boolean sparse;
            int cols;
            int rows;
            block9: {
                ret = null;
                rows = mb.getNumRows();
                cols = mb.getNumColumns();
                long nnz = mb.getNonZeros();
                sparse = mb.isInSparseFormat();
                sparsity = (double)nnz / (double)(rows * cols);
                if (!colwise) break block9;
                ret = new MatrixBlock[cols];
                for (int j = 0; j < cols; ++j) {
                    ret[j] = new MatrixBlock(rows, 1, false);
                }
                if (mb.isEmptyBlock(false)) break block10;
                if (sparse) {
                    Iterator<IJV> iter = mb.getSparseBlockIterator();
                    while (iter.hasNext()) {
                        IJV cell = iter.next();
                        ret[cell.getJ()].appendValue(cell.getI(), 0, cell.getV());
                    }
                } else {
                    for (int i2 = 0; i2 < rows; ++i2) {
                        for (int j = 0; j < cols; ++j) {
                            ret[j].appendValue(i2, 0, mb.getValueDenseUnsafe(i2, j));
                        }
                    }
                }
                break block10;
            }
            ret = new MatrixBlock[rows];
            for (i = 0; i < rows; ++i) {
                ret[i] = new MatrixBlock(1, cols, sparse, (long)((double)cols * sparsity));
            }
            if (!mb.isEmptyBlock(false)) {
                for (i = 0; i < rows; ++i) {
                    mb.slice(i, i, 0, cols - 1, ret[i]);
                }
            }
        }
        return ret;
    }

    public static Array2DRowRealMatrix convertToArray2DRowRealMatrix(MatrixBlock mb) {
        double[][] data = DataConverter.convertToDoubleMatrix(mb);
        return new Array2DRowRealMatrix(data, false);
    }

    public static void copyToDoubleVector(MatrixBlock mb, double[] dest, int destPos) {
        if (mb.isEmptyBlock(false)) {
            return;
        }
        int rows = mb.getNumRows();
        int cols = mb.getNumColumns();
        if (mb.isInSparseFormat()) {
            Iterator<IJV> iter = mb.getSparseBlockIterator();
            while (iter.hasNext()) {
                IJV cell = iter.next();
                dest[destPos + cell.getI() * cols + cell.getJ()] = cell.getV();
            }
        } else {
            System.arraycopy(mb.getDenseBlockValues(), 0, dest, destPos, rows * cols);
        }
    }

    private static String dfFormat(DecimalFormat df, double value) {
        if (Double.isNaN(value) || Double.isInfinite(value)) {
            return Double.toString(value);
        }
        return df.format(value);
    }

    public static String toString(MatrixBlock mb) {
        return DataConverter.toString(mb, false, " ", "\n", mb.getNumRows(), mb.getNumColumns(), 3);
    }

    public static String toString(MatrixBlock mb, boolean sparse, String separator, String lineseparator, int rowsToPrint, int colsToPrint, int decimal) {
        StringBuffer sb = new StringBuffer();
        int rlen = mb.getNumRows();
        int clen = mb.getNumColumns();
        int rowLength = rlen;
        int colLength = clen;
        if (rowsToPrint >= 0) {
            int n = rowLength = rowsToPrint < rlen ? rowsToPrint : rlen;
        }
        if (colsToPrint >= 0) {
            colLength = colsToPrint < clen ? colsToPrint : clen;
        }
        DecimalFormat df = new DecimalFormat();
        df.setGroupingUsed(false);
        if (decimal >= 0) {
            df.setMinimumFractionDigits(decimal);
        }
        if (sparse) {
            if (mb.isInSparseFormat()) {
                Iterator<IJV> sbi = mb.getSparseBlockIterator();
                while (sbi.hasNext()) {
                    IJV ijv = sbi.next();
                    int row = ijv.getI();
                    int col = ijv.getJ();
                    double value = ijv.getV();
                    if (row >= rowLength || col >= colLength) continue;
                    sb.append(row + 1).append(separator).append(col + 1).append(separator);
                    sb.append(DataConverter.dfFormat(df, value)).append(lineseparator);
                }
            } else {
                for (int i = 0; i < rowLength; ++i) {
                    for (int j = 0; j < colLength; ++j) {
                        double value = mb.getValue(i, j);
                        if (value == 0.0) continue;
                        sb.append(i + 1).append(separator).append(j + 1).append(separator);
                        sb.append(DataConverter.dfFormat(df, value)).append(lineseparator);
                    }
                }
            }
        } else {
            for (int i = 0; i < rowLength; ++i) {
                for (int j = 0; j < colLength - 1; ++j) {
                    Double value = mb.quickGetValue(i, j);
                    if (value.equals(-0.0)) {
                        value = 0.0;
                    }
                    sb.append(DataConverter.dfFormat(df, value));
                    sb.append(separator);
                }
                Double value = mb.quickGetValue(i, colLength - 1);
                if (value.equals(-0.0)) {
                    value = 0.0;
                }
                sb.append(DataConverter.dfFormat(df, value));
                sb.append(lineseparator);
            }
        }
        return sb.toString();
    }

    public static String toString(FrameBlock fb) {
        return DataConverter.toString(fb, false, " ", "\n", fb.getNumRows(), fb.getNumColumns(), 3);
    }

    public static String toString(FrameBlock fb, boolean sparse, String separator, String lineseparator, int rowsToPrint, int colsToPrint, int decimal) {
        int j;
        StringBuffer sb = new StringBuffer();
        int rlen = fb.getNumRows();
        int clen = fb.getNumColumns();
        int rowLength = rlen;
        int colLength = clen;
        if (rowsToPrint >= 0) {
            int n = rowLength = rowsToPrint < rlen ? rowsToPrint : rlen;
        }
        if (colsToPrint >= 0) {
            colLength = colsToPrint < clen ? colsToPrint : clen;
        }
        sb.append("# FRAME: ");
        sb.append("nrow = " + fb.getNumRows() + ", ");
        sb.append("ncol = " + fb.getNumColumns() + lineseparator);
        sb.append("#");
        sb.append(separator);
        for (j = 0; j < colLength; ++j) {
            sb.append(fb.getColumnNames()[j]);
            if (j == colLength - 1) continue;
            sb.append(separator);
        }
        sb.append(lineseparator);
        sb.append("#");
        sb.append(separator);
        for (j = 0; j < colLength; ++j) {
            sb.append((Object)fb.getSchema()[j]);
            if (j == colLength - 1) continue;
            sb.append(separator);
        }
        sb.append(lineseparator);
        DecimalFormat df = new DecimalFormat();
        df.setGroupingUsed(false);
        if (decimal >= 0) {
            df.setMinimumFractionDigits(decimal);
        }
        Iterator<Object[]> iter = fb.getObjectRowIterator(0, rowLength);
        while (iter.hasNext()) {
            Object[] row = iter.next();
            for (int j2 = 0; j2 < colLength; ++j2) {
                if (row[j2] == null) {
                    sb.append(String.valueOf(row[j2]));
                } else if (fb.getSchema()[j2] == Expression.ValueType.DOUBLE) {
                    sb.append(DataConverter.dfFormat(df, (Double)row[j2]));
                } else if (fb.getSchema()[j2] == Expression.ValueType.BOOLEAN) {
                    sb.append(new BooleanObject((Boolean)row[j2]).getLanguageSpecificStringValue());
                } else {
                    sb.append(row[j2]);
                }
                if (j2 == colLength - 1) continue;
                sb.append(separator);
            }
            sb.append(lineseparator);
        }
        return sb.toString();
    }
}

