/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.controlprogram.parfor;

import java.util.Arrays;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.JobConf;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.PairFlatMapFunction;
import org.apache.spark.api.java.function.PairFunction;
import org.apache.sysml.api.DMLScript;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.controlprogram.caching.MatrixObject;
import org.apache.sysml.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysml.runtime.controlprogram.context.SparkExecutionContext;
import org.apache.sysml.runtime.controlprogram.parfor.ResultMerge;
import org.apache.sysml.runtime.controlprogram.parfor.ResultMergeRemoteMR;
import org.apache.sysml.runtime.controlprogram.parfor.ResultMergeRemoteSparkWCompare;
import org.apache.sysml.runtime.instructions.spark.data.RDDObject;
import org.apache.sysml.runtime.instructions.spark.functions.CopyBlockPairFunction;
import org.apache.sysml.runtime.instructions.spark.utils.RDDAggregateUtils;
import org.apache.sysml.runtime.matrix.MatrixCharacteristics;
import org.apache.sysml.runtime.matrix.MetaDataFormat;
import org.apache.sysml.runtime.matrix.data.InputInfo;
import org.apache.sysml.runtime.matrix.data.MatrixBlock;
import org.apache.sysml.runtime.matrix.data.MatrixIndexes;
import org.apache.sysml.runtime.matrix.data.OutputInfo;
import org.apache.sysml.utils.Statistics;

public class ResultMergeRemoteSpark
extends ResultMerge {
    private static final long serialVersionUID = -6924566953903424820L;
    private ExecutionContext _ec = null;
    private int _numMappers = -1;
    private int _numReducers = -1;

    public ResultMergeRemoteSpark(MatrixObject out, MatrixObject[] in, String outputFilename, boolean accum, ExecutionContext ec, int numMappers, int numReducers) {
        super(out, in, outputFilename, accum);
        this._ec = ec;
        this._numMappers = numMappers;
        this._numReducers = numReducers;
    }

    @Override
    public MatrixObject executeSerialMerge() {
        return this.executeParallelMerge(this._numMappers);
    }

    @Override
    public MatrixObject executeParallelMerge(int par) {
        MatrixObject moNew = null;
        if (LOG.isTraceEnabled()) {
            LOG.trace("ResultMerge (remote, spark): Execute serial merge for output " + this._output.hashCode() + " (fname=" + this._output.getFileName() + ")");
        }
        try {
            if (this._inputs != null && this._inputs.length > 0) {
                MetaDataFormat metadata = (MetaDataFormat)this._output.getMetaData();
                MatrixCharacteristics mcOld = metadata.getMatrixCharacteristics();
                MatrixObject compare = mcOld.getNonZeros() == 0L ? null : this._output;
                RDDObject ro = this.executeMerge(compare, this._inputs, mcOld.getRows(), mcOld.getCols(), mcOld.getRowsPerBlock(), mcOld.getColsPerBlock());
                moNew = new MatrixObject(this._output.getValueType(), this._outputFName);
                OutputInfo oiOld = metadata.getOutputInfo();
                InputInfo iiOld = metadata.getInputInfo();
                MatrixCharacteristics mc = new MatrixCharacteristics(mcOld);
                mc.setNonZeros(this._isAccum ? -1L : this.computeNonZeros(this._output, Arrays.asList(this._inputs)));
                MetaDataFormat meta = new MetaDataFormat(mc, oiOld, iiOld);
                moNew.setMetaData(meta);
                moNew.setRDDHandle(ro);
            } else {
                moNew = this._output;
            }
        }
        catch (Exception ex) {
            throw new DMLRuntimeException(ex);
        }
        return moNew;
    }

    protected RDDObject executeMerge(MatrixObject compare, MatrixObject[] inputs, long rlen, long clen, int brlen, int bclen) {
        String jobname = "ParFor-RMSP";
        long t0 = DMLScript.STATISTICS ? System.nanoTime() : 0L;
        SparkExecutionContext sec = (SparkExecutionContext)this._ec;
        boolean withCompare = compare != null;
        RDDObject ret = null;
        int numRed = ResultMergeRemoteSpark.determineNumReducers(rlen, clen, brlen, bclen, this._numReducers);
        if (inputs == null || inputs.length == 0) {
            throw new DMLRuntimeException("Execute merge should never be called with no inputs.");
        }
        try {
            InputInfo ii = InputInfo.BinaryBlockInputInfo;
            JobConf job = new JobConf(ResultMergeRemoteMR.class);
            job.setJobName(jobname);
            job.setInputFormat(ii.inputFormatClass);
            Path[] paths = new Path[inputs.length];
            for (int i = 0; i < paths.length; ++i) {
                inputs[i].exportData();
                paths[i] = new Path(inputs[i].getFileName());
                ResultMergeRemoteSpark.setRDDHandleForMerge(inputs[i], sec);
            }
            FileInputFormat.setInputPaths(job, paths);
            JavaPairRDD rdd = sec.getSparkContext().hadoopRDD(job, ii.inputFormatClass, ii.inputKeyClass, ii.inputValueClass).mapPartitionsToPair((PairFlatMapFunction)new CopyBlockPairFunction(true), true);
            JavaPairRDD out = null;
            if (withCompare) {
                JavaPairRDD<?, ?> compareRdd = sec.getRDDHandleForMatrixObject(compare, InputInfo.BinaryBlockInputInfo);
                ResultMergeRemoteSparkWCompare cfun = new ResultMergeRemoteSparkWCompare(this._isAccum);
                out = rdd.groupByKey(numRed).join(compareRdd).mapToPair((PairFunction)cfun);
            } else {
                out = this._isAccum ? RDDAggregateUtils.sumByKeyStable((JavaPairRDD<MatrixIndexes, MatrixBlock>)rdd, false) : RDDAggregateUtils.mergeByKey((JavaPairRDD<MatrixIndexes, MatrixBlock>)rdd, false);
            }
            ret = new RDDObject(out);
            for (int i = 0; i < paths.length; ++i) {
                ret.addLineageChild(inputs[i].getRDDHandle());
            }
            if (withCompare) {
                ret.addLineageChild(compare.getRDDHandle());
            }
        }
        catch (Exception ex) {
            throw new DMLRuntimeException(ex);
        }
        Statistics.incrementNoOfCompiledSPInst();
        Statistics.incrementNoOfExecutedSPInst();
        if (DMLScript.STATISTICS) {
            Statistics.maintainCPHeavyHitters(jobname, System.nanoTime() - t0);
        }
        return ret;
    }

    private static int determineNumReducers(long rlen, long clen, int brlen, int bclen, long numRed) {
        long reducerGroups = Math.max(rlen / (long)brlen, 1L) * Math.max(clen / (long)bclen, 1L);
        return (int)Math.min(numRed, reducerGroups);
    }

    private static void setRDDHandleForMerge(MatrixObject mo, SparkExecutionContext sec) {
        InputInfo iinfo = InputInfo.BinaryBlockInputInfo;
        JavaSparkContext sc = sec.getSparkContext();
        JavaPairRDD rdd = sc.hadoopFile(mo.getFileName(), iinfo.inputFormatClass, iinfo.inputKeyClass, iinfo.inputValueClass);
        RDDObject rddhandle = new RDDObject(rdd);
        rddhandle.setHDFSFile(true);
        mo.setRDDHandle(rddhandle);
    }
}

