/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.instructions.spark;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.api.java.function.PairFlatMapFunction;
import org.apache.sysml.lops.Ctable;
import org.apache.sysml.parser.Expression;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysml.runtime.controlprogram.context.SparkExecutionContext;
import org.apache.sysml.runtime.instructions.InstructionUtils;
import org.apache.sysml.runtime.instructions.cp.CPOperand;
import org.apache.sysml.runtime.instructions.spark.ComputationSPInstruction;
import org.apache.sysml.runtime.instructions.spark.SPInstruction;
import org.apache.sysml.runtime.instructions.spark.utils.RDDAggregateUtils;
import org.apache.sysml.runtime.instructions.spark.utils.SparkUtils;
import org.apache.sysml.runtime.matrix.MatrixCharacteristics;
import org.apache.sysml.runtime.matrix.data.CTableMap;
import org.apache.sysml.runtime.matrix.data.MatrixBlock;
import org.apache.sysml.runtime.matrix.data.MatrixIndexes;
import org.apache.sysml.runtime.matrix.data.MatrixValue;
import org.apache.sysml.runtime.matrix.data.OperationsOnMatrixValues;
import org.apache.sysml.runtime.matrix.mapred.ReblockBuffer;
import org.apache.sysml.runtime.util.LongLongDoubleHashMap;
import scala.Tuple2;

public class CtableSPInstruction
extends ComputationSPInstruction {
    private String _outDim1;
    private String _outDim2;
    private boolean _dim1Literal;
    private boolean _dim2Literal;
    private boolean _isExpand;
    private boolean _ignoreZeros;

    private CtableSPInstruction(CPOperand in1, CPOperand in2, CPOperand in3, CPOperand out, String outputDim1, boolean dim1Literal, String outputDim2, boolean dim2Literal, boolean isExpand, boolean ignoreZeros, String opcode, String istr) {
        super(SPInstruction.SPType.Ctable, null, in1, in2, in3, out, opcode, istr);
        this._outDim1 = outputDim1;
        this._dim1Literal = dim1Literal;
        this._outDim2 = outputDim2;
        this._dim2Literal = dim2Literal;
        this._isExpand = isExpand;
        this._ignoreZeros = ignoreZeros;
    }

    public static CtableSPInstruction parseInstruction(String inst) {
        String[] parts = InstructionUtils.getInstructionPartsWithValueType(inst);
        InstructionUtils.checkNumFields(parts, 7);
        String opcode = parts[0];
        if (!opcode.equalsIgnoreCase("ctable") && !opcode.equalsIgnoreCase("ctableexpand")) {
            throw new DMLRuntimeException("Unexpected opcode in TertiarySPInstruction: " + inst);
        }
        boolean isExpand = opcode.equalsIgnoreCase("ctableexpand");
        CPOperand in1 = new CPOperand(parts[1]);
        CPOperand in2 = new CPOperand(parts[2]);
        CPOperand in3 = new CPOperand(parts[3]);
        String[] dim1Fields = parts[4].split("\u00b7");
        String[] dim2Fields = parts[5].split("\u00b7");
        CPOperand out = new CPOperand(parts[6]);
        boolean ignoreZeros = Boolean.parseBoolean(parts[7]);
        return new CtableSPInstruction(in1, in2, in3, out, dim1Fields[0], Boolean.parseBoolean(dim1Fields[1]), dim2Fields[0], Boolean.parseBoolean(dim2Fields[1]), isExpand, ignoreZeros, opcode, inst);
    }

    @Override
    public void processInstruction(ExecutionContext ec) {
        long dim2;
        SparkExecutionContext sec = (SparkExecutionContext)ec;
        Ctable.OperationTypes ctableOp = Ctable.findCtableOperationByInputDataTypes(this.input1.getDataType(), this.input2.getDataType(), this.input3.getDataType());
        ctableOp = this._isExpand ? Ctable.OperationTypes.CTABLE_EXPAND_SCALAR_WEIGHT : ctableOp;
        JavaPairRDD<MatrixIndexes, MatrixBlock> in1 = sec.getBinaryBlockRDDHandleForVariable(this.input1.getName());
        JavaPairRDD<MatrixIndexes, MatrixBlock> in2 = !ctableOp.hasSecondInput() ? null : sec.getBinaryBlockRDDHandleForVariable(this.input2.getName());
        JavaPairRDD<MatrixIndexes, MatrixBlock> in3 = null;
        double s2 = -1.0;
        double s3 = -1.0;
        MatrixCharacteristics mc1 = sec.getMatrixCharacteristics(this.input1.getName());
        MatrixCharacteristics mcOut = sec.getMatrixCharacteristics(this.output.getName());
        long dim1 = this._dim1Literal ? (long)Double.parseDouble(this._outDim1) : sec.getScalarInput(this._outDim1, Expression.ValueType.DOUBLE, false).getLongValue();
        long l = dim2 = this._dim2Literal ? (long)Double.parseDouble(this._outDim2) : sec.getScalarInput(this._outDim2, Expression.ValueType.DOUBLE, false).getLongValue();
        if (dim1 == -1L && dim2 == -1L) {
            dim1 = (long)RDDAggregateUtils.max(in1);
            dim2 = ctableOp.hasSecondInput() ? (long)RDDAggregateUtils.max(in2) : sec.getScalarInput(this.input3).getLongValue();
        }
        mcOut.set(dim1, dim2, mc1.getRowsPerBlock(), mc1.getColsPerBlock());
        mcOut.setNonZerosBound(mc1.getRows());
        int numParts = Math.max(4 * (mc1.dimsKnown() ? SparkUtils.getNumPreferredPartitions(mc1) : in1.getNumPartitions()), SparkUtils.getNumPreferredPartitions(mcOut));
        JavaPairRDD<MatrixIndexes, MatrixBlock> out = null;
        switch (ctableOp) {
            case CTABLE_TRANSFORM: {
                in3 = sec.getBinaryBlockRDDHandleForVariable(this.input3.getName());
                out = in1.join(in2, numParts).join(in3, numParts).mapValues((Function)new MapJoinSignature3()).mapPartitionsToPair((PairFlatMapFunction)new CTableFunction(ctableOp, s2, s3, this._ignoreZeros, mcOut));
                break;
            }
            case CTABLE_EXPAND_SCALAR_WEIGHT: 
            case CTABLE_TRANSFORM_SCALAR_WEIGHT: {
                s3 = sec.getScalarInput(this.input3).getDoubleValue();
                out = in1.join(in2, numParts).mapValues((Function)new MapJoinSignature2()).mapPartitionsToPair((PairFlatMapFunction)new CTableFunction(ctableOp, s2, s3, this._ignoreZeros, mcOut));
                break;
            }
            case CTABLE_TRANSFORM_HISTOGRAM: {
                s2 = sec.getScalarInput(this.input2).getDoubleValue();
                s3 = sec.getScalarInput(this.input3).getDoubleValue();
                out = in1.mapValues((Function)new MapJoinSignature1()).mapPartitionsToPair((PairFlatMapFunction)new CTableFunction(ctableOp, s2, s3, this._ignoreZeros, mcOut));
                break;
            }
            case CTABLE_TRANSFORM_WEIGHTED_HISTOGRAM: {
                in3 = sec.getBinaryBlockRDDHandleForVariable(this.input3.getName());
                s2 = sec.getScalarInput(this.input2).getDoubleValue();
                out = in1.join(in3, numParts).mapValues((Function)new MapJoinSignature2()).mapPartitionsToPair((PairFlatMapFunction)new CTableFunction(ctableOp, s2, s3, this._ignoreZeros, mcOut));
                break;
            }
            default: {
                throw new DMLRuntimeException("Encountered an invalid ctable operation (" + (Object)((Object)ctableOp) + ") while executing instruction: " + this.toString());
            }
        }
        out = out.union(SparkUtils.getEmptyBlockRDD(sec.getSparkContext(), mcOut));
        out = RDDAggregateUtils.sumByKeyStable(out, numParts, false);
        sec.setRDDHandleForVariable(this.output.getName(), out);
        sec.addLineageRDD(this.output.getName(), this.input1.getName());
        if (ctableOp.hasSecondInput()) {
            sec.addLineageRDD(this.output.getName(), this.input2.getName());
        }
        if (ctableOp.hasThirdInput()) {
            sec.addLineageRDD(this.output.getName(), this.input3.getName());
        }
    }

    public static class MapJoinSignature3
    implements Function<Tuple2<Tuple2<MatrixBlock, MatrixBlock>, MatrixBlock>, MatrixBlock[]> {
        private static final long serialVersionUID = -5222678882354280164L;

        public MatrixBlock[] call(Tuple2<Tuple2<MatrixBlock, MatrixBlock>, MatrixBlock> v1) throws Exception {
            return ArrayUtils.toArray((MatrixBlock)((Tuple2)v1._1())._1(), (MatrixBlock)((Tuple2)v1._1())._2(), (MatrixBlock)v1._2());
        }
    }

    public static class MapJoinSignature2
    implements Function<Tuple2<MatrixBlock, MatrixBlock>, MatrixBlock[]> {
        private static final long serialVersionUID = 7690448020081435520L;

        public MatrixBlock[] call(Tuple2<MatrixBlock, MatrixBlock> v1) throws Exception {
            return ArrayUtils.toArray((MatrixBlock)v1._1(), (MatrixBlock)v1._2());
        }
    }

    public static class MapJoinSignature1
    implements Function<MatrixBlock, MatrixBlock[]> {
        private static final long serialVersionUID = -8819908424033945028L;

        public MatrixBlock[] call(MatrixBlock v1) throws Exception {
            return ArrayUtils.toArray(v1);
        }
    }

    private static class CTableFunction
    implements PairFlatMapFunction<Iterator<Tuple2<MatrixIndexes, MatrixBlock[]>>, MatrixIndexes, MatrixBlock> {
        private static final long serialVersionUID = 5348127596473232337L;
        private final Ctable.OperationTypes _ctableOp;
        private final double _scalar_input2;
        private final double _scalar_input3;
        private final boolean _ignoreZeros;
        private final long _dim1;
        private final long _dim2;
        private final int _brlen;
        private final int _bclen;

        public CTableFunction(Ctable.OperationTypes ctableOp, double s2, double s3, boolean ignoreZeros, MatrixCharacteristics mcOut) {
            this(ctableOp, s2, s3, ignoreZeros, false, mcOut);
        }

        public CTableFunction(Ctable.OperationTypes ctableOp, double s2, double s3, boolean ignoreZeros, boolean emitEmpty, MatrixCharacteristics mcOut) {
            this._ctableOp = ctableOp;
            this._scalar_input2 = s2;
            this._scalar_input3 = s3;
            this._ignoreZeros = ignoreZeros;
            this._dim1 = mcOut.getRows();
            this._dim2 = mcOut.getCols();
            this._brlen = mcOut.getRowsPerBlock();
            this._bclen = mcOut.getColsPerBlock();
        }

        public Iterator<Tuple2<MatrixIndexes, MatrixBlock>> call(Iterator<Tuple2<MatrixIndexes, MatrixBlock[]>> arg0) throws Exception {
            CTableMap map = new CTableMap();
            MatrixBlock block = null;
            while (arg0.hasNext()) {
                Tuple2<MatrixIndexes, MatrixBlock[]> tmp = arg0.next();
                MatrixIndexes ix = (MatrixIndexes)tmp._1();
                MatrixBlock[] mb = (MatrixBlock[])tmp._2();
                switch (this._ctableOp) {
                    case CTABLE_TRANSFORM: {
                        OperationsOnMatrixValues.performCtable(ix, mb[0], ix, mb[1], ix, mb[2], map, block, null);
                        break;
                    }
                    case CTABLE_EXPAND_SCALAR_WEIGHT: 
                    case CTABLE_TRANSFORM_SCALAR_WEIGHT: {
                        mb[0].ctableOperations(null, mb[1], this._scalar_input3, this._ignoreZeros, map, block);
                        break;
                    }
                    case CTABLE_TRANSFORM_HISTOGRAM: {
                        OperationsOnMatrixValues.performCtable(ix, mb[0], this._scalar_input2, this._scalar_input3, map, block, null);
                        break;
                    }
                    case CTABLE_TRANSFORM_WEIGHTED_HISTOGRAM: {
                        OperationsOnMatrixValues.performCtable(ix, (MatrixValue)mb[0], this._scalar_input2, ix, mb[1], map, block, null);
                        break;
                    }
                }
            }
            ReblockBuffer rbuff = new ReblockBuffer(Math.min(0x400000, map.size()), this._dim1, this._dim2, this._brlen, this._bclen);
            ArrayList<Tuple2<MatrixIndexes, MatrixBlock>> ret = new ArrayList<Tuple2<MatrixIndexes, MatrixBlock>>();
            Iterator<LongLongDoubleHashMap.ADoubleEntry> iter = map.getIterator();
            while (iter.hasNext()) {
                LongLongDoubleHashMap.ADoubleEntry e = iter.next();
                if (e.getKey1() > this._dim1 || e.getKey2() > this._dim2) continue;
                if (rbuff.getSize() >= rbuff.getCapacity()) {
                    this.flushBufferToList(rbuff, ret);
                }
                rbuff.appendCell(e.getKey1(), e.getKey2(), e.value);
            }
            if (rbuff.getSize() > 0) {
                this.flushBufferToList(rbuff, ret);
            }
            return ret.iterator();
        }

        protected void flushBufferToList(ReblockBuffer rbuff, ArrayList<Tuple2<MatrixIndexes, MatrixBlock>> ret) throws IOException, DMLRuntimeException {
            rbuff.flushBufferToBinaryBlocks().stream().map(b -> SparkUtils.fromIndexedMatrixBlock(b)).forEach(b -> ret.add((Tuple2<MatrixIndexes, MatrixBlock>)b));
        }
    }
}

