/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.matrix.data.hadoopfix;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.Mapper;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.sysml.runtime.matrix.data.hadoopfix.DelegatingInputFormat;
import org.apache.sysml.runtime.matrix.mapred.MRConfigurationNames;

public class MultipleInputs {
    public static void addInputPath(JobConf conf, Path path, Class<? extends InputFormat> inputFormatClass) {
        String inputFormatMapping = path.toString() + ";" + inputFormatClass.getName();
        String inputFormats = conf.get(MRConfigurationNames.MR_INPUT_MULTIPLEINPUTS_DIR_FORMATS);
        conf.set(MRConfigurationNames.MR_INPUT_MULTIPLEINPUTS_DIR_FORMATS, inputFormats == null ? inputFormatMapping : inputFormats + "," + inputFormatMapping);
        conf.setInputFormat(DelegatingInputFormat.class);
    }

    static Map<Path, InputFormat> getInputFormatMap(JobConf conf) {
        String[] pathMappings;
        HashMap<Path, InputFormat> m = new HashMap<Path, InputFormat>();
        for (String pathMapping : pathMappings = conf.get(MRConfigurationNames.MR_INPUT_MULTIPLEINPUTS_DIR_FORMATS).split(",")) {
            InputFormat inputFormat;
            String[] split = pathMapping.split(";");
            try {
                inputFormat = (InputFormat)ReflectionUtils.newInstance(conf.getClassByName(split[1]), conf);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
            m.put(new Path(split[0]), inputFormat);
        }
        return m;
    }

    static Map<Path, Class<? extends Mapper>> getMapperTypeMap(JobConf conf) {
        String[] pathMappings;
        if (conf.get(MRConfigurationNames.MR_INPUT_MULTIPLEINPUTS_DIR_MAPPERS) == null) {
            return Collections.emptyMap();
        }
        HashMap<Path, Class<? extends Mapper>> m = new HashMap<Path, Class<? extends Mapper>>();
        for (String pathMapping : pathMappings = conf.get(MRConfigurationNames.MR_INPUT_MULTIPLEINPUTS_DIR_MAPPERS).split(",")) {
            Class<?> mapClass;
            String[] split = pathMapping.split(";");
            try {
                mapClass = conf.getClassByName(split[1]);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
            m.put(new Path(split[0]), mapClass);
        }
        return m;
    }
}

