/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.matrix.mapred;

import java.io.IOException;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.Mapper;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reporter;
import org.apache.sysml.hops.Hop;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.instructions.mr.DataGenMRInstruction;
import org.apache.sysml.runtime.instructions.mr.RandInstruction;
import org.apache.sysml.runtime.matrix.data.LibMatrixDatagen;
import org.apache.sysml.runtime.matrix.data.MatrixBlock;
import org.apache.sysml.runtime.matrix.data.MatrixIndexes;
import org.apache.sysml.runtime.matrix.data.RandomMatrixGenerator;
import org.apache.sysml.runtime.matrix.mapred.GMRMapper;
import org.apache.sysml.runtime.matrix.mapred.MapperBase;

public class DataGenMapper
extends GMRMapper
implements Mapper<Writable, Writable, Writable, Writable> {
    private MatrixIndexes[] indexes = null;
    private MatrixBlock[] block = null;

    @Override
    public void map(Writable key, Writable valueString, OutputCollector<Writable, Writable> out, Reporter reporter) throws IOException {
        this.cachedReporter = reporter;
        long start = System.currentTimeMillis();
        for (int i = 0; i < this.representativeMatrixes.size(); ++i) {
            DataGenMRInstruction genInst = (DataGenMRInstruction)this.dataGen_instructions.get(i);
            if (genInst.getDataGenMethod() == Hop.DataGenMethod.RAND) {
                RandInstruction randInst = (RandInstruction)genInst;
                String[] params = valueString.toString().split(",");
                long blockRowNumber = Long.parseLong(params[0]);
                long blockColNumber = Long.parseLong(params[1]);
                int blockRowSize = Integer.parseInt(params[2]);
                int blockColSize = Integer.parseInt(params[3]);
                long seed = Long.parseLong(params[4]);
                double minValue = randInst.getMinValue();
                double maxValue = randInst.getMaxValue();
                double sparsity = randInst.getSparsity();
                String pdf = randInst.getProbabilityDensityFunction().toLowerCase();
                try {
                    this.indexes[i].setIndexes(blockRowNumber, blockColNumber);
                    RandomMatrixGenerator rgen = LibMatrixDatagen.createRandomMatrixGenerator(pdf, blockRowSize, blockColSize, blockRowSize, blockColSize, sparsity, minValue, maxValue, randInst.getPdfParams());
                    this.block[i].randOperationsInPlace(rgen, null, seed);
                }
                catch (DMLRuntimeException e) {
                    throw new IOException(e);
                }
            } else if (genInst.getDataGenMethod() == Hop.DataGenMethod.SEQ) {
                String[] params = valueString.toString().split(",");
                long blockRowNumber = Long.parseLong(params[0]);
                long blockColNumber = Long.parseLong(params[1]);
                double from = Double.parseDouble(params[2]);
                double to = Double.parseDouble(params[3]);
                double incr = Double.parseDouble(params[4]);
                incr = LibMatrixDatagen.updateSeqIncr(from, to, incr);
                try {
                    this.indexes[i].setIndexes(blockRowNumber, blockColNumber);
                    this.block[i].seqOperationsInPlace(from, to, incr);
                }
                catch (DMLRuntimeException e) {
                    throw new IOException(e);
                }
            } else {
                throw new IOException("Unknown data generation instruction: " + genInst.toString());
            }
            this.cachedValues.reset();
            this.cachedValues.set(genInst.output, this.indexes[i], this.block[i]);
            this.specialOperationsForActualMap(i, out, reporter);
        }
        reporter.incrCounter(MapperBase.Counters.MAP_TIME, System.currentTimeMillis() - start);
    }

    @Override
    public void configure(JobConf job) {
        super.configure(job);
        this.indexes = new MatrixIndexes[this.representativeMatrixes.size()];
        this.block = new MatrixBlock[this.representativeMatrixes.size()];
        for (int i = 0; i < this.representativeMatrixes.size(); ++i) {
            this.indexes[i] = new MatrixIndexes();
            this.block[i] = new MatrixBlock();
        }
    }
}

